/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.CharBuffer;

class NativeString
implements CharSequence,
Comparable {
    private String value;
    private Pointer pointer;

    public NativeString(String string2) {
        this(string2, false);
    }

    public NativeString(String string2, boolean wide) {
        this.value = string2;
        if (string2 == null) {
            throw new NullPointerException("String must not be null");
        }
        if (wide) {
            int len = (string2.length() + 1) * Native.WCHAR_SIZE;
            this.pointer = new Memory(len);
            this.pointer.setString(0L, string2, true);
        } else {
            byte[] data = Native.getBytes(string2);
            this.pointer = new Memory(data.length + 1);
            this.pointer.setString(0L, string2);
        }
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof CharSequence) {
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public String toString() {
        return this.value;
    }

    public Pointer getPointer() {
        return this.pointer;
    }

    public char charAt(int index2) {
        return this.value.charAt(index2);
    }

    public int length() {
        return this.value.length();
    }

    public CharSequence subSequence(int start2, int end2) {
        return CharBuffer.wrap(this.value).subSequence(start2, end2);
    }

    public int compareTo(Object other) {
        if (other == null) {
            return 1;
        }
        return this.value.compareTo(other.toString());
    }
}

