/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.ast.Node;
import org.joni.constants.StringType;
import org.joni.encoding.Encoding;

public final class StringNode
extends Node
implements StringType {
    private static final int NODE_STR_MARGIN = 16;
    private static final int NODE_STR_BUF_SIZE = 24;
    public byte[] bytes;
    public int p;
    public int end;
    int flag;

    public StringNode() {
        this.bytes = new byte[24];
    }

    public StringNode(byte[] bytes, int p2, int end2) {
        this.bytes = bytes;
        this.p = p2;
        this.end = end2;
        this.setShared();
    }

    public StringNode(byte c) {
        this();
        this.bytes[this.end++] = c;
    }

    public void ensure(int ahead) {
        int len = this.end - this.p + ahead;
        if (len >= this.bytes.length) {
            byte[] tmp = new byte[len + 16];
            System.arraycopy(this.bytes, this.p, tmp, 0, this.end - this.p);
            this.bytes = tmp;
        }
    }

    private void modifyEnsure(int ahead) {
        int len = this.end - this.p + ahead;
        if (this.isShared()) {
            byte[] tmp = new byte[len + 16];
            System.arraycopy(this.bytes, this.p, tmp, 0, this.end - this.p);
            this.bytes = tmp;
            this.end -= this.p;
            this.p = 0;
            this.clearShared();
        } else if (len >= this.bytes.length) {
            byte[] tmp = new byte[len + 16];
            System.arraycopy(this.bytes, this.p, tmp, 0, this.end - this.p);
            this.bytes = tmp;
        }
    }

    public int getType() {
        return 0;
    }

    public String getName() {
        return "String";
    }

    public String toString(int level2) {
        StringBuilder value2 = new StringBuilder();
        value2.append("\n  bytes: ");
        for (int i = this.p; i < this.end; ++i) {
            if ((this.bytes[i] & 0xFF) >= 32 && (this.bytes[i] & 0xFF) < 127) {
                value2.append((char)this.bytes[i]);
                continue;
            }
            value2.append(String.format(" 0x%02x", this.bytes[i]));
        }
        return value2.toString();
    }

    public int length() {
        return this.end - this.p;
    }

    public int length(Encoding enc) {
        return enc.strLength(this.bytes, this.p, this.end);
    }

    public StringNode splitLastChar(Encoding enc) {
        int prev;
        StringNode n = null;
        if (this.end > this.p && (prev = enc.prevCharHead(this.bytes, this.p, this.end)) != -1 && prev > this.p) {
            n = new StringNode(this.bytes, prev, this.end);
            if (this.isRaw()) {
                n.setRaw();
            }
            this.end = prev;
        }
        return n;
    }

    public boolean canBeSplit(Encoding enc) {
        if (this.end > this.p) {
            return enc.length(this.bytes[this.p]) < this.end - this.p;
        }
        return false;
    }

    public void set(byte[] bytes, int p2, int end2) {
        this.bytes = bytes;
        this.p = p2;
        this.end = end2;
        this.setShared();
    }

    public void cat(byte[] cat, int catP, int catEnd) {
        int len = catEnd - catP;
        this.modifyEnsure(len);
        System.arraycopy(cat, catP, this.bytes, this.end, len);
        this.end += len;
    }

    public void cat(byte c) {
        this.modifyEnsure(1);
        this.bytes[this.end++] = c;
    }

    public void clear() {
        if (this.bytes.length > 24) {
            this.bytes = new byte[24];
        }
        this.flag = 0;
        this.end = 0;
        this.p = 0;
    }

    public void setRaw() {
        this.flag |= 1;
    }

    public void clearRaw() {
        this.flag &= 0xFFFFFFFE;
    }

    public boolean isRaw() {
        return (this.flag & 1) != 0;
    }

    public void setAmbig() {
        this.flag |= 2;
    }

    public void clearAmbig() {
        this.flag &= 0xFFFFFFFD;
    }

    public boolean isAmbig() {
        return (this.flag & 2) != 0;
    }

    public void setDontGetOptInfo() {
        this.flag |= 4;
    }

    public void clearDontGetOptInfo() {
        this.flag &= 0xFFFFFFFB;
    }

    public boolean isDontGetOptInfo() {
        return (this.flag & 4) != 0;
    }

    public void setShared() {
        this.flag |= 8;
    }

    public void clearShared() {
        this.flag &= 0xFFFFFFF7;
    }

    public boolean isShared() {
        return (this.flag & 8) != 0;
    }
}

