/*
 * Decompiled with CFR 0.152.
 */
package org.joni.encoding.specific;

import org.joni.CodeRangeBuffer;
import org.joni.IntHolder;
import org.joni.encoding.EucEncoding;
import org.joni.encoding.specific.ASCIIEncoding;
import org.joni.exception.InternalException;
import org.joni.exception.ValueException;
import org.joni.util.BytesHash;

public final class EUCJPEncoding
extends EucEncoding {
    private static final int[] CR_Hiragana = new int[]{1, 42145, 42227};
    private static final int[] CR_Katakana = new int[]{3, 42401, 42486, 43686, 43695, 43697, 43741};
    private static final int[][] PropertyList = new int[][]{CR_Hiragana, CR_Katakana};
    private static final BytesHash<Integer> CTypeNameHash = new BytesHash();
    static final int[] EUCJPEncLen;
    public static final EUCJPEncoding INSTANCE;

    protected EUCJPEncoding() {
        super(EUCJPEncLen, ASCIIEncoding.AsciiCtypeTable);
    }

    public String toString() {
        return "EUC-JP";
    }

    public int maxLength() {
        return 3;
    }

    public int minLength() {
        return 1;
    }

    public boolean isFixedWidth() {
        return false;
    }

    public int mbcToCode(byte[] bytes, int p2, int end2) {
        int len = this.length(bytes[p2]);
        int n = bytes[p2++] & 0xFF;
        if (len == 1) {
            return n;
        }
        for (int i = 1; i < len && p2 < end2; ++i) {
            int c = bytes[p2++] & 0xFF;
            n <<= 8;
            n += c;
        }
        return n;
    }

    public int codeToMbcLength(int code) {
        if (EUCJPEncoding.isAscii(code)) {
            return 1;
        }
        if ((code & 0xFF0000) != 0) {
            return 3;
        }
        if ((code & 0xFF00) != 0) {
            return 2;
        }
        throw new ValueException("invalid code point value");
    }

    public int codeToMbc(int code, byte[] bytes, int p2) {
        int p_ = p2;
        if ((code & 0xFF0000) != 0) {
            bytes[p_++] = (byte)(code >> 16 & 0xFF);
        }
        if ((code & 0xFF00) != 0) {
            bytes[p_++] = (byte)(code >> 8 & 0xFF);
        }
        bytes[p_++] = (byte)(code & 0xFF);
        if (this.length(bytes[p_]) != p_ - p2) {
            throw new InternalException("invalid code point value");
        }
        return p_ - p2;
    }

    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end2, byte[] lower) {
        int p2 = pp.value++;
        int lowerP = 0;
        if (EUCJPEncoding.isMbcAscii(bytes[p2])) {
            lower[lowerP] = ASCIIEncoding.AsciiToLowerCaseTable[bytes[p2] & 0xFF];
            return 1;
        }
        int len = this.length(bytes[p2]);
        for (int i = 0; i < len; ++i) {
            lower[lowerP++] = bytes[p2++];
        }
        pp.value += len;
        return len;
    }

    protected boolean isLead(int c) {
        return (c - 161 & 0xFF) > 93;
    }

    public boolean isReverseMatchAllowed(byte[] bytes, int p2, int end2) {
        int c = bytes[p2] & 0xFF;
        return c <= 126 || c == 142 || c == 143;
    }

    public int propertyNameToCType(byte[] bytes, int p2, int end2) {
        Integer ctype = CTypeNameHash.get(bytes, p2, end2);
        if (ctype == null) {
            return super.propertyNameToCType(bytes, p2, end2);
        }
        return ctype;
    }

    public boolean isCodeCType(int code, int ctype) {
        if (ctype <= 14) {
            if (code < 128) {
                return this.isCodeCTypeInternal(code, ctype);
            }
            if (EUCJPEncoding.isWordGraphPrint(ctype)) {
                return this.codeToMbcLength(code) > 1;
            }
        } else {
            if ((ctype -= 15) >= PropertyList.length) {
                throw new InternalException("undefined type (bug)");
            }
            return CodeRangeBuffer.isInCodeRange(PropertyList[ctype], code);
        }
        return false;
    }

    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        if (ctype <= 14) {
            return null;
        }
        sbOut.value = 128;
        if ((ctype -= 15) >= PropertyList.length) {
            throw new InternalException("undefined type (bug)");
        }
        return PropertyList[ctype];
    }

    static {
        CTypeNameHash.put("Hiragana".getBytes(), 15);
        CTypeNameHash.put("Katakana".getBytes(), 16);
        EUCJPEncLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1};
        INSTANCE = new EUCJPEncoding();
    }
}

