/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IncludedModuleWrapper
extends RubyClass {
    private final RubyModule delegate;

    public IncludedModuleWrapper(Ruby runtime2, RubyClass superClass, RubyModule delegate) {
        super(runtime2, superClass, false);
        this.delegate = delegate;
        this.metaClass = delegate.metaClass;
    }

    @Override
    public IncludedModuleWrapper newIncludeClass(RubyClass superClass) {
        IncludedModuleWrapper includedModule = new IncludedModuleWrapper(this.getRuntime(), superClass, this.getNonIncludedClass());
        if (this.getSuperClass() != null) {
            includedModule.includeModule(this.getSuperClass());
        }
        return includedModule;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isIncluded() {
        return true;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public void setMetaClass(RubyClass newRubyClass) {
        throw new UnsupportedOperationException("An included class is only a wrapper for a module");
    }

    @Override
    public Map<String, DynamicMethod> getMethods() {
        return this.delegate.getMethods();
    }

    @Override
    public void addMethod(String name2, DynamicMethod method2) {
        throw new UnsupportedOperationException("An included class is only a wrapper for a module");
    }

    public void setMethods(Map newMethods) {
        throw new UnsupportedOperationException("An included class is only a wrapper for a module");
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public RubyModule getNonIncludedClass() {
        return this.delegate;
    }

    @Override
    public RubyClass getRealClass() {
        return this.getSuperClass().getRealClass();
    }

    @Override
    protected boolean isSame(RubyModule module) {
        return this.delegate.isSame(module);
    }

    @Override
    public IRubyObject id() {
        return this.delegate.id();
    }

    @Override
    protected boolean variableTableContains(String name2) {
        return this.delegate.variableTableContains(name2);
    }

    @Override
    protected boolean variableTableFastContains(String internedName) {
        return this.delegate.variableTableFastContains(internedName);
    }

    @Override
    protected IRubyObject variableTableFetch(String name2) {
        return this.delegate.variableTableFetch(name2);
    }

    @Override
    protected IRubyObject variableTableFastFetch(String internedName) {
        return this.delegate.variableTableFastFetch(internedName);
    }

    @Override
    protected IRubyObject variableTableStore(String name2, IRubyObject value2) {
        return this.delegate.variableTableStore(name2, value2);
    }

    @Override
    protected IRubyObject variableTableFastStore(String internedName, IRubyObject value2) {
        return this.delegate.variableTableFastStore(internedName, value2);
    }

    @Override
    protected IRubyObject variableTableRemove(String name2) {
        return this.delegate.variableTableRemove(name2);
    }

    @Override
    protected RubyObject.VariableTableEntry[] variableTableGetTable() {
        return this.delegate.variableTableGetTable();
    }

    @Override
    protected int variableTableGetSize() {
        return this.delegate.variableTableGetSize();
    }

    @Override
    protected void variableTableSync(List<Variable<IRubyObject>> vars) {
        this.delegate.variableTableSync(vars);
    }

    @Override
    protected IRubyObject variableTableReadLocked(RubyObject.VariableTableEntry entry) {
        return this.delegate.variableTableReadLocked(entry);
    }

    @Override
    @Deprecated
    protected Map variableTableGetMap() {
        return this.delegate.variableTableGetMap();
    }

    @Override
    @Deprecated
    protected Map variableTableGetMap(Map map) {
        return this.delegate.variableTableGetMap(map);
    }

    @Override
    protected boolean constantTableContains(String name2) {
        return this.delegate.constantTableContains(name2);
    }

    @Override
    protected boolean constantTableFastContains(String internedName) {
        return this.delegate.constantTableFastContains(internedName);
    }

    @Override
    protected IRubyObject constantTableFetch(String name2) {
        return this.delegate.constantTableFetch(name2);
    }

    @Override
    protected IRubyObject constantTableFastFetch(String internedName) {
        return this.delegate.constantTableFastFetch(internedName);
    }

    @Override
    protected IRubyObject constantTableStore(String name2, IRubyObject value2) {
        return this.delegate.constantTableStore(name2, value2);
    }

    @Override
    protected IRubyObject constantTableFastStore(String internedName, IRubyObject value2) {
        return this.delegate.constantTableFastStore(internedName, value2);
    }

    @Override
    protected IRubyObject constantTableRemove(String name2) {
        return this.delegate.constantTableRemove(name2);
    }

    @Override
    protected RubyModule.ConstantTableEntry[] constantTableGetTable() {
        return this.delegate.constantTableGetTable();
    }

    @Override
    protected int constantTableGetSize() {
        return this.delegate.constantTableGetSize();
    }

    @Override
    protected void constantTableSync(List<Variable<IRubyObject>> vars) {
        this.delegate.constantTableSync(vars);
    }

    @Override
    @Deprecated
    protected Map constantTableGetMap() {
        return this.delegate.constantTableGetMap();
    }

    @Override
    @Deprecated
    protected Map constantTableGetMap(Map map) {
        return this.delegate.constantTableGetMap(map);
    }
}

