/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Integer"}, parent="Numeric", include={"Precision"})
public abstract class RubyInteger
extends RubyNumeric {
    public static RubyClass createIntegerClass(Ruby runtime2) {
        RubyClass integer = runtime2.defineClass("Integer", runtime2.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setInteger(integer);
        integer.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyInteger;
            }
        };
        integer.getSingletonClass().undefineMethod("new");
        integer.includeModule(runtime2.getPrecision());
        integer.defineAnnotatedMethods(RubyInteger.class);
        return integer;
    }

    public RubyInteger(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public RubyInteger(Ruby runtime2, RubyClass rubyClass, boolean useObjectSpace) {
        super(runtime2, rubyClass, useObjectSpace);
    }

    public RubyInteger convertToInteger() {
        return this;
    }

    protected RubyFloat toFloat() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"upto"}, frame=true)
    public IRubyObject upto(ThreadContext context, IRubyObject to, Block block) {
        Ruby runtime2 = this.getRuntime();
        if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
            RubyFixnum toFixnum = (RubyFixnum)to;
            long toValue = toFixnum.getLongValue();
            long fromValue = this.getLongValue();
            if (block.getBody().getArgumentType() == 0) {
                IRubyObject nil = runtime2.getNil();
                for (long i = fromValue; i <= toValue; ++i) {
                    block.yield(context, nil);
                }
            } else {
                for (long i = fromValue; i <= toValue; ++i) {
                    block.yield(context, RubyFixnum.newFixnum(runtime2, i));
                }
            }
        } else {
            RubyNumeric i = this;
            while (!i.callMethod(context, MethodIndex.OP_GT, ">", to).isTrue()) {
                block.yield(context, i);
                i = (RubyNumeric)i.callMethod(context, MethodIndex.OP_PLUS, "+", RubyFixnum.one(runtime2));
            }
        }
        return this;
    }

    @JRubyMethod(name={"downto"}, frame=true)
    public IRubyObject downto(ThreadContext context, IRubyObject to, Block block) {
        Ruby runtime2 = this.getRuntime();
        if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
            RubyFixnum toFixnum = (RubyFixnum)to;
            long toValue = toFixnum.getLongValue();
            if (block.getBody().getArgumentType() == 0) {
                IRubyObject nil = runtime2.getNil();
                for (long i = this.getLongValue(); i >= toValue; --i) {
                    block.yield(context, nil);
                }
            } else {
                for (long i = this.getLongValue(); i >= toValue; --i) {
                    block.yield(context, RubyFixnum.newFixnum(this.getRuntime(), i));
                }
            }
        } else {
            RubyNumeric i = this;
            while (!i.callMethod(context, MethodIndex.OP_LT, "<", to).isTrue()) {
                block.yield(context, i);
                i = (RubyNumeric)i.callMethod(context, MethodIndex.OP_MINUS, "-", RubyFixnum.one(this.getRuntime()));
            }
        }
        return this;
    }

    @JRubyMethod(name={"times"}, frame=true)
    public IRubyObject times(ThreadContext context, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (this instanceof RubyFixnum) {
            long value2 = this.getLongValue();
            if (block.getBody().getArgumentType() == 0) {
                IRubyObject nil = runtime2.getNil();
                for (long i = 0L; i < value2; ++i) {
                    block.yield(context, nil);
                }
            } else {
                for (long i = 0L; i < value2; ++i) {
                    block.yield(context, RubyFixnum.newFixnum(runtime2, i));
                }
            }
        } else {
            RubyNumeric i = RubyFixnum.zero(runtime2);
            while (i.callMethod(context, MethodIndex.OP_LT, "<", this).isTrue()) {
                block.yield(context, i);
                i = (RubyNumeric)i.callMethod(context, MethodIndex.OP_PLUS, "+", RubyFixnum.one(runtime2));
            }
        }
        return this;
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext context) {
        if (this instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(this.getRuntime(), this.getLongValue() + 1L);
        }
        return this.callMethod(context, MethodIndex.OP_PLUS, "+", RubyFixnum.one(this.getRuntime()));
    }

    @JRubyMethod(name={"chr"})
    public RubyString chr() {
        if (this.getLongValue() < 0L || this.getLongValue() > 255L) {
            throw this.getRuntime().newRangeError(this.toString() + " out of char range");
        }
        return RubyString.newString(this.getRuntime(), new ByteList(new byte[]{(byte)this.getLongValue()}, false));
    }

    @JRubyMethod(name={"to_i", "to_int", "floor", "ceil", "round", "truncate"})
    public RubyInteger to_i() {
        return this;
    }

    @JRubyMethod(name={"to_r"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_r(ThreadContext context) {
        return RubyRational.newRationalCanonicalize(context, this);
    }

    @JRubyMethod(name={"odd?"})
    public static RubyBoolean odd_p(ThreadContext context, IRubyObject recv2) {
        if (recv2.callMethod(context, "%", recv2.getRuntime().newFixnum(2)) != RubyFixnum.zero(recv2.getRuntime())) {
            return recv2.getRuntime().getTrue();
        }
        return recv2.getRuntime().getFalse();
    }

    @JRubyMethod(name={"even?"})
    public static RubyBoolean even_p(ThreadContext context, IRubyObject recv2) {
        if (recv2.callMethod(context, "%", recv2.getRuntime().newFixnum(2)) == RubyFixnum.zero(recv2.getRuntime())) {
            return recv2.getRuntime().getTrue();
        }
        return recv2.getRuntime().getFalse();
    }

    @JRubyMethod
    public static IRubyObject pred(ThreadContext context, IRubyObject recv2) {
        return recv2.callMethod(context, "-", recv2.getRuntime().newFixnum(1));
    }

    @JRubyMethod(name={"induced_from"}, meta=true)
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return other;
        }
        if (other instanceof RubyFloat || other instanceof RubyRational) {
            return other.callMethod(context, MethodIndex.TO_I, "to_i");
        }
        throw recv2.getRuntime().newTypeError("failed to convert " + other.getMetaClass().getName() + " into Integer");
    }
}

