/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;

@JRubyClass(name={"Symbol"})
public class RubySymbol
extends RubyObject {
    private final String symbol;
    private final int id;
    private final ByteList symbolBytes;

    private RubySymbol(Ruby runtime2, String internedSymbol) {
        super(runtime2, runtime2.getSymbol(), false);
        assert (internedSymbol == internedSymbol.intern()) : internedSymbol + " is not interned";
        this.symbol = internedSymbol;
        this.symbolBytes = ByteList.create(this.symbol);
        this.id = runtime2.allocSymbolId();
    }

    public static RubyClass createSymbolClass(Ruby runtime2) {
        RubyClass symbolClass = runtime2.defineClass("Symbol", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setSymbol(symbolClass);
        RubyClass symbolMetaClass = symbolClass.getMetaClass();
        symbolClass.index = 8;
        symbolClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubySymbol;
            }
        };
        symbolClass.defineAnnotatedMethods(RubySymbol.class);
        symbolMetaClass.undefineMethod("new");
        return symbolClass;
    }

    public int getNativeTypeIndex() {
        return 8;
    }

    public String asJavaString() {
        return this.symbol;
    }

    public final boolean eql(IRubyObject other) {
        return other == this;
    }

    public boolean isImmediate() {
        return true;
    }

    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    public static RubySymbol getSymbolLong(Ruby runtime2, long id2) {
        return runtime2.getSymbolTable().lookup(id2);
    }

    public static RubySymbol newSymbol(Ruby runtime2, String name2) {
        return runtime2.getSymbolTable().getSymbol(name2);
    }

    @JRubyMethod(name={"to_i"})
    public RubyFixnum to_i() {
        return this.getRuntime().newFixnum(this.id);
    }

    @JRubyMethod(name={"to_int"})
    public RubyFixnum to_int() {
        if (this.getRuntime().getVerbose().isTrue()) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYMBOL_AS_INTEGER, "treating Symbol as an integer", new Object[0]);
        }
        return this.to_i();
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        Ruby runtime2 = this.getRuntime();
        return runtime2.newString(":" + (RubySymbol.isSymbolName(this.symbol) ? this.symbol : RubyString.newStringShared(runtime2, this.symbolBytes).dump().toString()));
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return RubyString.newStringShared(this.getRuntime(), this.symbolBytes);
    }

    @JRubyMethod(name={"id2name"})
    public IRubyObject id2name() {
        return this.to_s();
    }

    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return super.op_equal(context, other);
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    public int hashCode() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        return other == this;
    }

    @JRubyMethod(name={"to_sym"})
    public IRubyObject to_sym() {
        return this;
    }

    public IRubyObject freeze(ThreadContext context) {
        return this;
    }

    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    private static boolean isIdentStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isIdentChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isIdentifier(String s) {
        if (s == null || s.length() <= 0) {
            return false;
        }
        if (!RubySymbol.isIdentStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (RubySymbol.isIdentChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpecialGlobalName(String s) {
        if (s == null || s.length() <= 0) {
            return false;
        }
        int length2 = s.length();
        switch (s.charAt(0)) {
            case '!': 
            case '\"': 
            case '$': 
            case '&': 
            case '\'': 
            case '*': 
            case '+': 
            case ',': 
            case '.': 
            case '/': 
            case '0': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '`': 
            case '~': {
                return length2 == 1;
            }
            case '-': {
                return length2 == 1 || length2 == 2 && RubySymbol.isIdentChar(s.charAt(1));
            }
        }
        for (int i = 0; i < length2; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSymbolName(String s) {
        char d;
        int last2;
        if (s == null || s.length() < 1) {
            return false;
        }
        int length2 = s.length();
        char c = s.charAt(0);
        switch (c) {
            case '$': {
                if (length2 > 1 && RubySymbol.isSpecialGlobalName(s.substring(1))) {
                    return true;
                }
                return RubySymbol.isIdentifier(s.substring(1));
            }
            case '@': {
                int offset2 = 1;
                if (length2 >= 2 && s.charAt(1) == '@') {
                    ++offset2;
                }
                return RubySymbol.isIdentifier(s.substring(offset2));
            }
            case '<': {
                return length2 == 1 || length2 == 2 && (s.equals("<<") || s.equals("<=")) || length2 == 3 && s.equals("<=>");
            }
            case '>': {
                return length2 == 1 || length2 == 2 && (s.equals(">>") || s.equals(">="));
            }
            case '=': {
                return length2 == 2 && (s.equals("==") || s.equals("=~")) || length2 == 3 && s.equals("===");
            }
            case '*': {
                return length2 == 1 || length2 == 2 && s.equals("**");
            }
            case '+': {
                return length2 == 1 || length2 == 2 && s.equals("+@");
            }
            case '-': {
                return length2 == 1 || length2 == 2 && s.equals("-@");
            }
            case '%': 
            case '&': 
            case '/': 
            case '^': 
            case '`': 
            case '|': 
            case '~': {
                return length2 == 1;
            }
            case '[': {
                return s.equals("[]") || s.equals("[]=");
            }
        }
        if (!RubySymbol.isIdentStart(c)) {
            return false;
        }
        boolean localID = c >= 'a' && c <= 'z';
        for (last2 = 1; last2 < length2 && RubySymbol.isIdentChar(d = s.charAt(last2)); ++last2) {
        }
        if (last2 == length2) {
            return true;
        }
        if (localID && last2 == length2 - 1) {
            d = s.charAt(last2);
            return d == '!' || d == '?' || d == '=';
        }
        return false;
    }

    @JRubyMethod(name={"all_symbols"}, meta=true)
    public static IRubyObject all_symbols(IRubyObject recv2) {
        return recv2.getRuntime().getSymbolTable().all_symbols();
    }

    public static RubySymbol unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol result = RubySymbol.newSymbol(input.getRuntime(), RubyString.byteListToString(input.unmarshalString()));
        input.registerLinkTarget(result);
        return result;
    }

    public static class SymbolTable {
        static final int DEFAULT_INITIAL_CAPACITY = 2048;
        static final int MAXIMUM_CAPACITY = 0x40000000;
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private final ReentrantLock tableLock = new ReentrantLock();
        private volatile SymbolEntry[] symbolTable;
        private int size;
        private int threshold;
        private final float loadFactor;
        private final Ruby runtime;

        public SymbolTable(Ruby runtime2) {
            this.runtime = runtime2;
            this.loadFactor = 0.75f;
            this.threshold = 1536;
            this.symbolTable = new SymbolEntry[2048];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RubySymbol getSymbol(String name2) {
            int hash2 = name2.hashCode();
            SymbolEntry[] table = this.symbolTable;
            SymbolEntry e = this.symbolTable[hash2 & table.length - 1];
            while (e != null) {
                if (hash2 == e.hash && name2.equals(e.name)) {
                    return e.symbol;
                }
                e = e.next;
            }
            ReentrantLock lock2 = this.tableLock;
            lock2.lock();
            try {
                int potentialNewSize = this.size + 1;
                table = potentialNewSize > this.threshold ? this.rehash() : this.symbolTable;
                int index2 = hash2 & table.length - 1;
                SymbolEntry e2 = table[index2];
                while (e2 != null) {
                    if (hash2 == e2.hash && name2.equals(e2.name)) {
                        RubySymbol rubySymbol = e2.symbol;
                        return rubySymbol;
                    }
                    e2 = e2.next;
                }
                String internedName = name2.intern();
                RubySymbol symbol = new RubySymbol(this.runtime, internedName);
                table[index2] = new SymbolEntry(hash2, internedName, symbol, table[index2]);
                this.size = potentialNewSize;
                this.symbolTable = table;
                RubySymbol rubySymbol = symbol;
                return rubySymbol;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RubySymbol fastGetSymbol(String internedName) {
            assert (internedName == internedName.intern()) : internedName + " is not interned";
            SymbolEntry[] table = this.symbolTable;
            SymbolEntry e = this.symbolTable[internedName.hashCode() & table.length - 1];
            while (e != null) {
                if (internedName == e.name) {
                    return e.symbol;
                }
                e = e.next;
            }
            ReentrantLock lock2 = this.tableLock;
            lock2.lock();
            try {
                int potentialNewSize = this.size + 1;
                table = potentialNewSize > this.threshold ? this.rehash() : this.symbolTable;
                int hash2 = internedName.hashCode();
                int index2 = hash2 & table.length - 1;
                SymbolEntry e2 = table[index2];
                while (e2 != null) {
                    if (internedName == e2.name) {
                        RubySymbol rubySymbol = e2.symbol;
                        return rubySymbol;
                    }
                    e2 = e2.next;
                }
                RubySymbol symbol = new RubySymbol(this.runtime, internedName);
                table[index2] = new SymbolEntry(hash2, internedName, symbol, table[index2]);
                this.size = potentialNewSize;
                this.symbolTable = table;
                RubySymbol rubySymbol = symbol;
                return rubySymbol;
            }
            finally {
                lock2.unlock();
            }
        }

        public RubySymbol lookup(String name2) {
            int hash2 = name2.hashCode();
            SymbolEntry[] table = this.symbolTable;
            SymbolEntry e = this.symbolTable[hash2 & table.length - 1];
            while (e != null) {
                if (hash2 == e.hash && name2.equals(e.name)) {
                    return e.symbol;
                }
                e = e.next;
            }
            return null;
        }

        public RubySymbol lookup(long id2) {
            SymbolEntry[] table = this.symbolTable;
            int i = table.length;
            while (--i >= 0) {
                SymbolEntry e = table[i];
                while (e != null) {
                    if (id2 == (long)e.symbol.id) {
                        return e.symbol;
                    }
                    e = e.next;
                }
            }
            return null;
        }

        public RubyArray all_symbols() {
            SymbolEntry[] table = this.symbolTable;
            RubyArray array = this.runtime.newArray(this.size);
            int i = table.length;
            while (--i >= 0) {
                SymbolEntry e = table[i];
                while (e != null) {
                    array.append(e.symbol);
                    e = e.next;
                }
            }
            return array;
        }

        @Deprecated
        public void store(RubySymbol symbol) {
            throw new UnsupportedOperationException();
        }

        private SymbolEntry[] rehash() {
            SymbolEntry[] oldTable = this.symbolTable;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return oldTable;
            }
            int newCapacity = oldCapacity << 1;
            SymbolEntry[] newTable = new SymbolEntry[newCapacity];
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            int sizeMask = newCapacity - 1;
            int i = oldCapacity;
            while (--i >= 0) {
                int k;
                SymbolEntry e = oldTable[i];
                if (e == null) continue;
                SymbolEntry next2 = e.next;
                int idx = e.hash & sizeMask;
                if (next2 == null) {
                    newTable[idx] = e;
                    continue;
                }
                SymbolEntry lastRun = e;
                int lastIdx = idx;
                SymbolEntry last2 = next2;
                while (last2 != null) {
                    k = last2.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last2;
                    }
                    last2 = last2.next;
                }
                newTable[lastIdx] = lastRun;
                SymbolEntry p2 = e;
                while (p2 != lastRun) {
                    k = p2.hash & sizeMask;
                    SymbolEntry n = newTable[k];
                    newTable[k] = new SymbolEntry(p2.hash, p2.name, p2.symbol, n);
                    p2 = p2.next;
                }
            }
            this.symbolTable = newTable;
            return newTable;
        }

        static class SymbolEntry {
            final int hash;
            final String name;
            final RubySymbol symbol;
            final SymbolEntry next;

            SymbolEntry(int hash2, String name2, RubySymbol symbol, SymbolEntry next2) {
                this.hash = hash2;
                this.name = name2;
                this.symbol = symbol;
                this.next = next2;
            }
        }
    }

    private static class ToProcCallback
    implements BlockCallback {
        private RubySymbol symbol;

        public ToProcCallback(RubySymbol symbol) {
            this.symbol = symbol;
        }

        public IRubyObject call(ThreadContext ctx, IRubyObject[] args2, Block blk) {
            IRubyObject[] currentArgs = args2;
            switch (currentArgs.length) {
                case 0: {
                    throw this.symbol.getRuntime().newArgumentError("no receiver given");
                }
                case 1: {
                    if (currentArgs[0] instanceof RubyArray && ((RubyArray)currentArgs[0]).getLength() != 0) {
                        currentArgs = ((RubyArray)currentArgs[0]).toJavaArrayMaybeUnsafe();
                        IRubyObject[] args22 = new IRubyObject[currentArgs.length - 1];
                        System.arraycopy(currentArgs, 1, args22, 0, args22.length);
                        return RuntimeHelpers.invoke(ctx, currentArgs[0], this.symbol.symbol, args22);
                    }
                    return RuntimeHelpers.invoke(ctx, currentArgs[0], this.symbol.symbol);
                }
            }
            IRubyObject[] args23 = new IRubyObject[currentArgs.length - 1];
            System.arraycopy(currentArgs, 1, args23, 0, args23.length);
            return RuntimeHelpers.invoke(ctx, currentArgs[0], this.symbol.symbol, args23);
        }
    }
}

