/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AttrAssignTwoArgNode
extends AttrAssignNode {
    private Node arg1;
    private Node arg2;

    public AttrAssignTwoArgNode(ISourcePosition position, Node receiverNode, String name2, ArrayNode argsNode) {
        super(position, receiverNode, name2, argsNode);
        assert (argsNode.size() == 2) : "argsNode.size() is 2";
        this.arg1 = argsNode.get(0);
        this.arg2 = argsNode.get(1);
    }

    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver = this.receiverNode.interpret(runtime2, context, self, aBlock);
        IRubyObject param1 = this.arg1.interpret(runtime2, context, self, aBlock);
        IRubyObject param2 = this.arg2.interpret(runtime2, context, self, aBlock);
        assert (receiver.getMetaClass() != null) : receiver.getClass().getName();
        if (receiver == self) {
            this.variableCallAdapter.call(context, receiver, param1, param2);
        } else {
            this.normalCallAdapter.call(context, receiver, param1, param2);
        }
        return param2;
    }

    public IRubyObject assign(Ruby runtime2, ThreadContext context, IRubyObject self, IRubyObject value2, Block aBlock, boolean checkArity) {
        IRubyObject receiver = this.receiverNode.interpret(runtime2, context, self, aBlock);
        IRubyObject param1 = this.arg1.interpret(runtime2, context, self, aBlock);
        IRubyObject param2 = this.arg2.interpret(runtime2, context, self, aBlock);
        assert (receiver.getMetaClass() != null) : receiver.getClass().getName();
        if (receiver == self) {
            this.variableCallAdapter.call(context, receiver, param1, param2, value2);
        } else {
            this.normalCallAdapter.call(context, receiver, param1, param2, value2);
        }
        return runtime2.getNil();
    }
}

