/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ast.DStrNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.StrNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class DRegexpNode
extends ListNode
implements ILiteralNode {
    private final int options;
    private final boolean once;
    private RubyRegexp onceRegexp;

    public DRegexpNode(ISourcePosition position) {
        this(position, 0, false);
    }

    public DRegexpNode(ISourcePosition position, DStrNode node, int options2, boolean once) {
        this(position, options2, once);
        this.addAll(node);
    }

    public DRegexpNode(ISourcePosition position, int options2, boolean once) {
        super(position, NodeType.DREGEXPNODE);
        this.options = options2;
        this.once = once;
    }

    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDRegxNode(this);
    }

    public boolean getOnce() {
        return this.once;
    }

    public int getOptions() {
        return this.options;
    }

    public RubyRegexp getOnceRegexp() {
        return this.onceRegexp;
    }

    public void setOnceRegexp(RubyRegexp regexp) {
        if (this.once && this.onceRegexp == null) {
            this.onceRegexp = regexp;
        }
    }

    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyRegexp regexp;
        if (this.once && this.onceRegexp != null) {
            return this.onceRegexp;
        }
        RubyString string2 = runtime2.newString(new ByteList());
        for (int i = 0; i < this.size(); ++i) {
            Node iterNode = this.get(i);
            if (iterNode instanceof StrNode) {
                string2.getByteList().append(((StrNode)iterNode).getValue());
                continue;
            }
            string2.append(iterNode.interpret(runtime2, context, self, aBlock));
        }
        try {
            regexp = RubyRegexp.newRegexp(runtime2, string2.getByteList(), this.options);
        }
        catch (Exception e) {
            throw runtime2.newRegexpError(e.getMessage());
        }
        if (this.once) {
            this.setOnceRegexp(regexp);
        }
        return regexp;
    }
}

