/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import jruby.objectweb.asm.ClassVisitor;
import jruby.objectweb.asm.Label;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubySymbol;
import org.jruby.ast.NodeType;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;

public class FieldBasedCacheCompiler
implements CacheCompiler {
    protected StandardASMCompiler scriptCompiler;
    Map<String, String> sourcePositions = new HashMap<String, String>();
    Map<String, String> byteLists = new HashMap<String, String>();
    Map<BigInteger, String> bigIntegers = new HashMap<BigInteger, String>();
    Map<String, String> symbols = new HashMap<String, String>();
    Map<Long, String> fixnums = new HashMap<Long, String>();

    public FieldBasedCacheCompiler(StandardASMCompiler scriptCompiler) {
        this.scriptCompiler = scriptCompiler;
    }

    public void cacheCallSite(StandardASMCompiler.AbstractMethodCompiler method2, String name2, CallType callType) {
        String fieldName = this.scriptCompiler.getNewConstant(CodegenUtils.ci(CallSite.class), JavaNameMangler.mangleStringForCleanJavaIdentifier(name2));
        SkinnyMethodAdapter initMethod = this.scriptCompiler.getInitMethod();
        initMethod.aload(0);
        initMethod.ldc(name2);
        if (callType.equals(CallType.NORMAL)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.FUNCTIONAL)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getFunctionalCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.VARIABLE)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getVariableCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        }
        initMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
        method2.method.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
    }

    @Deprecated
    public void cachePosition(StandardASMCompiler.AbstractMethodCompiler method2, String file2, int line) {
        String cleanName = JavaNameMangler.mangleStringForCleanJavaIdentifier(file2 + "$" + line);
        String fieldName = this.sourcePositions.get(cleanName);
        if (fieldName == null) {
            SkinnyMethodAdapter clinitMethod = this.scriptCompiler.getClassInitMethod();
            fieldName = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(ISourcePosition.class), cleanName);
            this.sourcePositions.put(JavaNameMangler.mangleStringForCleanJavaIdentifier(file2 + "$" + line), fieldName);
            clinitMethod.ldc(file2);
            clinitMethod.ldc(line);
            clinitMethod.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "constructPosition", CodegenUtils.sig(ISourcePosition.class, String.class, Integer.TYPE));
            clinitMethod.putstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(ISourcePosition.class));
        }
        method2.method.getstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(ISourcePosition.class));
    }

    public void cacheByteList(StandardASMCompiler.AbstractMethodCompiler method2, String contents) {
        String fieldName = this.byteLists.get(contents);
        if (fieldName == null) {
            SkinnyMethodAdapter clinitMethod = this.scriptCompiler.getClassInitMethod();
            fieldName = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(ByteList.class), "byteList");
            this.byteLists.put(contents, fieldName);
            clinitMethod.ldc(contents);
            clinitMethod.invokestatic(CodegenUtils.p(ByteList.class), "create", CodegenUtils.sig(ByteList.class, CharSequence.class));
            clinitMethod.putstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(ByteList.class));
        }
        method2.method.getstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(ByteList.class));
    }

    public void cacheBigInteger(StandardASMCompiler.AbstractMethodCompiler method2, BigInteger bigint) {
        String fieldName = this.bigIntegers.get(bigint);
        if (fieldName == null) {
            SkinnyMethodAdapter clinitMethod = this.scriptCompiler.getClassInitMethod();
            fieldName = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(BigInteger.class), "bigInt");
            this.bigIntegers.put(bigint, fieldName);
            clinitMethod.newobj(CodegenUtils.p(BigInteger.class));
            clinitMethod.dup();
            clinitMethod.ldc(bigint.toString());
            clinitMethod.invokespecial(CodegenUtils.p(BigInteger.class), "<init>", CodegenUtils.sig(Void.TYPE, String.class));
            clinitMethod.putstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(BigInteger.class));
        }
        method2.method.getstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(BigInteger.class));
    }

    public void cacheSymbol(StandardASMCompiler.AbstractMethodCompiler method2, String symbol) {
        String methodName = this.symbols.get(symbol);
        if (methodName == null) {
            String fieldName = this.scriptCompiler.getNewConstant(CodegenUtils.ci(RubySymbol.class), "symbol");
            methodName = "getSymbol" + fieldName;
            this.symbols.put(symbol, methodName);
            ClassVisitor cv = this.scriptCompiler.getClassVisitor();
            SkinnyMethodAdapter symMethod = new SkinnyMethodAdapter(cv.visitMethod(4098, methodName, CodegenUtils.sig(RubySymbol.class, Ruby.class), null, null));
            symMethod.start();
            symMethod.aload(0);
            symMethod.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(RubySymbol.class));
            symMethod.dup();
            symMethod.astore(2);
            Label ifNullEnd = new Label();
            symMethod.ifnull(ifNullEnd);
            symMethod.aload(2);
            symMethod.areturn();
            symMethod.label(ifNullEnd);
            symMethod.aload(0);
            symMethod.aload(1);
            symMethod.ldc(symbol);
            symMethod.invokevirtual(CodegenUtils.p(Ruby.class), "fastNewSymbol", CodegenUtils.sig(RubySymbol.class, String.class));
            symMethod.dup_x1();
            symMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(RubySymbol.class));
            symMethod.areturn();
            symMethod.end();
        }
        method2.loadThis();
        method2.loadRuntime();
        method2.method.invokevirtual(this.scriptCompiler.getClassname(), methodName, CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(Ruby.class)));
    }

    public void cacheFixnum(StandardASMCompiler.AbstractMethodCompiler method2, long value2) {
        String methodName = this.fixnums.get(value2);
        if (methodName == null) {
            String fieldName = this.scriptCompiler.getNewConstant(CodegenUtils.ci(RubyFixnum.class), "symbol");
            methodName = "getFixnum" + fieldName;
            this.fixnums.put(value2, methodName);
            ClassVisitor cv = this.scriptCompiler.getClassVisitor();
            SkinnyMethodAdapter symMethod = new SkinnyMethodAdapter(cv.visitMethod(4098, methodName, CodegenUtils.sig(RubyFixnum.class, Ruby.class), null, null));
            symMethod.start();
            symMethod.aload(0);
            symMethod.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(RubyFixnum.class));
            symMethod.dup();
            symMethod.astore(2);
            Label ifNullEnd = new Label();
            symMethod.ifnull(ifNullEnd);
            symMethod.aload(2);
            symMethod.areturn();
            symMethod.label(ifNullEnd);
            symMethod.aload(0);
            symMethod.aload(1);
            symMethod.ldc(value2);
            symMethod.invokevirtual(CodegenUtils.p(Ruby.class), "newFixnum", CodegenUtils.sig(RubyFixnum.class, Long.TYPE));
            symMethod.dup_x1();
            symMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(RubyFixnum.class));
            symMethod.areturn();
            symMethod.end();
        }
        method2.loadThis();
        method2.loadRuntime();
        method2.method.invokevirtual(this.scriptCompiler.getClassname(), methodName, CodegenUtils.sig(RubyFixnum.class, CodegenUtils.params(Ruby.class)));
    }

    public void cacheClosure(StandardASMCompiler.AbstractMethodCompiler method2, String closureMethod, int arity2, StaticScope scope, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
        String closureFieldName = this.scriptCompiler.getNewConstant(CodegenUtils.ci(BlockBody.class), "closure");
        String closureMethodName = "getClosure_" + closureFieldName;
        ClassVisitor cv = this.scriptCompiler.getClassVisitor();
        SkinnyMethodAdapter closureGetter = new SkinnyMethodAdapter(cv.visitMethod(4098, closureMethodName, CodegenUtils.sig(BlockBody.class, ThreadContext.class), null, null));
        closureGetter.aload(0);
        closureGetter.getfield(this.scriptCompiler.getClassname(), closureFieldName, CodegenUtils.ci(BlockBody.class));
        closureGetter.dup();
        Label alreadyCreated = new Label();
        closureGetter.ifnonnull(alreadyCreated);
        closureGetter.pop();
        closureGetter.aload(0);
        closureGetter.aload(1);
        closureGetter.aload(0);
        closureGetter.ldc(closureMethod);
        closureGetter.pushInt(arity2);
        StandardASMCompiler.buildStaticScopeNames(closureGetter, scope);
        closureGetter.ldc(hasMultipleArgsHead);
        closureGetter.pushInt(BlockBody.asArgumentType(argsNodeId));
        closureGetter.ldc(!inspector.hasClosure() && !inspector.hasScopeAwareMethods());
        closureGetter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "createCompiledBlockBody", CodegenUtils.sig(BlockBody.class, ThreadContext.class, Object.class, String.class, Integer.TYPE, String[].class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE));
        closureGetter.putfield(this.scriptCompiler.getClassname(), closureFieldName, CodegenUtils.ci(BlockBody.class));
        closureGetter.aload(0);
        closureGetter.getfield(this.scriptCompiler.getClassname(), closureFieldName, CodegenUtils.ci(BlockBody.class));
        closureGetter.label(alreadyCreated);
        closureGetter.areturn();
        closureGetter.end();
        method2.loadThis();
        method2.loadThreadContext();
        method2.method.invokevirtual(this.scriptCompiler.getClassname(), closureMethodName, CodegenUtils.sig(BlockBody.class, ThreadContext.class));
    }

    public void cacheClosureOld(StandardASMCompiler.AbstractMethodCompiler method2, String closureMethod) {
        String closureFieldName = this.scriptCompiler.getNewConstant(CodegenUtils.ci(CompiledBlockCallback.class), "closure");
        String closureMethodName = "getClosure_" + closureFieldName;
        ClassVisitor cv = this.scriptCompiler.getClassVisitor();
        SkinnyMethodAdapter closureGetter = new SkinnyMethodAdapter(cv.visitMethod(4098, closureMethodName, CodegenUtils.sig(CompiledBlockCallback.class, Ruby.class), null, null));
        closureGetter.aload(0);
        closureGetter.getfield(this.scriptCompiler.getClassname(), closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
        closureGetter.dup();
        Label alreadyCreated = new Label();
        closureGetter.ifnonnull(alreadyCreated);
        closureGetter.pop();
        closureGetter.aload(0);
        closureGetter.aload(1);
        closureGetter.aload(0);
        closureGetter.ldc(closureMethod);
        closureGetter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "createBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, Ruby.class, Object.class, String.class));
        closureGetter.putfield(this.scriptCompiler.getClassname(), closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
        closureGetter.aload(0);
        closureGetter.getfield(this.scriptCompiler.getClassname(), closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
        closureGetter.label(alreadyCreated);
        closureGetter.areturn();
        closureGetter.end();
        method2.loadThis();
        method2.loadRuntime();
        method2.method.invokevirtual(this.scriptCompiler.getClassname(), closureMethodName, CodegenUtils.sig(CompiledBlockCallback.class, CodegenUtils.params(Ruby.class)));
    }
}

