/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"IPSocket"}, parent="BasicSocket")
public class RubyIPSocket
extends RubyBasicSocket {
    private static ObjectAllocator IPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyIPSocket(runtime2, klass);
        }
    };

    static void createIPSocket(Ruby runtime2) {
        RubyClass rb_cIPSocket = runtime2.defineClass("IPSocket", runtime2.fastGetClass("BasicSocket"), IPSOCKET_ALLOCATOR);
        rb_cIPSocket.defineAnnotatedMethods(RubyIPSocket.class);
        runtime2.getObject().fastSetConstant("IPsocket", rb_cIPSocket);
    }

    public RubyIPSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    protected static RuntimeException sockerr(IRubyObject recv2, String msg) {
        return new RaiseException(recv2.getRuntime(), recv2.getRuntime().fastGetClass("SocketError"), msg, true);
    }

    private IRubyObject addrFor(InetSocketAddress addr2) {
        IRubyObject[] ret = new IRubyObject[4];
        Ruby r = this.getRuntime();
        ret[0] = r.newString("AF_INET");
        ret[1] = r.newFixnum(addr2.getPort());
        ret[2] = r.isDoNotReverseLookupEnabled() ? r.newString(addr2.getAddress().getHostAddress()) : r.newString(addr2.getHostName());
        ret[3] = r.newString(addr2.getAddress().getHostAddress());
        return r.newArrayNoCopy(ret);
    }

    @JRubyMethod
    public IRubyObject addr() {
        InetSocketAddress address2 = this.getLocalSocket();
        if (address2 == null) {
            throw this.getRuntime().newErrnoENOTSOCKError("Not socket or not connected");
        }
        return this.addrFor(address2);
    }

    @JRubyMethod
    public IRubyObject peeraddr() {
        InetSocketAddress address2 = this.getRemoteSocket();
        if (address2 == null) {
            throw this.getRuntime().newErrnoENOTSOCKError("Not socket or not connected");
        }
        return this.addrFor(address2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject getaddress(IRubyObject recv2, IRubyObject hostname) {
        try {
            return recv2.getRuntime().newString(InetAddress.getByName(hostname.convertToString().toString()).getHostAddress());
        }
        catch (UnknownHostException e) {
            throw RubyIPSocket.sockerr(recv2, "getaddress: name or service not known");
        }
    }
}

