/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubySocket;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"TCPServer"}, parent="TCPSocket")
public class RubyTCPServer
extends RubyTCPSocket {
    private static ObjectAllocator TCPSERVER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyTCPServer(runtime2, klass);
        }
    };
    private ServerSocketChannel ssc;
    private InetSocketAddress socket_address;

    static void createTCPServer(Ruby runtime2) {
        RubyClass rb_cTCPServer = runtime2.defineClass("TCPServer", runtime2.fastGetClass("TCPSocket"), TCPSERVER_ALLOCATOR);
        rb_cTCPServer.defineAnnotatedMethods(RubyTCPServer.class);
        runtime2.getObject().fastSetConstant("TCPserver", rb_cTCPServer);
    }

    public RubyTCPServer(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, visibility=Visibility.PRIVATE, backtrace=true)
    public IRubyObject initialize(IRubyObject[] args2) {
        IRubyObject port;
        IRubyObject hostname = args2[0];
        IRubyObject iRubyObject = port = args2.length > 1 ? args2[1] : this.getRuntime().getNil();
        if (hostname.isNil()) {
            hostname = this.getRuntime().newString("0.0.0.0");
        } else if (hostname instanceof RubyFixnum) {
            port = hostname;
            hostname = this.getRuntime().newString("0.0.0.0");
        }
        String shost = hostname.convertToString().toString();
        try {
            int portInt;
            InetAddress addr2 = InetAddress.getByName(shost);
            this.ssc = ServerSocketChannel.open();
            if (port instanceof RubyInteger) {
                portInt = RubyNumeric.fix2int(port);
            } else {
                RubyString portString = port.convertToString();
                RubyInteger portInteger = portString.convertToInteger(MethodIndex.TO_I, "to_i");
                portInt = RubyNumeric.fix2int(portInteger);
                if (portInt <= 0) {
                    portInt = RubyNumeric.fix2int(RubySocket.getservbyname(this.getRuntime().getObject(), new IRubyObject[]{portString}));
                }
            }
            this.socket_address = new InetSocketAddress(addr2, portInt);
            this.ssc.socket().bind(this.socket_address);
            this.initSocket(new ChannelDescriptor(this.ssc, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (UnknownHostException e) {
            throw RubyTCPServer.sockerr(this, "initialize: name or service not known");
        }
        catch (BindException e) {
            throw this.getRuntime().newErrnoEADDRINUSEError();
        }
        catch (IOException e) {
            throw RubyTCPServer.sockerr(this, "initialize: name or service not known");
        }
        catch (IllegalArgumentException iae) {
            throw RubyTCPServer.sockerr(this, iae.getMessage());
        }
        return this;
    }

    @JRubyMethod(name={"accept"})
    public IRubyObject accept() {
        RubyTCPSocket socket2 = new RubyTCPSocket(this.getRuntime(), this.getRuntime().fastGetClass("TCPSocket"));
        ThreadContext context = this.getRuntime().getCurrentContext();
        try {
            boolean ready2;
            while (!(ready2 = context.getThread().select(this, 16))) {
                this.getRuntime().getCurrentContext().pollThreadEvents();
            }
            try {
                SocketChannel connected = this.ssc.accept();
                connected.finishConnect();
                socket2.initSocket(new ChannelDescriptor(connected, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
            }
            catch (InvalidValueException ex) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            return socket2;
        }
        catch (IOException e) {
            throw RubyTCPServer.sockerr(this, "problem when accepting");
        }
    }

    @JRubyMethod(name={"accept_nonblock"})
    public IRubyObject accept_nonblock() {
        RubyTCPSocket socket2 = new RubyTCPSocket(this.getRuntime(), this.getRuntime().fastGetClass("TCPSocket"));
        Selector selector = null;
        try {
            this.ssc.configureBlocking(false);
            selector = Selector.open();
            SelectionKey key = this.ssc.register(selector, 16);
            int selected = selector.selectNow();
            if (selected == 0) {
                throw this.getRuntime().newErrnoEAGAINError("Resource temporarily unavailable");
            }
            try {
                socket2.initSocket(new ChannelDescriptor(this.ssc.accept(), RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
            }
            catch (InvalidValueException ex) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            RubyTCPSocket rubyTCPSocket = socket2;
            return rubyTCPSocket;
        }
        catch (IOException e) {
            throw RubyTCPServer.sockerr(this, "problem when accepting");
        }
        finally {
            try {
                if (selector != null) {
                    selector.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    @JRubyMethod(name={"listen"}, required=1)
    public IRubyObject listen(IRubyObject backlog) {
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"peeraddt"}, rest=true)
    public IRubyObject peeraddr(IRubyObject[] args2) {
        throw this.getRuntime().newNotImplementedError("not supported");
    }

    @JRubyMethod(name={"getpeername"}, rest=true)
    public IRubyObject getpeername(IRubyObject[] args2) {
        throw this.getRuntime().newNotImplementedError("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, rest=true, frame=true, meta=true)
    public static IRubyObject open(IRubyObject recv2, IRubyObject[] args2, Block block) {
        ThreadContext context = recv2.getRuntime().getCurrentContext();
        IRubyObject tcpServer = recv2.callMethod(context, "new", args2);
        if (!block.isGiven()) {
            return tcpServer;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, tcpServer);
            return iRubyObject;
        }
        finally {
            tcpServer.callMethod(context, "close");
        }
    }
}

