/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.invokers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.java.invokers.RubyToJavaInvoker;
import org.jruby.javasupport.JavaMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodInvoker
extends RubyToJavaInvoker {
    private Method[] methods;

    MethodInvoker(RubyModule host, List<Method> methods2) {
        super(host);
        this.methods = methods2.toArray(new Method[methods2.size()]);
        if (!Ruby.isSecurityRestricted()) {
            Method.setAccessible(this.methods, true);
        }
    }

    synchronized void createJavaMethods(Ruby runtime2) {
        if (!this.initialized) {
            if (this.methods != null) {
                if (this.methods.length == 1) {
                    this.javaCallable = JavaMethod.create(runtime2, this.methods[0]);
                } else {
                    HashMap<Integer, ArrayList<JavaMethod>> methodsMap = new HashMap<Integer, ArrayList<JavaMethod>>();
                    int maxArity = 0;
                    for (Method method2 : this.methods) {
                        int arity2 = method2.getParameterTypes().length;
                        maxArity = Math.max(arity2, maxArity);
                        ArrayList<JavaMethod> methodsForArity = (ArrayList<JavaMethod>)methodsMap.get(arity2);
                        if (methodsForArity == null) {
                            methodsForArity = new ArrayList<JavaMethod>();
                            methodsMap.put(arity2, methodsForArity);
                        }
                        methodsForArity.add(JavaMethod.create(runtime2, method2));
                    }
                    this.javaCallables = new JavaMethod[maxArity + 1][];
                    for (Map.Entry entry : methodsMap.entrySet()) {
                        List methodsForArity = (List)entry.getValue();
                        JavaMethod[] methodsArray = methodsForArity.toArray(new JavaMethod[methodsForArity.size()]);
                        this.javaCallables[((Integer)entry.getKey()).intValue()] = methodsArray;
                    }
                }
                this.methods = null;
                this.cache = new ConcurrentHashMap();
            }
            this.initialized = true;
        }
    }
}

