/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledBlock
extends BlockBody {
    protected final CompiledBlockCallback callback;
    protected final boolean hasMultipleArgsHead;
    protected final Arity arity;
    protected final StaticScope scope;

    public static Block newCompiledClosure(IRubyObject self, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope, Arity arity2, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        Binding binding2 = new Binding(self, frame, visibility, klass, dynamicScope);
        CompiledBlock body = new CompiledBlock(arity2, scope, callback, hasMultipleArgsHead, argumentType);
        return new Block(body, binding2);
    }

    public static Block newCompiledClosure(ThreadContext context, IRubyObject self, Arity arity2, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        return CompiledBlock.newCompiledClosure(self, context.getCurrentFrame(), Visibility.PUBLIC, context.getRubyClass(), context.getCurrentScope(), arity2, scope, callback, hasMultipleArgsHead, argumentType);
    }

    public static Block newCompiledClosure(ThreadContext context, IRubyObject self, BlockBody body) {
        Binding binding2 = new Binding(self, context.getCurrentFrame(), Visibility.PUBLIC, context.getRubyClass(), context.getCurrentScope());
        return new Block(body, binding2);
    }

    public static BlockBody newCompiledBlock(Arity arity2, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        return new CompiledBlock(arity2, scope, callback, hasMultipleArgsHead, argumentType);
    }

    protected CompiledBlock(Arity arity2, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        super(argumentType);
        this.arity = arity2;
        this.scope = scope;
        this.callback = callback;
        this.hasMultipleArgsHead = hasMultipleArgsHead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        IRubyObject iRubyObject;
        IRubyObject self = this.prepareSelf(binding2);
        IRubyObject realArg = this.setupBlockArg(context.getRuntime(), value2, self);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        try {
            iRubyObject = this.callback.call(context, self, realArg);
            Object var12_11 = null;
        }
        catch (JumpException.NextJump nj) {
            try {
                IRubyObject iRubyObject2 = this.handleNextJump(context, nj, type2);
                Object var12_12 = null;
                this.post(context, binding2, oldVis, lastFrame);
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                this.post(context, binding2, oldVis, lastFrame);
                throw throwable;
            }
        }
        this.post(context, binding2, oldVis, lastFrame);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject args2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        IRubyObject iRubyObject;
        if (klass == null) {
            self = this.prepareSelf(binding2);
        }
        IRubyObject realArg = aValue ? this.setupBlockArgs(context, args2, self) : this.setupBlockArg(context.getRuntime(), args2, self);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, klass, binding2);
        try {
            iRubyObject = this.callback.call(context, self, realArg);
            Object var14_13 = null;
        }
        catch (JumpException.NextJump nj) {
            try {
                IRubyObject iRubyObject2 = this.handleNextJump(context, nj, type2);
                Object var14_14 = null;
                this.post(context, binding2, oldVis, lastFrame);
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                this.post(context, binding2, oldVis, lastFrame);
                throw throwable;
            }
        }
        this.post(context, binding2, oldVis, lastFrame);
        return iRubyObject;
    }

    private IRubyObject prepareSelf(Binding binding2) {
        IRubyObject self = binding2.getSelf();
        binding2.getFrame().setSelf(self);
        return self;
    }

    private IRubyObject handleNextJump(ThreadContext context, JumpException.NextJump nj, Block.Type type2) {
        return type2 == Block.Type.LAMBDA ? context.getRuntime().getNil() : (IRubyObject)nj.getValue();
    }

    protected Frame pre(ThreadContext context, RubyModule klass, Binding binding2) {
        return context.preYieldSpecificBlock(binding2, this.scope, klass);
    }

    protected void post(ThreadContext context, Binding binding2, Visibility vis, Frame lastFrame) {
        binding2.getFrame().setVisibility(vis);
        context.postYield(binding2, lastFrame);
    }

    protected IRubyObject setupBlockArgs(ThreadContext context, IRubyObject value2, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return null;
            }
            case 1: 
            case 3: {
                return value2;
            }
        }
        return this.defaultArgsLogic(context.getRuntime(), value2);
    }

    private IRubyObject defaultArgsLogic(Ruby ruby, IRubyObject value2) {
        int length2 = ArgsUtil.arrayLength(value2);
        switch (length2) {
            case 0: {
                return ruby.getNil();
            }
            case 1: {
                return ((RubyArray)value2).eltInternal(0);
            }
        }
        this.blockArgWarning(ruby, length2);
        return value2;
    }

    private void blockArgWarning(Ruby ruby, int length2) {
        ruby.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + length2 + " for 1)", new Object[0]);
    }

    protected IRubyObject setupBlockArg(Ruby ruby, IRubyObject value2, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return null;
            }
            case 1: 
            case 3: {
                return ArgsUtil.convertToRubyArray(ruby, value2, this.hasMultipleArgsHead);
            }
        }
        return this.defaultArgLogic(ruby, value2);
    }

    private IRubyObject defaultArgLogic(Ruby ruby, IRubyObject value2) {
        if (value2 == null) {
            ruby.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)", new Object[0]);
            return ruby.getNil();
        }
        return value2;
    }

    public StaticScope getStaticScope() {
        return this.scope;
    }

    public Block cloneBlock(Binding binding2) {
        binding2 = new Binding(binding2.getSelf(), binding2.getFrame().duplicate(), binding2.getVisibility(), binding2.getKlass(), binding2.getDynamicScope());
        return new Block(this, binding2);
    }

    public Arity arity() {
        return this.arity;
    }
}

