/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jruby.util.ByteList;
import org.jvyamlb.Scanner;
import org.jvyamlb.SimpleKey;
import org.jvyamlb.exceptions.ScannerException;
import org.jvyamlb.exceptions.YAMLException;
import org.jvyamlb.tokens.AliasToken;
import org.jvyamlb.tokens.AnchorToken;
import org.jvyamlb.tokens.BlockEndToken;
import org.jvyamlb.tokens.BlockEntryToken;
import org.jvyamlb.tokens.BlockMappingStartToken;
import org.jvyamlb.tokens.BlockSequenceStartToken;
import org.jvyamlb.tokens.DirectiveToken;
import org.jvyamlb.tokens.DocumentEndToken;
import org.jvyamlb.tokens.DocumentStartToken;
import org.jvyamlb.tokens.FlowEntryToken;
import org.jvyamlb.tokens.FlowMappingEndToken;
import org.jvyamlb.tokens.FlowMappingStartToken;
import org.jvyamlb.tokens.FlowSequenceEndToken;
import org.jvyamlb.tokens.FlowSequenceStartToken;
import org.jvyamlb.tokens.KeyToken;
import org.jvyamlb.tokens.ScalarToken;
import org.jvyamlb.tokens.StreamEndToken;
import org.jvyamlb.tokens.StreamStartToken;
import org.jvyamlb.tokens.TagToken;
import org.jvyamlb.tokens.Token;
import org.jvyamlb.tokens.ValueToken;

public class ScannerImpl
implements Scanner {
    private static final byte[] EMPTY;
    private static final byte[] NN;
    private static final ByteList BANG;
    private static final ByteList SPACE;
    private static final boolean[] ALL_FALSE;
    private static final boolean[] ALL_TRUE;
    private static final boolean[] LINEBR;
    private static final boolean[] NULL_BL_LINEBR;
    private static final boolean[] NULL_BL_T_LINEBR;
    private static final boolean[] NULL_OR_LINEBR;
    private static final boolean[] FULL_LINEBR;
    private static final boolean[] BLANK_OR_LINEBR;
    private static final boolean[] S4;
    private static final boolean[] ALPHA;
    private static final boolean[] DIGIT;
    private static final boolean[] HEXA;
    private static final boolean[] STRANGE_CHAR;
    private static final int[] RN;
    private static final boolean[] BLANK_T;
    private static final boolean[] SPACES_AND_STUFF;
    private static final boolean[] DOUBLE_ESC;
    private static final boolean[] NON_ALPHA_OR_NUM;
    private static final boolean[] NON_PRINTABLE;
    private static final boolean[] STUPID_CHAR;
    private static final boolean[] R_FLOWZERO;
    private static final boolean[] R_FLOWZERO1;
    private static final boolean[] R_FLOWNONZERO;
    private static final byte[] ESCAPE_REPLACEMENTS;
    private static final boolean[] IS_ESCAPE_REPLACEMENT;
    private static final Map ESCAPE_CODES;
    private static final boolean[] CHOMPING;
    private boolean done = false;
    private int flowLevel = 0;
    private int tokensTaken = 0;
    private int indent = -1;
    private boolean allowSimpleKey = true;
    private boolean eof = true;
    protected int column = 0;
    protected int pointer = 0;
    private ByteList buffer;
    private InputStream stream;
    private List tokens;
    private List indents;
    private Map possibleSimpleKeys;
    private boolean docStart = false;
    private boolean lastFlowControl = false;
    private static final byte[] HEXA_VALUES;

    public ScannerImpl(InputStream stream) {
        this.stream = stream;
        this.eof = false;
        this.buffer = new ByteList(100);
        this.tokens = new LinkedList();
        this.indents = new LinkedList();
        this.possibleSimpleKeys = new TreeMap();
        this.fetchStreamStart();
    }

    public ScannerImpl(ByteList stream) {
        this.buffer = new ByteList(stream.bytes, stream.begin, stream.realSize);
        this.stream = null;
        this.tokens = new LinkedList();
        this.indents = new LinkedList();
        this.possibleSimpleKeys = new TreeMap();
        this.fetchStreamStart();
    }

    public ScannerImpl(String stream) {
        try {
            this.buffer = new ByteList(ByteList.plain(stream), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        this.stream = null;
        this.tokens = new LinkedList();
        this.indents = new LinkedList();
        this.possibleSimpleKeys = new TreeMap();
        this.fetchStreamStart();
    }

    private void update(int length2, boolean reset2) {
        if (!this.eof && reset2) {
            this.buffer.delete(0, this.pointer);
            this.pointer = 0;
        }
        while (this.buffer.realSize < this.pointer + length2) {
            byte[] rawData = ByteList.NULL_ARRAY;
            int converted = -2;
            if (!this.eof) {
                byte[] data = new byte[1024];
                try {
                    converted = this.stream.read(data);
                }
                catch (IOException ioe) {
                    throw new YAMLException(ioe);
                }
                if (converted == -1) {
                    this.eof = true;
                } else {
                    rawData = data;
                }
            }
            if (this.eof) {
                this.buffer.append(0);
                break;
            }
            this.checkPrintable(rawData, converted);
            this.buffer.append(rawData, 0, converted);
        }
    }

    protected void yamlException(String message) {
        throw new YAMLException(message);
    }

    protected void scannerException(String when, String what, String note) {
        throw new ScannerException(when, what, note);
    }

    private void checkPrintable(byte[] b, int len) {
        for (int i = 0; i < len; ++i) {
            if (!NON_PRINTABLE[b[i] & 0xFF]) continue;
            int position = this.buffer.length() - this.pointer + i;
            this.yamlException("At " + position + " we found: " + (char)(b[i] & 0xFF) + ". Special characters are not allowed");
        }
    }

    private boolean ensure(int len, boolean reset2) {
        if (this.pointer + len >= this.buffer.realSize) {
            this.update(len, reset2);
        }
        return true;
    }

    private char peek() {
        this.ensure(1, false);
        return (char)((char)this.buffer.bytes[this.pointer] & 0xFF);
    }

    private char peek(int index2) {
        this.ensure(index2 + 1, false);
        return (char)((char)this.buffer.bytes[this.pointer + index2] & 0xFF);
    }

    protected void forward() {
        this.ensure(2, true);
        char ch1 = (char)(this.buffer.bytes[this.pointer++] & 0xFF);
        if (ch1 == '\n' || ch1 == '\r' && (this.buffer.bytes[this.pointer] & 0xFF) != 10) {
            this.possibleSimpleKeys.clear();
            this.column = 0;
        } else {
            ++this.column;
        }
    }

    protected void forward(int length2) {
        this.ensure(length2 + 1, true);
        int ch = 0;
        for (int i = 0; i < length2; ++i) {
            ch = this.buffer.bytes[this.pointer] & 0xFF;
            ++this.pointer;
            if (LINEBR[ch] || ch == 13 && (this.buffer.bytes[this.pointer] & 0xFF) != 10) {
                this.possibleSimpleKeys.clear();
                this.column = 0;
                continue;
            }
            ++this.column;
        }
    }

    private void addToken(Token t) {
        this.tokens.add(t);
        this.lastFlowControl = t instanceof FlowMappingStartToken || t instanceof FlowSequenceStartToken || t instanceof ValueToken || t instanceof KeyToken || t instanceof FlowEntryToken;
    }

    public boolean checkToken(Class[] choices) {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            if (choices.length == 0) {
                return true;
            }
            Object first2 = this.tokens.get(0);
            int j = choices.length;
            for (int i = 0; i < j; ++i) {
                if (!choices[i].isInstance(first2)) continue;
                return true;
            }
        }
        return false;
    }

    public Token peekToken(int index2) {
        while (this.needMoreTokens(index2 + 1)) {
            this.fetchMoreTokens();
        }
        return this.tokens.size() < index2 + 1 ? null : this.tokens.get(index2);
    }

    public Token peekToken() {
        return this.peekToken(0);
    }

    public Token getToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            ++this.tokensTaken;
            return (Token)this.tokens.remove(0);
        }
        return null;
    }

    public Iterator eachToken() {
        return new TokenIterator();
    }

    public Iterator iterator() {
        return this.eachToken();
    }

    private boolean needMoreTokens() {
        return this.needMoreTokens(1);
    }

    private boolean needMoreTokens(int size2) {
        if (this.done) {
            return false;
        }
        return this.tokens.size() < size2 || this.nextPossibleSimpleKey() == this.tokensTaken;
    }

    private boolean isEnding() {
        this.ensure(4, false);
        return (this.buffer.bytes[this.pointer] & 0xFF) == 45 && (this.buffer.bytes[this.pointer + 1] & 0xFF) == 45 && (this.buffer.bytes[this.pointer + 2] & 0xFF) == 45 && this.buffer.bytes[this.pointer + 3] != 0 && NULL_BL_T_LINEBR[this.buffer.bytes[this.pointer + 3]];
    }

    private boolean isStart() {
        this.ensure(4, false);
        return (this.buffer.bytes[this.pointer] & 0xFF) == 46 && (this.buffer.bytes[this.pointer + 1] & 0xFF) == 46 && (this.buffer.bytes[this.pointer + 2] & 0xFF) == 46 && NULL_BL_T_LINEBR[this.buffer.bytes[this.pointer + 3]];
    }

    private boolean isEndOrStart() {
        this.ensure(4, false);
        return ((this.buffer.bytes[this.pointer] & 0xFF) == 45 && (this.buffer.bytes[this.pointer + 1] & 0xFF) == 45 && (this.buffer.bytes[this.pointer + 2] & 0xFF) == 45 || (this.buffer.bytes[this.pointer] & 0xFF) == 46 && (this.buffer.bytes[this.pointer + 1] & 0xFF) == 46 && (this.buffer.bytes[this.pointer + 2] & 0xFF) == 46) && NULL_BL_T_LINEBR[this.buffer.bytes[this.pointer + 3]];
    }

    private Token fetchMoreTokens() {
        this.scanToNextToken();
        this.unwindIndent(this.column);
        char ch = this.peek();
        boolean colz = this.column == 0;
        switch (ch) {
            case '\u0000': {
                return this.fetchStreamEnd();
            }
            case '\'': {
                return this.fetchSingle();
            }
            case '\"': {
                return this.fetchDouble();
            }
            case '?': {
                if (this.flowLevel == 0 && !NULL_BL_T_LINEBR[this.peek(1)]) break;
                return this.fetchKey();
            }
            case ':': {
                if (this.flowLevel == 0 && !NULL_BL_T_LINEBR[this.peek(1)] || this.lastFlowControl) break;
                return this.fetchValue();
            }
            case '%': {
                if (!colz) break;
                return this.fetchDirective();
            }
            case '-': {
                if ((colz || this.docStart) && this.isEnding()) {
                    return this.fetchDocumentStart();
                }
                if (!NULL_BL_T_LINEBR[this.peek(1)]) break;
                return this.fetchBlockEntry();
            }
            case '.': {
                if (!colz || !this.isStart()) break;
                return this.fetchDocumentEnd();
            }
            case '[': {
                return this.fetchFlowSequenceStart();
            }
            case '{': {
                return this.fetchFlowMappingStart();
            }
            case ']': {
                return this.fetchFlowSequenceEnd();
            }
            case '}': {
                return this.fetchFlowMappingEnd();
            }
            case ',': {
                if (this.flowLevel == 0) break;
                return this.fetchFlowEntry();
            }
            case '*': {
                if (!ALPHA[this.peek(1)]) break;
                return this.fetchAlias();
            }
            case '&': {
                if (!ALPHA[this.peek(1)]) break;
                return this.fetchAnchor();
            }
            case '!': {
                return this.fetchTag();
            }
            case '|': {
                if (this.flowLevel != 0 || !CHOMPING[this.peek(1)]) break;
                return this.fetchLiteral();
            }
            case '>': {
                if (this.flowLevel != 0 || !CHOMPING[this.peek(1)]) break;
                return this.fetchFolded();
            }
        }
        if (STUPID_CHAR[this.buffer.bytes[this.pointer] & 0xFF] || this.ensure(1, false) && (this.buffer.bytes[this.pointer] == 45 || this.buffer.bytes[this.pointer] == 63 || this.buffer.bytes[this.pointer] == 58) && !NULL_BL_T_LINEBR[this.buffer.bytes[this.pointer + 1] & 0xFF]) {
            return this.fetchPlain();
        }
        this.scannerException("while scanning for the next token", "found character " + ch + "(" + ch + ") that cannot start any token", null);
        return null;
    }

    protected StreamStartToken getStreamStart() {
        return Token.STREAM_START;
    }

    protected StreamEndToken getStreamEnd() {
        return Token.STREAM_END;
    }

    protected DocumentStartToken getDocumentStart() {
        return Token.DOCUMENT_START;
    }

    protected DocumentEndToken getDocumentEnd() {
        return Token.DOCUMENT_END;
    }

    protected BlockEndToken getBlockEnd() {
        return Token.BLOCK_END;
    }

    protected BlockSequenceStartToken getBlockSequenceStart() {
        return Token.BLOCK_SEQUENCE_START;
    }

    protected BlockEntryToken getBlockEntry() {
        return Token.BLOCK_ENTRY;
    }

    protected KeyToken getKey() {
        return Token.KEY;
    }

    protected KeyToken getKey(SimpleKey key) {
        return Token.KEY;
    }

    protected ValueToken getValue() {
        return Token.VALUE;
    }

    protected BlockMappingStartToken getBlockMappingStart() {
        return Token.BLOCK_MAPPING_START;
    }

    protected BlockMappingStartToken getBlockMappingStart(SimpleKey key) {
        return Token.BLOCK_MAPPING_START;
    }

    protected FlowSequenceStartToken getFlowSequenceStart() {
        return Token.FLOW_SEQUENCE_START;
    }

    protected FlowMappingStartToken getFlowMappingStart() {
        return Token.FLOW_MAPPING_START;
    }

    protected FlowSequenceEndToken getFlowSequenceEnd() {
        return Token.FLOW_SEQUENCE_END;
    }

    protected FlowMappingEndToken getFlowMappingEnd() {
        return Token.FLOW_MAPPING_END;
    }

    protected FlowEntryToken getFlowEntry() {
        return Token.FLOW_ENTRY;
    }

    protected TagToken getTag(ByteList[] args2) {
        return new TagToken(args2);
    }

    protected AliasToken getAlias() {
        return new AliasToken();
    }

    protected AnchorToken getAnchor() {
        return new AnchorToken();
    }

    protected Token finalizeAnchor(Token t) {
        return t;
    }

    protected DirectiveToken getDirective(String name2, String[] value2) {
        return new DirectiveToken(name2, value2);
    }

    protected ScalarToken getScalar(ByteList value2, boolean plain, char style) {
        return new ScalarToken(value2, plain, style);
    }

    private Token fetchStreamStart() {
        this.docStart = true;
        StreamStartToken t = this.getStreamStart();
        this.addToken(t);
        return t;
    }

    private Token fetchStreamEnd() {
        this.unwindIndent(-1);
        this.allowSimpleKey = false;
        this.possibleSimpleKeys = new TreeMap();
        StreamEndToken t = this.getStreamEnd();
        this.addToken(t);
        this.done = true;
        this.docStart = false;
        return t;
    }

    private void scanToNextToken() {
        while (true) {
            char ch;
            if ((ch = this.peek()) == ' ' || ch == '\t') {
                this.forward();
                continue;
            }
            if (ch == '#') {
                this.forward();
                while (!NULL_OR_LINEBR[this.peek()]) {
                    this.forward();
                }
            }
            if (this.scanLineBreak().length == 0) break;
            if (this.flowLevel != 0) continue;
            this.allowSimpleKey = true;
        }
    }

    private byte[] scanLineBreak() {
        char val = this.peek();
        if (FULL_LINEBR[val]) {
            this.ensure(2, false);
            if (RN[0] == this.buffer.bytes[this.pointer] && RN[1] == this.buffer.bytes[this.pointer + 1]) {
                this.forward(2);
            } else {
                this.forward();
            }
            return NN;
        }
        return EMPTY;
    }

    private void unwindIndent(int col) {
        if (this.flowLevel != 0) {
            return;
        }
        while (this.indent > col) {
            this.indent = (Integer)this.indents.remove(0);
            this.addToken(this.getBlockEnd());
        }
    }

    private Token fetchDocumentStart() {
        this.docStart = false;
        return this.fetchDocumentIndicator(this.getDocumentStart());
    }

    private Token fetchDocumentIndicator(Token tok) {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        this.forward(3);
        this.addToken(tok);
        return tok;
    }

    private Token fetchBlockEntry() {
        this.docStart = false;
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                this.scannerException(null, "sequence entries are not allowed here", null);
            }
            if (this.addIndent(this.column)) {
                this.addToken(this.getBlockSequenceStart());
            }
        }
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        BlockEntryToken t = this.getBlockEntry();
        this.forward();
        this.addToken(t);
        return t;
    }

    private boolean addIndent(int col) {
        if (this.indent < col) {
            this.indents.add(0, new Integer(this.indent));
            this.indent = col;
            return true;
        }
        return false;
    }

    private Token fetchTag() {
        this.docStart = false;
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanTag();
        this.addToken(tok);
        return tok;
    }

    private void removePossibleSimpleKey() {
        SimpleKey key = (SimpleKey)this.possibleSimpleKeys.remove(new Integer(this.flowLevel));
        if (key != null && key.isRequired()) {
            this.scannerException("while scanning a simple key", "could not find expected ':'", null);
        }
    }

    protected SimpleKey getSimpleKey(int tokenNumber, boolean required, int index2, int line, int column) {
        return new SimpleKey(tokenNumber, required, index2, line, column);
    }

    private void savePossibleSimpleKey() {
        if (this.allowSimpleKey) {
            this.removePossibleSimpleKey();
            this.possibleSimpleKeys.put(new Integer(this.flowLevel), this.getSimpleKey(this.tokensTaken + this.tokens.size(), this.flowLevel == 0 && this.indent == this.column, -1, -1, this.column));
        }
    }

    private Token scanTag() {
        this.startingItem();
        char ch = this.peek(1);
        ByteList handle = null;
        ByteList suffix = null;
        if (ch == '<') {
            this.forward(2);
            suffix = this.scanTagUri("tag");
            if (this.peek() != '>') {
                this.scannerException("while scanning a tag", "expected '>', but found " + this.peek() + "(" + this.peek() + ")", null);
            }
            this.forward();
        } else if (NULL_BL_T_LINEBR[ch]) {
            suffix = BANG;
            this.forward();
        } else {
            int length2 = 1;
            boolean useHandle = false;
            while (!NULL_BL_T_LINEBR[ch]) {
                if (ch == '!') {
                    useHandle = true;
                    break;
                }
                ch = this.peek(++length2);
            }
            handle = BANG;
            if (useHandle) {
                handle = this.scanTagHandle("tag");
            } else {
                handle = BANG;
                this.forward();
            }
            suffix = this.scanTagUri("tag");
        }
        if (!NULL_BL_LINEBR[this.peek()]) {
            this.scannerException("while scanning a tag", "expected ' ', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return this.getTag(new ByteList[]{handle, suffix});
    }

    private ByteList scanTagUri(String name2) {
        ByteList chunks = new ByteList(10);
        int length2 = 0;
        char ch = this.peek(length2);
        while (STRANGE_CHAR[ch]) {
            if ('%' == ch) {
                this.ensure(length2, false);
                chunks.append(this.buffer.bytes, this.pointer, length2);
                length2 = 0;
                chunks.append(this.scanUriEscapes(name2));
            } else {
                ++length2;
            }
            ch = this.peek(length2);
        }
        if (length2 != 0) {
            this.ensure(length2, false);
            chunks.append(this.buffer.bytes, this.pointer, length2);
            this.forward(length2);
        }
        if (chunks.length() == 0) {
            this.scannerException("while scanning a " + name2, "expected URI, but found " + ch + "(" + ch + ")", null);
        }
        return chunks;
    }

    private ByteList scanTagHandle(String name2) {
        int length2;
        char ch = this.peek();
        if (ch != '!') {
            this.scannerException("while scanning a " + name2, "expected '!', but found " + ch + "(" + ch + ")", null);
        }
        if ((ch = this.peek(length2 = 1)) != ' ') {
            while (ALPHA[ch]) {
                ch = this.peek(++length2);
            }
            if ('!' != ch) {
                this.forward(length2);
                this.scannerException("while scanning a " + name2, "expected '!', but found " + ch + "(" + ch + ")", null);
            }
            ++length2;
        }
        this.ensure(length2, false);
        ByteList value2 = new ByteList(this.buffer.bytes, this.pointer, length2, false);
        this.forward(length2);
        return value2;
    }

    private ByteList scanUriEscapes(String name2) {
        ByteList bytes = new ByteList();
        while (this.peek() == '%') {
            this.forward();
            try {
                this.ensure(2, false);
                bytes.append(Integer.parseInt(new String(ByteList.plain(this.buffer.bytes, this.pointer, 2)), 16));
            }
            catch (NumberFormatException nfe) {
                this.scannerException("while scanning a " + name2, "expected URI escape sequence of 2 hexadecimal numbers, but found " + this.peek(1) + "(" + this.peek(1) + ") and " + this.peek(2) + "(" + this.peek(2) + ")", null);
            }
            this.forward(2);
        }
        return bytes;
    }

    private Token fetchPlain() {
        this.docStart = false;
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanPlain();
        this.addToken(tok);
        return tok;
    }

    protected void startingItem() {
    }

    protected void possibleEnd() {
    }

    private Token scanPlain() {
        this.startingItem();
        ByteList chunks = new ByteList(7);
        int ind = this.indent + 1;
        ByteList spaces = new ByteList(0);
        boolean f_nzero = true;
        boolean[] r_check = R_FLOWNONZERO;
        boolean[] r_check2 = ALL_FALSE;
        boolean[] r_check3 = ALL_FALSE;
        if (this.flowLevel == 0) {
            f_nzero = false;
            r_check = R_FLOWZERO;
            r_check2 = R_FLOWZERO1;
            r_check3 = R_FLOWZERO;
        }
        while (this.peek() != '#') {
            int length2 = 0;
            int i = 0;
            while (true) {
                this.ensure(i + 2, false);
                if (r_check[this.buffer.bytes[this.pointer + i] & 0xFF] || r_check2[this.buffer.bytes[this.pointer + i] & 0xFF] && r_check3[this.buffer.bytes[this.pointer + i + 1] & 0xFF]) {
                    length2 = i;
                    char ch = this.peek(length2);
                    if (!f_nzero || ch != ':' || S4[this.peek(length2 + 1)]) break;
                }
                ++i;
            }
            if (length2 == 0) break;
            this.allowSimpleKey = false;
            chunks.append(spaces);
            this.ensure(length2, false);
            chunks.append(this.buffer.bytes, this.pointer, length2);
            this.forward(length2);
            this.possibleEnd();
            spaces = this.scanPlainSpaces(ind);
            if (spaces != null && (this.flowLevel != 0 || this.column >= ind)) continue;
            break;
        }
        return this.getScalar(chunks, true, '\u0000');
    }

    private int nextPossibleSimpleKey() {
        Iterator iter = this.possibleSimpleKeys.values().iterator();
        while (iter.hasNext()) {
            SimpleKey key = (SimpleKey)iter.next();
            if (key.getTokenNumber() <= 0) continue;
            return key.getTokenNumber();
        }
        return -1;
    }

    private ByteList scanPlainSpaces(int indent) {
        ByteList chunks = new ByteList();
        int length2 = 0;
        while (this.peek(length2) == ' ') {
            ++length2;
        }
        byte[] whitespaces = new byte[length2];
        Arrays.fill(whitespaces, (byte)32);
        this.forward(length2);
        char ch = this.peek();
        if (FULL_LINEBR[ch]) {
            byte[] lineBreak = this.scanLineBreak();
            this.allowSimpleKey = true;
            if (this.isEndOrStart()) {
                return new ByteList(0);
            }
            ByteList breaks = new ByteList();
            while (BLANK_OR_LINEBR[this.peek()]) {
                if (' ' == this.peek()) {
                    this.forward();
                    continue;
                }
                breaks.append(this.scanLineBreak());
                if (!this.isEndOrStart()) continue;
                return new ByteList(0);
            }
            if (lineBreak.length != 1 || lineBreak[0] != 10) {
                chunks.append(lineBreak);
            } else if (breaks == null || breaks.realSize == 0) {
                chunks.append(SPACE);
            }
            chunks.append(breaks);
        } else {
            chunks.append(whitespaces);
        }
        return chunks;
    }

    private Token fetchSingle() {
        return this.fetchFlowScalar('\'');
    }

    private Token fetchDouble() {
        return this.fetchFlowScalar('\"');
    }

    private Token fetchFlowScalar(char style) {
        this.docStart = false;
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanFlowScalar(style);
        this.addToken(tok);
        return tok;
    }

    private Token scanFlowScalar(char style) {
        this.startingItem();
        boolean dbl = style == '\"';
        ByteList chunks = new ByteList();
        char quote2 = this.peek();
        this.forward();
        chunks.append(this.scanFlowScalarNonSpaces(dbl));
        while (this.peek() != quote2) {
            chunks.append(this.scanFlowScalarSpaces());
            chunks.append(this.scanFlowScalarNonSpaces(dbl));
        }
        this.forward();
        return this.getScalar(chunks, false, style);
    }

    private ByteList parseHexa(int length2) {
        this.ensure(length2, false);
        ByteList chunks = new ByteList(length2 / 2);
        for (int i = 0; i < length2; i += 2) {
            byte val = HEXA_VALUES[this.buffer.bytes[this.pointer + i] & 0xFF];
            if (val == -1) {
                this.scannerException("while scanning a double-quoted scalar", "expected escape sequence of " + length2 + " hexadecimal numbers, but found something else: " + (char)(this.buffer.bytes[this.pointer + i] & 0xFF), null);
            }
            if (i + 1 < length2) {
                val = (byte)(val << 4);
                byte v2 = HEXA_VALUES[this.buffer.bytes[this.pointer + i + 1] & 0xFF];
                if (v2 == -1) {
                    this.scannerException("while scanning a double-quoted scalar", "expected escape sequence of " + length2 + " hexadecimal numbers, but found something else: " + (char)(this.buffer.bytes[this.pointer + i + 1] & 0xFF), null);
                }
                val = (byte)(val + v2);
            }
            chunks.append(val);
        }
        this.forward(length2);
        return chunks;
    }

    private ByteList scanFlowScalarNonSpaces(boolean dbl) {
        ByteList chunks = new ByteList();
        while (true) {
            int length2 = 0;
            while (!SPACES_AND_STUFF[this.peek(length2)]) {
                ++length2;
            }
            if (length2 != 0) {
                this.ensure(length2, false);
                chunks.append(this.buffer.bytes, this.pointer, length2);
                this.forward(length2);
            }
            char ch = this.peek();
            if (!dbl && ch == '\'' && this.peek(1) == '\'') {
                chunks.append(39);
                this.forward(2);
                continue;
            }
            if (dbl && ch == '\'' || !dbl && DOUBLE_ESC[ch]) {
                chunks.append(ch);
                this.forward();
                continue;
            }
            if (!dbl || ch != '\\') break;
            this.forward();
            ch = this.peek();
            if (IS_ESCAPE_REPLACEMENT[ch]) {
                chunks.append(ESCAPE_REPLACEMENTS[ch]);
                this.forward();
                continue;
            }
            if (ESCAPE_CODES.containsKey(new Character(ch))) {
                length2 = (Integer)ESCAPE_CODES.get(new Character(ch));
                this.forward();
                chunks.append(this.parseHexa(length2));
                continue;
            }
            if (FULL_LINEBR[ch]) {
                this.scanLineBreak();
                ByteList ss = this.scanFlowScalarBreaks();
                chunks.append(ss);
                continue;
            }
            chunks.append(92);
        }
        return chunks;
    }

    private ByteList scanFlowScalarSpaces() {
        ByteList chunks = new ByteList();
        int length2 = 0;
        while (BLANK_T[this.peek(length2)]) {
            ++length2;
        }
        this.ensure(length2, false);
        ByteList whitespaces = new ByteList(this.buffer, this.pointer, length2);
        this.forward(length2);
        char ch = this.peek();
        if (ch == '\u0000') {
            this.scannerException("while scanning a quoted scalar", "found unexpected end of stream", null);
        } else if (FULL_LINEBR[ch]) {
            byte[] lineBreak = this.scanLineBreak();
            ByteList breaks = this.scanFlowScalarBreaks();
            if (lineBreak.length != 1 || lineBreak[0] != 10) {
                chunks.append(lineBreak);
            } else if (breaks.length() == 0) {
                chunks.append(SPACE);
            }
            chunks.append(breaks);
        } else {
            chunks.append(whitespaces);
        }
        return chunks;
    }

    private ByteList scanFlowScalarBreaks() {
        ByteList chunks = new ByteList();
        boolean colz = true;
        while (true) {
            if (colz && this.isEndOrStart()) {
                this.scannerException("while scanning a quoted scalar", "found unexpected document separator", null);
            }
            while (BLANK_T[this.peek()]) {
                this.forward();
            }
            if (FULL_LINEBR[this.peek()]) {
                chunks.append(this.scanLineBreak());
                colz = true;
                continue;
            }
            if ('\\' != this.peek() || !BLANK_T[this.peek(1)]) break;
            this.forward();
            chunks.append(this.scanFlowScalarSpaces());
            colz = false;
        }
        return chunks;
    }

    private Token fetchValue() {
        this.docStart = false;
        SimpleKey key = (SimpleKey)this.possibleSimpleKeys.get(new Integer(this.flowLevel));
        if (null == key) {
            if (this.flowLevel == 0 && !this.allowSimpleKey) {
                this.scannerException(null, "mapping values are not allowed here", null);
            }
            this.allowSimpleKey = this.flowLevel == 0;
            this.removePossibleSimpleKey();
        } else {
            this.possibleSimpleKeys.remove(new Integer(this.flowLevel));
            this.tokens.add(key.getTokenNumber() - this.tokensTaken, this.getKey(key));
            if (this.flowLevel == 0 && this.addIndent(key.getColumn())) {
                this.tokens.add(key.getTokenNumber() - this.tokensTaken, this.getBlockMappingStart(key));
            }
            this.allowSimpleKey = false;
        }
        this.forward();
        ValueToken t = this.getValue();
        this.addToken(t);
        return t;
    }

    private Token fetchFlowSequenceStart() {
        return this.fetchFlowCollectionStart(this.getFlowSequenceStart());
    }

    private Token fetchFlowMappingStart() {
        return this.fetchFlowCollectionStart(this.getFlowMappingStart());
    }

    private Token fetchFlowCollectionStart(Token tok) {
        this.docStart = false;
        this.savePossibleSimpleKey();
        ++this.flowLevel;
        this.allowSimpleKey = true;
        this.forward(1);
        this.addToken(tok);
        return tok;
    }

    private Token fetchDocumentEnd() {
        return this.fetchDocumentIndicator(this.getDocumentEnd());
    }

    private Token fetchFlowSequenceEnd() {
        return this.fetchFlowCollectionEnd(this.getFlowSequenceEnd());
    }

    private Token fetchFlowMappingEnd() {
        return this.fetchFlowCollectionEnd(this.getFlowMappingEnd());
    }

    private Token fetchFlowCollectionEnd(Token tok) {
        this.removePossibleSimpleKey();
        --this.flowLevel;
        this.allowSimpleKey = false;
        this.forward(1);
        this.addToken(tok);
        return tok;
    }

    private Token fetchFlowEntry() {
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        this.forward(1);
        FlowEntryToken t = this.getFlowEntry();
        this.addToken(t);
        return t;
    }

    private Token fetchLiteral() {
        return this.fetchBlockScalar('|');
    }

    private Token fetchFolded() {
        return this.fetchBlockScalar('>');
    }

    private Token fetchBlockScalar(char style) {
        this.docStart = false;
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        Token tok = this.scanBlockScalar(style);
        this.addToken(tok);
        return tok;
    }

    private Token scanBlockScalar(char style) {
        this.startingItem();
        boolean folded = style == '>';
        ByteList chunks = new ByteList();
        this.forward();
        Object[] chompi = this.scanBlockScalarIndicators();
        Boolean chomping = (Boolean)chompi[0];
        int increment = (Integer)chompi[1];
        boolean sameLine = this.scanBlockScalarIgnoredLine();
        int minIndent = this.indent + 1;
        if (minIndent < 0) {
            minIndent = 0;
        }
        ByteList breaks = null;
        int maxIndent = 0;
        int ind = 0;
        if (sameLine) {
            boolean leadingNonSpace = !BLANK_T[this.peek()];
            int length2 = 0;
            while (!NULL_OR_LINEBR[this.peek(length2)]) {
                ++length2;
            }
            this.ensure(length2, false);
            chunks.append(this.buffer.bytes, this.pointer, length2);
            this.forward(length2);
        }
        if (increment == -1) {
            Object[] brme = this.scanBlockScalarIndentation();
            breaks = (ByteList)brme[0];
            maxIndent = (Integer)brme[1];
            ind = minIndent > maxIndent ? minIndent : maxIndent;
        } else {
            ind = minIndent + increment - 1;
            breaks = this.scanBlockScalarBreaks(ind);
        }
        byte[] lineBreak = ByteList.NULL_ARRAY;
        while (this.column == ind && this.peek() != '\u0000') {
            chunks.append(breaks);
            boolean leadingNonSpace = !BLANK_T[this.peek()];
            int length3 = 0;
            while (!NULL_OR_LINEBR[this.peek(length3)]) {
                ++length3;
            }
            this.ensure(length3, false);
            chunks.append(this.buffer.bytes, this.pointer, length3);
            this.forward(length3);
            lineBreak = this.scanLineBreak();
            breaks = this.scanBlockScalarBreaks(ind);
            if (this.column != ind || this.peek() == '\u0000') break;
            if (folded && lineBreak.length == 1 && lineBreak[0] == 10 && leadingNonSpace && !BLANK_T[this.peek()]) {
                if (breaks.length() != 0) continue;
                chunks.append(SPACE);
                continue;
            }
            chunks.append(lineBreak);
        }
        if (chomping != Boolean.FALSE) {
            chunks.append(lineBreak);
        }
        if (chomping == Boolean.TRUE) {
            chunks.append(breaks);
        }
        return this.getScalar(chunks, false, style);
    }

    private ByteList scanBlockScalarBreaks(int indent) {
        ByteList chunks = new ByteList();
        while (this.column < indent && this.peek() == ' ') {
            this.forward();
        }
        while (FULL_LINEBR[this.peek()]) {
            chunks.append(this.scanLineBreak());
            while (this.column < indent && this.peek() == ' ') {
                this.forward();
            }
        }
        return chunks;
    }

    private Object[] scanBlockScalarIndentation() {
        ByteList chunks = new ByteList();
        int maxIndent = 0;
        while (BLANK_OR_LINEBR[this.peek()]) {
            if (this.peek() != ' ') {
                chunks.append(this.scanLineBreak());
                continue;
            }
            this.forward();
            if (this.column <= maxIndent) continue;
            maxIndent = this.column;
        }
        return new Object[]{chunks, new Integer(maxIndent)};
    }

    private Object[] scanBlockScalarIndicators() {
        Boolean chomping = null;
        int increment = -1;
        char ch = this.peek();
        if (ch == '-' || ch == '+') {
            chomping = ch == '+' ? Boolean.TRUE : Boolean.FALSE;
            this.forward();
            ch = this.peek();
            if (DIGIT[ch]) {
                increment = ch - 48;
                if (increment == 0) {
                    this.scannerException("while scanning a block scalar", "expected indentation indicator in the range 1-9, but found 0", null);
                }
                this.forward();
            }
        } else if (DIGIT[ch]) {
            increment = ch - 48;
            if (increment == 0) {
                this.scannerException("while scanning a block scalar", "expected indentation indicator in the range 1-9, but found 0", null);
            }
            this.forward();
            ch = this.peek();
            if (ch == '-' || ch == '+') {
                chomping = ch == '+' ? Boolean.TRUE : Boolean.FALSE;
                this.forward();
            }
        }
        if (!NULL_BL_LINEBR[this.peek()]) {
            this.scannerException("while scanning a block scalar", "expected chomping or indentation indicators, but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return new Object[]{chomping, new Integer(increment)};
    }

    private boolean scanBlockScalarIgnoredLine() {
        boolean same2 = true;
        while (this.peek() == ' ') {
            this.forward();
        }
        if (this.peek() == '#') {
            while (!NULL_OR_LINEBR[this.peek()]) {
                this.forward();
            }
            same2 = false;
        }
        if (NULL_OR_LINEBR[this.peek()]) {
            this.scanLineBreak();
            return false;
        }
        return same2;
    }

    private Token fetchDirective() {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanDirective();
        this.addToken(tok);
        return tok;
    }

    private Token fetchKey() {
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                this.scannerException(null, "mapping keys are not allowed here", null);
            }
            if (this.addIndent(this.column)) {
                this.addToken(this.getBlockMappingStart());
            }
        }
        this.allowSimpleKey = this.flowLevel == 0;
        this.removePossibleSimpleKey();
        this.forward();
        KeyToken t = this.getKey();
        this.addToken(t);
        return t;
    }

    private Token fetchAlias() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor(this.getAlias());
        this.addToken(tok);
        return tok;
    }

    private Token fetchAnchor() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor(this.getAnchor());
        this.addToken(tok);
        return tok;
    }

    private Token scanDirective() {
        this.startingItem();
        this.forward();
        String name2 = this.scanDirectiveName();
        String[] value2 = null;
        if (name2.equals("YAML")) {
            value2 = this.scanYamlDirectiveValue();
        } else if (name2.equals("TAG")) {
            value2 = this.scanTagDirectiveValue();
        } else {
            while (!NULL_OR_LINEBR[this.peek()]) {
                this.forward();
            }
        }
        DirectiveToken t = this.getDirective(name2, value2);
        this.scanDirectiveIgnoredLine();
        return t;
    }

    private String scanDirectiveName() {
        int length2 = 0;
        char ch = this.peek(length2);
        boolean zlen = true;
        while (ALPHA[ch]) {
            zlen = false;
            ch = this.peek(++length2);
        }
        if (zlen) {
            this.scannerException("while scanning a directive", "expected alphabetic or numeric character, but found " + ch + "(" + ch + ")", null);
        }
        String value2 = null;
        try {
            this.ensure(length2, false);
            value2 = new String(this.buffer.bytes, this.pointer, length2, "ISO8859-1");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.forward(length2);
        if (!NULL_BL_LINEBR[this.peek()]) {
            this.scannerException("while scanning a directive", "expected alphabetic or numeric character, but found " + ch + "(" + ch + ")", null);
        }
        return value2;
    }

    private byte[] scanDirectiveIgnoredLine() {
        char ch;
        while (this.peek() == ' ') {
            this.forward();
        }
        if (this.peek() == '\"') {
            while (!NULL_OR_LINEBR[this.peek()]) {
                this.forward();
            }
        }
        if (!NULL_OR_LINEBR[ch = this.peek()]) {
            this.scannerException("while scanning a directive", "expected a comment or a line break, but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return this.scanLineBreak();
    }

    private Token scanAnchor(Token tok) {
        char indicator = this.peek();
        String name2 = indicator == '*' ? "alias" : "anchor";
        this.forward();
        int length2 = 0;
        while (ALPHA[this.peek(length2)]) {
            ++length2;
        }
        if (length2 == 0) {
            this.scannerException("while scanning an " + name2, "expected alphabetic or numeric character, but found something else...", null);
        }
        String value2 = null;
        try {
            this.ensure(length2, false);
            value2 = new String(this.buffer.bytes, this.pointer, length2, "ISO8859-1");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.forward(length2);
        if (!NON_ALPHA_OR_NUM[this.peek()]) {
            this.scannerException("while scanning an " + name2, "expected alphabetic or numeric character, but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        tok.setValue(value2);
        return this.finalizeAnchor(tok);
    }

    private String[] scanYamlDirectiveValue() {
        while (this.peek() == ' ') {
            this.forward();
        }
        String major = this.scanYamlDirectiveNumber();
        if (this.peek() != '.') {
            this.scannerException("while scanning a directive", "expected a digit or '.', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        this.forward();
        String minor = this.scanYamlDirectiveNumber();
        if (!NULL_BL_LINEBR[this.peek()]) {
            this.scannerException("while scanning a directive", "expected a digit or ' ', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return new String[]{major, minor};
    }

    private String scanYamlDirectiveNumber() {
        char ch = this.peek();
        if (!Character.isDigit(ch)) {
            this.scannerException("while scanning a directive", "expected a digit, but found " + ch + "(" + ch + ")", null);
        }
        int length2 = 0;
        StringBuffer sb = new StringBuffer();
        while (Character.isDigit(this.peek(length2))) {
            sb.append(this.peek(length2));
            ++length2;
        }
        this.forward(length2);
        return sb.toString();
    }

    public static String into(ByteList b) {
        try {
            return new String(b.bytes, 0, b.realSize, "ISO8859-1");
        }
        catch (Exception e) {
            return null;
        }
    }

    private String[] scanTagDirectiveValue() {
        while (this.peek() == ' ') {
            this.forward();
        }
        String handle = ScannerImpl.into(this.scanTagDirectiveHandle());
        while (this.peek() == ' ') {
            this.forward();
        }
        String prefix = ScannerImpl.into(this.scanTagDirectivePrefix());
        return new String[]{handle, prefix};
    }

    private ByteList scanTagDirectiveHandle() {
        ByteList value2 = this.scanTagHandle("directive");
        if (this.peek() != ' ') {
            this.scannerException("while scanning a directive", "expected ' ', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return value2;
    }

    private ByteList scanTagDirectivePrefix() {
        ByteList value2 = this.scanTagUri("directive");
        if (!NULL_BL_LINEBR[this.peek()]) {
            this.scannerException("while scanning a directive", "expected ' ', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return value2;
    }

    public static void main(String[] args2) throws Exception {
        String filename2 = args2[0];
        System.out.println("Reading of file: \"" + filename2 + "\"");
        ByteList input = new ByteList(1024);
        FileInputStream reader = new FileInputStream(filename2);
        byte[] buff = new byte[1024];
        int read2 = 0;
        do {
            read2 = ((InputStream)reader).read(buff);
            input.append(buff, 0, read2);
        } while (read2 >= 1024);
        ((InputStream)reader).close();
        long before = System.currentTimeMillis();
        int tokens = 0;
        for (int i = 0; i < 1; ++i) {
            ScannerImpl sce2 = new ScannerImpl(input);
            Iterator iter = sce2.eachToken();
            while (iter.hasNext()) {
                ++tokens;
                System.out.println(iter.next());
            }
        }
        long after = System.currentTimeMillis();
        long time = after - before;
        double timeS = (double)(after - before) / 1000.0;
        System.out.println("Walking through the " + tokens + " tokens took " + time + "ms, or " + timeS + " seconds");
    }

    public static void tmain(String[] args2) throws Exception {
        String filename2 = args2[0];
        System.out.println("Reading of file: \"" + filename2 + "\"");
        FileInputStream reader = new FileInputStream(filename2);
        long before = System.currentTimeMillis();
        int tokens = 0;
        for (int i = 0; i < 1; ++i) {
            ScannerImpl sce2 = new ScannerImpl(reader);
            Iterator iter = sce2.eachToken();
            while (iter.hasNext()) {
                ++tokens;
                iter.next();
            }
        }
        ((InputStream)reader).close();
        long after = System.currentTimeMillis();
        long time = after - before;
        double timeS = (double)(after - before) / 1000.0;
        System.out.println("Walking through the " + tokens + " tokens took " + time + "ms, or " + timeS + " seconds");
    }

    static {
        int c;
        EMPTY = new byte[0];
        NN = new byte[]{10};
        BANG = new ByteList(new byte[]{33}, false);
        SPACE = new ByteList(new byte[]{32}, false);
        ALL_FALSE = new boolean[256];
        ALL_TRUE = new boolean[256];
        LINEBR = new boolean[256];
        NULL_BL_LINEBR = new boolean[256];
        NULL_BL_T_LINEBR = new boolean[256];
        NULL_OR_LINEBR = new boolean[256];
        FULL_LINEBR = new boolean[256];
        BLANK_OR_LINEBR = new boolean[256];
        S4 = new boolean[256];
        ALPHA = new boolean[256];
        DIGIT = new boolean[256];
        HEXA = new boolean[256];
        STRANGE_CHAR = new boolean[256];
        RN = new int[]{13, 10};
        BLANK_T = new boolean[256];
        SPACES_AND_STUFF = new boolean[256];
        DOUBLE_ESC = new boolean[256];
        NON_ALPHA_OR_NUM = new boolean[256];
        NON_PRINTABLE = new boolean[256];
        STUPID_CHAR = new boolean[256];
        R_FLOWZERO = NULL_BL_T_LINEBR;
        R_FLOWZERO1 = new boolean[256];
        R_FLOWNONZERO = new boolean[256];
        ESCAPE_REPLACEMENTS = new byte[256];
        IS_ESCAPE_REPLACEMENT = new boolean[256];
        ESCAPE_CODES = new HashMap();
        CHOMPING = new boolean[256];
        ScannerImpl.CHOMPING[43] = true;
        ScannerImpl.CHOMPING[45] = true;
        ScannerImpl.CHOMPING[10] = true;
        ScannerImpl.CHOMPING[13] = true;
        ScannerImpl.CHOMPING[48] = true;
        ScannerImpl.CHOMPING[49] = true;
        ScannerImpl.CHOMPING[50] = true;
        ScannerImpl.CHOMPING[51] = true;
        ScannerImpl.CHOMPING[52] = true;
        ScannerImpl.CHOMPING[53] = true;
        ScannerImpl.CHOMPING[54] = true;
        ScannerImpl.CHOMPING[55] = true;
        ScannerImpl.CHOMPING[56] = true;
        ScannerImpl.CHOMPING[57] = true;
        ScannerImpl.CHOMPING[35] = true;
        ScannerImpl.CHOMPING[32] = true;
        Arrays.fill(ALL_TRUE, true);
        ScannerImpl.LINEBR[10] = true;
        ScannerImpl.NULL_BL_LINEBR[0] = true;
        ScannerImpl.NULL_BL_LINEBR[32] = true;
        ScannerImpl.NULL_BL_LINEBR[13] = true;
        ScannerImpl.NULL_BL_LINEBR[10] = true;
        ScannerImpl.NULL_BL_T_LINEBR[0] = true;
        ScannerImpl.NULL_BL_T_LINEBR[32] = true;
        ScannerImpl.NULL_BL_T_LINEBR[9] = true;
        ScannerImpl.NULL_BL_T_LINEBR[13] = true;
        ScannerImpl.NULL_BL_T_LINEBR[10] = true;
        ScannerImpl.NULL_OR_LINEBR[0] = true;
        ScannerImpl.NULL_OR_LINEBR[13] = true;
        ScannerImpl.NULL_OR_LINEBR[10] = true;
        ScannerImpl.FULL_LINEBR[13] = true;
        ScannerImpl.FULL_LINEBR[10] = true;
        ScannerImpl.BLANK_OR_LINEBR[32] = true;
        ScannerImpl.BLANK_OR_LINEBR[13] = true;
        ScannerImpl.BLANK_OR_LINEBR[10] = true;
        ScannerImpl.S4[0] = true;
        ScannerImpl.S4[32] = true;
        ScannerImpl.S4[9] = true;
        ScannerImpl.S4[13] = true;
        ScannerImpl.S4[10] = true;
        ScannerImpl.S4[91] = true;
        ScannerImpl.S4[93] = true;
        ScannerImpl.S4[123] = true;
        ScannerImpl.S4[125] = true;
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            ScannerImpl.ALPHA[c] = true;
            ScannerImpl.STRANGE_CHAR[c] = true;
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            ScannerImpl.ALPHA[c] = true;
            ScannerImpl.STRANGE_CHAR[c] = true;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            ScannerImpl.ALPHA[c] = true;
            ScannerImpl.STRANGE_CHAR[c] = true;
            ScannerImpl.HEXA[c] = true;
            ScannerImpl.DIGIT[c] = true;
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            ScannerImpl.HEXA[c] = true;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            ScannerImpl.HEXA[c] = true;
        }
        ScannerImpl.ALPHA[45] = true;
        ScannerImpl.ALPHA[95] = true;
        ScannerImpl.STRANGE_CHAR[45] = true;
        ScannerImpl.STRANGE_CHAR[95] = true;
        ScannerImpl.STRANGE_CHAR[91] = true;
        ScannerImpl.STRANGE_CHAR[93] = true;
        ScannerImpl.STRANGE_CHAR[40] = true;
        ScannerImpl.STRANGE_CHAR[41] = true;
        ScannerImpl.STRANGE_CHAR[39] = true;
        ScannerImpl.STRANGE_CHAR[59] = true;
        ScannerImpl.STRANGE_CHAR[47] = true;
        ScannerImpl.STRANGE_CHAR[63] = true;
        ScannerImpl.STRANGE_CHAR[58] = true;
        ScannerImpl.STRANGE_CHAR[64] = true;
        ScannerImpl.STRANGE_CHAR[38] = true;
        ScannerImpl.STRANGE_CHAR[61] = true;
        ScannerImpl.STRANGE_CHAR[43] = true;
        ScannerImpl.STRANGE_CHAR[36] = true;
        ScannerImpl.STRANGE_CHAR[44] = true;
        ScannerImpl.STRANGE_CHAR[46] = true;
        ScannerImpl.STRANGE_CHAR[33] = true;
        ScannerImpl.STRANGE_CHAR[126] = true;
        ScannerImpl.STRANGE_CHAR[42] = true;
        ScannerImpl.STRANGE_CHAR[37] = true;
        ScannerImpl.STRANGE_CHAR[94] = true;
        ScannerImpl.STRANGE_CHAR[35] = true;
        ScannerImpl.BLANK_T[32] = true;
        ScannerImpl.BLANK_T[9] = true;
        ScannerImpl.SPACES_AND_STUFF[0] = true;
        ScannerImpl.SPACES_AND_STUFF[32] = true;
        ScannerImpl.SPACES_AND_STUFF[9] = true;
        ScannerImpl.SPACES_AND_STUFF[13] = true;
        ScannerImpl.SPACES_AND_STUFF[10] = true;
        ScannerImpl.SPACES_AND_STUFF[92] = true;
        ScannerImpl.SPACES_AND_STUFF[39] = true;
        ScannerImpl.SPACES_AND_STUFF[34] = true;
        ScannerImpl.DOUBLE_ESC[92] = true;
        ScannerImpl.DOUBLE_ESC[34] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[0] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[32] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[9] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[13] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[10] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[63] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[58] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[44] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[93] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[125] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[37] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[64] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[96] = true;
        Arrays.fill(ESCAPE_REPLACEMENTS, (byte)0);
        ScannerImpl.ESCAPE_REPLACEMENTS[48] = 0;
        ScannerImpl.ESCAPE_REPLACEMENTS[97] = 7;
        ScannerImpl.ESCAPE_REPLACEMENTS[98] = 8;
        ScannerImpl.ESCAPE_REPLACEMENTS[116] = 9;
        ScannerImpl.ESCAPE_REPLACEMENTS[9] = 9;
        ScannerImpl.ESCAPE_REPLACEMENTS[110] = 10;
        ScannerImpl.ESCAPE_REPLACEMENTS[118] = 11;
        ScannerImpl.ESCAPE_REPLACEMENTS[102] = 12;
        ScannerImpl.ESCAPE_REPLACEMENTS[114] = 13;
        ScannerImpl.ESCAPE_REPLACEMENTS[101] = 27;
        ScannerImpl.ESCAPE_REPLACEMENTS[34] = 34;
        ScannerImpl.ESCAPE_REPLACEMENTS[92] = 92;
        ScannerImpl.ESCAPE_REPLACEMENTS[78] = -123;
        ScannerImpl.ESCAPE_REPLACEMENTS[95] = -96;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[48] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[97] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[98] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[116] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[9] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[110] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[118] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[102] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[114] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[101] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[34] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[92] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[78] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[95] = true;
        ESCAPE_CODES.put(new Character('x'), new Integer(2));
        ESCAPE_CODES.put(new Character('u'), new Integer(4));
        ESCAPE_CODES.put(new Character('U'), new Integer(8));
        Arrays.fill(STUPID_CHAR, true);
        ScannerImpl.STUPID_CHAR[0] = false;
        ScannerImpl.STUPID_CHAR[32] = false;
        ScannerImpl.STUPID_CHAR[9] = false;
        ScannerImpl.STUPID_CHAR[13] = false;
        ScannerImpl.STUPID_CHAR[10] = false;
        ScannerImpl.STUPID_CHAR[45] = false;
        ScannerImpl.STUPID_CHAR[63] = false;
        ScannerImpl.STUPID_CHAR[58] = false;
        ScannerImpl.STUPID_CHAR[91] = false;
        ScannerImpl.STUPID_CHAR[93] = false;
        ScannerImpl.STUPID_CHAR[123] = false;
        ScannerImpl.STUPID_CHAR[35] = false;
        ScannerImpl.STUPID_CHAR[33] = false;
        ScannerImpl.STUPID_CHAR[39] = false;
        ScannerImpl.STUPID_CHAR[34] = false;
        ScannerImpl.STUPID_CHAR[64] = false;
        ScannerImpl.R_FLOWZERO1[58] = true;
        ScannerImpl.R_FLOWNONZERO[0] = true;
        ScannerImpl.R_FLOWNONZERO[32] = true;
        ScannerImpl.R_FLOWNONZERO[9] = true;
        ScannerImpl.R_FLOWNONZERO[13] = true;
        ScannerImpl.R_FLOWNONZERO[10] = true;
        ScannerImpl.R_FLOWNONZERO[91] = true;
        ScannerImpl.R_FLOWNONZERO[93] = true;
        ScannerImpl.R_FLOWNONZERO[123] = true;
        ScannerImpl.R_FLOWNONZERO[125] = true;
        ScannerImpl.R_FLOWNONZERO[44] = true;
        ScannerImpl.R_FLOWNONZERO[58] = true;
        ScannerImpl.R_FLOWNONZERO[63] = true;
        HEXA_VALUES = new byte[256];
        Arrays.fill(HEXA_VALUES, (byte)-1);
        ScannerImpl.HEXA_VALUES[48] = 0;
        ScannerImpl.HEXA_VALUES[49] = 1;
        ScannerImpl.HEXA_VALUES[50] = 2;
        ScannerImpl.HEXA_VALUES[51] = 3;
        ScannerImpl.HEXA_VALUES[52] = 4;
        ScannerImpl.HEXA_VALUES[53] = 5;
        ScannerImpl.HEXA_VALUES[54] = 6;
        ScannerImpl.HEXA_VALUES[55] = 7;
        ScannerImpl.HEXA_VALUES[56] = 8;
        ScannerImpl.HEXA_VALUES[57] = 9;
        ScannerImpl.HEXA_VALUES[65] = 10;
        ScannerImpl.HEXA_VALUES[66] = 11;
        ScannerImpl.HEXA_VALUES[67] = 12;
        ScannerImpl.HEXA_VALUES[68] = 13;
        ScannerImpl.HEXA_VALUES[69] = 14;
        ScannerImpl.HEXA_VALUES[70] = 15;
        ScannerImpl.HEXA_VALUES[97] = 10;
        ScannerImpl.HEXA_VALUES[98] = 11;
        ScannerImpl.HEXA_VALUES[99] = 12;
        ScannerImpl.HEXA_VALUES[100] = 13;
        ScannerImpl.HEXA_VALUES[101] = 14;
        ScannerImpl.HEXA_VALUES[102] = 15;
    }

    private class TokenIterator
    implements Iterator {
        private TokenIterator() {
        }

        public boolean hasNext() {
            return null != ScannerImpl.this.peekToken();
        }

        public Object next() {
            return ScannerImpl.this.getToken();
        }

        public void remove() {
        }
    }
}

