/*
 * Decompiled with CFR 0.152.
 */
package net.java.bd.tools.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateVersion;

public class CertificateVerifier {
    private String errorString = null;

    public static void main(String[] args) throws CertificateException {
        if (args == null || args.length < 1) {
            CertificateVerifier.printUsage();
            return;
        }
        File appCertFile = new File(args[0]);
        File rootCertFile = new File(args[1]);
        if (!appCertFile.exists() || !rootCertFile.exists()) {
            System.out.println("File not found " + appCertFile.getAbsolutePath() + ", " + rootCertFile.getAbsolutePath());
            CertificateVerifier.printUsage();
            return;
        }
        new CertificateVerifier().runTest(appCertFile, rootCertFile);
    }

    public boolean runTest(File appCertFile, File rootCertFile) {
        boolean failed = false;
        System.out.println("Starting the verfication");
        X509Certificate appCert = null;
        X509Certificate rootCert = null;
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            rootCert = (X509Certificate)factory.generateCertificate(new FileInputStream(rootCertFile));
            appCert = (X509Certificate)factory.generateCertificate(new FileInputStream(appCertFile));
        }
        catch (Exception e) {
            System.out.println("Error in creating certificate from a file");
            e.printStackTrace();
            failed = true;
        }
        if (!failed) {
            System.out.println("Checking the application certiticate");
            try {
                this.checkCert(appCert, false);
                this.doParsingChecks(appCertFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.errorString != null) {
                System.out.println(this.errorString);
                failed = true;
            }
            this.errorString = null;
            System.out.println("Checking the root certificate");
            try {
                this.checkCert(rootCert, true);
                this.doParsingChecks(rootCertFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (appCert.getSerialNumber().equals(rootCert.getSerialNumber())) {
                this.errorString = this.errorString + "Two certificates have the same serial number";
            }
            if (this.errorString != null) {
                System.out.println(this.errorString);
                failed = true;
            }
        }
        System.out.println("Done with the verification");
        return !failed;
    }

    private void doParsingChecks(File file) throws Exception {
        FileInputStream fin = new FileInputStream(file);
        DerValue tmp = new DerValue(fin).getData().getDerValue();
        if (tmp.tag != 48) {
            throw new CertificateParsingException("signed fields invalid");
        }
        DerInputStream in = tmp.getData();
        tmp = in.getDerValue();
        CertificateVersion version = null;
        if (tmp.isContextSpecific((byte)0)) {
            version = new CertificateVersion(tmp);
            tmp = in.getDerValue();
        }
        CertificateSerialNumber serialNum = new CertificateSerialNumber(tmp);
        CertificateAlgorithmId algId = new CertificateAlgorithmId(in);
        this.checkForUTF8String(in.toByteArray());
        tmp = in.getDerValue();
        this.checkForGeneralizedTime(in.toByteArray());
        tmp = in.getDerValue();
        this.checkForUTF8String(in.toByteArray());
    }

    private void checkForGeneralizedTime(byte[] validity) throws IOException {
        DerInputStream stream = new DerInputStream(validity);
        DerValue[] values = stream.getSequence(2);
        for (int i = 0; i < 2; ++i) {
            if (values[i].tag == 24) continue;
            this.errorString = this.errorString + "\nCheckFormat, validity not in GeneralizedTime format, tag = " + Integer.toHexString(values[i].tag);
        }
    }

    private void checkForUTF8String(byte[] names) throws IOException {
        DerInputStream stream = new DerInputStream(names);
        DerValue[] values = stream.getSequence(5);
        for (int i = 0; i < values.length; ++i) {
            stream = values[i].getData();
            DerValue[] sets = stream.getSequence(2);
            if (sets[1].tag == 12) continue;
            this.errorString = this.errorString + "\nCheckUTF8String, name includes non-UTF8String encoding";
        }
    }

    private void checkCert(X509Certificate cert, boolean isRootCertificate) throws CertificateParsingException {
        int basicConstraints;
        Collection<List<?>> subjectAltName;
        Set<String> criticalExtensions;
        String certAlg = cert.getSigAlgName();
        if (!certAlg.equalsIgnoreCase("SHA1withRSA")) {
            this.errorString = this.errorString + "\nCheckCertAlgorithm, not SHA1withRSA";
        }
        if ((criticalExtensions = cert.getCriticalExtensionOIDs()) == null) {
            this.errorString = this.errorString + "\nCheckExtensions, no critical extensions found";
            return;
        }
        if (!criticalExtensions.contains("2.5.29.15")) {
            this.errorString = this.errorString + "\nCheckExtensions, KeyUsage extension not marked critical";
            return;
        }
        boolean[] keyUsage = cert.getKeyUsage();
        boolean[] expected = isRootCertificate ? new boolean[]{false, false, false, false, false, true, false, false, false} : new boolean[]{true, false, false, false, false, false, false, false, false};
        for (int i = 0; i < expected.length; ++i) {
            if (keyUsage[i] == expected[i]) continue;
            this.errorString = this.errorString + "\nCheckKeyUsageExtension, wrong usage set " + i;
        }
        Collection<List<?>> issuerAltName = cert.getIssuerAlternativeNames();
        if (issuerAltName == null || issuerAltName.isEmpty()) {
            this.errorString = this.errorString + "\nCheckExtensions, no IssuerAlternativeName set";
        }
        if ((subjectAltName = cert.getSubjectAlternativeNames()) == null || subjectAltName.isEmpty()) {
            this.errorString = this.errorString + "\nCheckExtensions, no SubjectAlternativeName set";
        }
        if (isRootCertificate && (basicConstraints = cert.getBasicConstraints()) == 1) {
            this.errorString = this.errorString + "\nCheckExtensions, root certificate missing or having non-critical BasicConstraints";
        }
    }

    public static void printUsage() {
        System.out.println("Certificate Verififer <application certificate> <root certificate>");
    }
}

