/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.anttasks;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.netbeans.modules.soa.validation.core.Controller;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xslt.project.CommandlineXsltProjectXmlCatalogProvider;
import org.netbeans.modules.xslt.project.anttasks.IDETMapCatalogModel;
import org.netbeans.modules.xslt.project.anttasks.IdeXslCatalogModel;
import org.netbeans.modules.xslt.project.anttasks.Util;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;

public class IdeValidateProjectTask
extends Task {
    private String mSourceDirectory;
    private String mProjectClassPath;
    private String mBuildDirectory;
    private String mBuildDependentProjectFilesDirectory;
    private File mSourceDir;
    private File mBuildDir;
    private Map myFileNamesToFileInBuildDir = new HashMap();
    private boolean isFoundErrors = false;
    private boolean myAllowBuildWithError = false;

    public void setSourceDirectory(String srcDir) {
        this.mSourceDirectory = srcDir;
    }

    public void setBuildDirectory(String buildDir) {
        this.mBuildDirectory = buildDir;
    }

    public void setRunValidation(String flag) {
        this.setAllowBuildWithError(flag);
        this.myAllowBuildWithError = !this.myAllowBuildWithError;
    }

    public void setAllowBuildWithError(String flag) {
        if (flag != null) {
            if (flag.equals("false")) {
                this.myAllowBuildWithError = false;
            } else if (flag.equals("true")) {
                this.myAllowBuildWithError = true;
            }
        }
    }

    public void setClasspathRef(Reference ref) {
    }

    public void setProjectClassPath(String projectClassPath) {
        this.mProjectClassPath = projectClassPath;
    }

    public void setBuildDependentProjectDir(String dependentProjectFilesDir) {
        this.mBuildDependentProjectFilesDirectory = dependentProjectFilesDir;
    }

    public boolean isFoundErrors() {
        return this.isFoundErrors;
    }

    public void execute() throws BuildException {
        if (this.mSourceDirectory == null) {
            throw new BuildException("No directory is set for source files.");
        }
        if (this.mBuildDirectory == null) {
            throw new BuildException("No build directory is set.");
        }
        if (this.mBuildDependentProjectFilesDirectory == null) {
            throw new BuildException("No dependentProjectFiles directory is set.");
        }
        try {
            this.mSourceDir = new File(this.mSourceDirectory);
            CommandlineXsltProjectXmlCatalogProvider.getInstance().setSourceDirectory(this.mSourceDirectory);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to get File object for project source directory " + this.mSourceDirectory, (Throwable)ex);
        }
        try {
            this.mBuildDir = new File(this.mBuildDirectory);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to get File object for project build directory " + this.mBuildDirectory, (Throwable)ex);
        }
        this.processFilesFolderInBuildDir(this.mBuildDir);
        this.processSourceDirs(Arrays.asList(this.mSourceDir));
    }

    private void processFilesFolderInBuildDir(File folder) {
        File[] files = folder.listFiles(new Util.XsltFileFilter());
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isFile()) {
                this.processFilesInBuildDir(file);
                continue;
            }
            this.processFilesFolderInBuildDir(file);
        }
    }

    private void processFilesInBuildDir(File file) {
        String relativePath = Util.getRelativePath(this.mBuildDir, file);
        this.myFileNamesToFileInBuildDir.put(relativePath, file);
    }

    private void processSourceDirs(List sourceDirs) {
        for (File sourceDir : sourceDirs) {
            this.processSourceDir(sourceDir);
        }
    }

    private void processSourceDir(File sourceDir) {
        this.processFileObject(sourceDir);
    }

    private void processFileObject(File file) {
        if (file.isDirectory()) {
            this.processFolder(file);
        }
    }

    private void processFolder(File fileDir) {
        File[] files = fileDir.listFiles(new Util.XsltFileFilter());
        this.processFiles(files);
    }

    private void processFiles(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                this.processFile(files[i]);
                continue;
            }
            this.processFolder(files[i]);
        }
    }

    private void processFile(File file) throws BuildException {
        block3: {
            if (this.isFileModified(file)) {
                try {
                    this.validateFile(file);
                }
                catch (Throwable ex) {
                    if (this.myAllowBuildWithError) break block3;
                    throw new BuildException(ex);
                }
            }
        }
    }

    private boolean isFileModified(File file) {
        boolean modified = true;
        String relativePath = Util.getRelativePath(this.mSourceDir, file);
        File mFileInBuildDir = (File)this.myFileNamesToFileInBuildDir.get(relativePath);
        if (mFileInBuildDir != null && mFileInBuildDir.lastModified() == file.lastModified()) {
            modified = false;
        }
        return modified;
    }

    private void validateFile(File file) throws BuildException {
        TMapModel model = null;
        try {
            model = IDETMapCatalogModel.getDefault().getTMapModel(file);
        }
        catch (Exception e) {
            model = null;
        }
        this.validateModel(file, (Model)model);
        try {
            model = IdeXslCatalogModel.getDefault().getXslModel(file);
        }
        catch (Exception e) {
            model = null;
        }
        this.validateModel(file, (Model)model);
    }

    private void validateModel(File file, Model model) throws BuildException {
        if (model == null) {
            return;
        }
        if (new Controller(model).ideValidate(file)) {
            throw new BuildException("Found validation error(s).");
        }
    }
}

