/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.parser.ParserSvnInfo;
import org.netbeans.modules.subversion.client.parser.SvnWcUtils;
import org.netbeans.modules.subversion.config.KVFile;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesClient {
    private final File file;

    public PropertiesClient(File file) {
        assert (file != null);
        this.file = file;
    }

    public Map<String, byte[]> getBaseProperties() throws IOException {
        File file;
        try {
            file = this.getPropertyFile(true);
        }
        catch (SVNClientException sVNClientException) {
            throw new IOException(sVNClientException.getMessage());
        }
        if (file != null && file.isFile()) {
            KVFile kVFile = new KVFile(file);
            return kVFile.getNormalizedMap();
        }
        return new HashMap<String, byte[]>();
    }

    public Map<String, byte[]> getProperties() throws IOException {
        File file;
        try {
            file = this.getPropertyFile(false);
        }
        catch (SVNClientException sVNClientException) {
            throw new IOException(sVNClientException.getMessage());
        }
        if (file != null && file.isFile()) {
            KVFile kVFile = new KVFile(file);
            return kVFile.getNormalizedMap();
        }
        return new HashMap<String, byte[]>();
    }

    private File getPropertyFile(boolean bl) throws SVNClientException {
        SvnClient svnClient = Subversion.getInstance().getClient(false);
        ISVNInfo iSVNInfo = null;
        iSVNInfo = svnClient.getInfoFromWorkingCopy(this.file);
        if (iSVNInfo instanceof ParserSvnInfo) {
            if (bl) {
                return ((ParserSvnInfo)iSVNInfo).getBasePropertyFile();
            }
            return ((ParserSvnInfo)iSVNInfo).getPropertyFile();
        }
        return SvnWcUtils.getPropertiesFile(this.file, bl);
    }

    public Map getProperties(int n) throws IOException {
        throw new UnsupportedOperationException();
    }
}

