/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class DiffStreamSource
extends StreamSource
implements Cancellable {
    private final File baseFile;
    private final String revision;
    private final String title;
    private String mimeType;
    private SVNUrl url;
    private SVNUrl repoUrl;
    private SvnClient client;
    private File remoteFile;

    public DiffStreamSource(File file, SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, String string2) {
        this.baseFile = file;
        this.revision = string;
        this.title = string2;
        this.url = sVNUrl2;
        this.repoUrl = sVNUrl;
    }

    public String getName() {
        if (this.baseFile != null) {
            return this.baseFile.getName();
        }
        return NbBundle.getMessage(DiffStreamSource.class, (String)"LBL_Diff_Anonymous");
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized String getMIMEType() {
        try {
            this.init();
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.INFO, "DiffStreamSource.getMIMEType() returns null", iOException);
            return null;
        }
        return this.mimeType;
    }

    public synchronized Reader createReader() throws IOException {
        this.init();
        if (this.revision == null || this.remoteFile == null) {
            return null;
        }
        if (!this.mimeType.startsWith("text/")) {
            return null;
        }
        return Utils.createReader((File)this.remoteFile);
    }

    public Writer createWriter(Difference[] differenceArray) throws IOException {
        throw new IOException("Operation not supported");
    }

    public boolean isEditable() {
        return false;
    }

    private boolean isPrimary() {
        FileObject fileObject = FileUtil.toFileObject((File)this.baseFile);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                return fileObject.equals(dataObject.getPrimaryFile());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized Lookup getLookup() {
        try {
            this.init();
        }
        catch (IOException iOException) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        if (this.remoteFile == null || !this.isPrimary()) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        FileObject fileObject = FileUtil.toFileObject((File)this.remoteFile);
        if (fileObject == null) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        return Lookups.fixed((Object[])new Object[]{fileObject});
    }

    synchronized void init() throws IOException {
        if (this.remoteFile != null || this.revision == null) {
            return;
        }
        if (this.baseFile.isDirectory()) {
            this.mimeType = "content/unknown";
            return;
        }
        this.mimeType = SvnUtils.getMimeType(this.baseFile);
        try {
            if (this.isEditable()) {
                this.remoteFile = VersionsCache.getInstance().getFileRevision(this.baseFile, this.revision);
            } else {
                this.client = Subversion.getInstance().getClient(this.repoUrl);
                InputStream inputStream = null;
                try {
                    inputStream = SvnClientFactory.isCLI() ? this.client.getContent(this.url.appendPath("@" + this.revision), SvnUtils.toSvnRevision(this.revision)) : this.client.getContent(this.url, SvnUtils.toSvnRevision(this.revision), SvnUtils.toSvnRevision(this.revision));
                }
                catch (SVNClientException sVNClientException) {
                    if (SvnClientExceptionHandler.isFileNotFoundInRevision(sVNClientException.getMessage()) || SvnClientExceptionHandler.isPathNotFound(sVNClientException.getMessage())) {
                        inputStream = new ByteArrayInputStream(new byte[0]);
                    }
                    throw sVNClientException;
                }
                File file = File.createTempFile("nb-svn", this.baseFile.getName());
                file = FileUtil.normalizeFile((File)file);
                file.deleteOnExit();
                FileUtils.copyStreamToFile(new BufferedInputStream(inputStream), file);
                if (file == null) {
                    this.remoteFile = null;
                    return;
                }
                this.remoteFile = file;
                Utils.associateEncoding((File)this.baseFile, (File)file);
            }
            if (!this.baseFile.exists() && this.remoteFile != null && this.remoteFile.exists()) {
                this.mimeType = SvnUtils.getMimeType(this.remoteFile);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Can not load remote file for " + this.baseFile);
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public boolean cancel() {
        if (this.client != null) {
            this.client.cancel();
        }
        return true;
    }
}

