/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.update.RevertModifications;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevertModificationsAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Revert";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 7672;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return 7672;
    }

    @Override
    protected void performContextAction(Node[] nodeArray) {
        SVNUrl sVNUrl;
        SVNUrl sVNUrl2;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        final Context context = this.getContext(nodeArray);
        File file = context.getRootFiles()[0];
        try {
            sVNUrl2 = SvnUtils.getRepositoryRootUrl(file);
            sVNUrl = SvnUtils.getRepositoryUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(sVNUrl2, sVNUrl, SVNRevision.HEAD);
        final RevertModifications revertModifications = new RevertModifications(repositoryFile);
        if (!revertModifications.showDialog()) {
            return;
        }
        ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(this, nodeArray){

            public void perform() {
                RevertModificationsAction.performRevert(revertModifications.getRevisionInterval(), revertModifications.revertNewFiles(), context, this);
            }
        };
        progressSupport.start(this.createRequestProcessor(nodeArray));
    }

    public static void performRevert(RevertModifications.RevisionInterval revisionInterval, boolean bl, Context context, SvnProgressSupport svnProgressSupport) {
        boolean bl2;
        SvnClient svnClient;
        try {
            svnClient = Subversion.getInstance().getClient(context, svnProgressSupport);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        SVNUrl sVNUrl = context.getFiles();
        File[][] fileArray = Utils.splitFlatOthers((File[])sVNUrl);
        for (int i = 0; i < fileArray.length; ++i) {
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            sVNUrl = fileArray[i];
            boolean bl3 = bl2 = i == 1;
            if (!bl2) {
                sVNUrl = SvnUtils.flatten((File[])sVNUrl, 6608);
            }
            try {
                if (revisionInterval != null) {
                    for (int j = 0; j < ((File[])sVNUrl).length; ++j) {
                        if (svnProgressSupport.isCanceled()) {
                            return;
                        }
                        SVNUrl sVNUrl2 = SvnUtils.getRepositoryUrl(sVNUrl[j]);
                        revisionInterval = RevertModificationsAction.recountStartRevision(svnClient, sVNUrl2, revisionInterval);
                        if (sVNUrl[j].exists()) {
                            svnClient.merge(sVNUrl2, revisionInterval.endRevision, sVNUrl2, revisionInterval.startRevision, (File)sVNUrl[j], false, bl2);
                            continue;
                        }
                        assert (revisionInterval.startRevision instanceof SVNRevision.Number) : "The revision has to be a Number when trying to undelete file!";
                        svnClient.copy(sVNUrl2, (File)sVNUrl[j], revisionInterval.startRevision);
                    }
                    continue;
                }
                if (svnProgressSupport.isCanceled()) {
                    return;
                }
                if (((File[])sVNUrl).length <= 0) continue;
                HashSet<File> hashSet = new HashSet<File>();
                for (SVNUrl sVNUrl3 : sVNUrl) {
                    hashSet.addAll(RevertModificationsAction.getDeletedParents((File)sVNUrl3));
                }
                for (SVNUrl sVNUrl3 : sVNUrl) {
                    svnClient.revert((File)sVNUrl3, bl2);
                }
                if (hashSet.size() <= 0) continue;
                for (File file : hashSet) {
                    svnClient.revert(file, false);
                }
                continue;
            }
            catch (SVNClientException sVNClientException) {
                svnProgressSupport.annotate(sVNClientException);
            }
        }
        if (svnProgressSupport.isCanceled()) {
            return;
        }
        if (bl) {
            File[] fileArray2 = Subversion.getInstance().getStatusCache().listFiles(context.getRootFiles(), 4100);
            for (bl2 = false; bl2 < fileArray2.length; bl2 += 1) {
                FileObject fileObject = FileUtil.toFileObject((File)fileArray2[bl2]);
                try {
                    if (fileObject == null) continue;
                    fileObject.delete();
                    continue;
                }
                catch (IOException iOException) {
                    Subversion.LOG.log(Level.SEVERE, null, iOException);
                }
            }
        }
    }

    private static List<File> getDeletedParents(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
            FileInformation fileInformation = Subversion.getInstance().getStatusCache().getStatus(file2);
            if ((fileInformation.getStatus() & 0x100) == 0 && (fileInformation.getStatus() & 0x800) == 0) {
                return arrayList;
            }
            arrayList.add(file2);
        }
        return arrayList;
    }

    private static RevertModifications.RevisionInterval recountStartRevision(SvnClient svnClient, SVNUrl sVNUrl, RevertModifications.RevisionInterval revisionInterval) throws SVNClientException {
        long l;
        if (revisionInterval.startRevision.equals((Object)SVNRevision.HEAD)) {
            ISVNInfo iSVNInfo = svnClient.getInfo(sVNUrl);
            revisionInterval.startRevision = iSVNInfo.getRevision();
        }
        if ((l = Long.parseLong(revisionInterval.startRevision.toString())) > 0L) {
            --l;
        }
        revisionInterval.startRevision = new SVNRevision.Number(l);
        return revisionInterval;
    }
}

