/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.highlight.semantic.ReferenceCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    static List<CsmReference> collect(final CsmFile csmFile, final ReferenceCollector referenceCollector) {
        CsmFileReferences.getDefault().accept((CsmScope)csmFile, new CsmFileReferences.Visitor(){

            public void visit(CsmReferenceContext csmReferenceContext) {
                referenceCollector.visit(csmReferenceContext.getReference(), csmFile);
            }
        });
        return referenceCollector.getReferences();
    }

    static List<CsmOffsetable> getInactiveCodeBlocks(CsmFile csmFile) {
        return CsmFileInfoQuery.getDefault().getUnusedCodeBlocks(csmFile);
    }

    static List<CsmReference> getMacroBlocks(CsmFile csmFile) {
        return CsmFileInfoQuery.getDefault().getMacroUsages(csmFile);
    }

    private static class ReferenceCounter {
        private CsmReference reference;
        private int count;

        public ReferenceCounter(CsmReference csmReference) {
            this.reference = csmReference;
            this.count = 1;
        }

        public CsmReference getFirstReference() {
            return this.reference;
        }

        public int getCount() {
            return this.count;
        }

        public void increment() {
            ++this.count;
            this.reference = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnusedVariableCollector
    implements ReferenceCollector {
        private final Map<CsmUID, ReferenceCounter> counters = new LinkedHashMap<CsmUID, ReferenceCounter>();
        private Set<CsmUID> parameters;

        public String getEntityName() {
            return "unused-variables";
        }

        @Override
        public void visit(CsmReference csmReference, CsmFile csmFile) {
            CsmObject csmObject = csmReference.getReferencedObject();
            if (this.isWanted(csmObject, csmFile)) {
                CsmUID csmUID = ((CsmVariable)csmObject).getUID();
                ReferenceCounter referenceCounter = this.counters.get(csmUID);
                if (referenceCounter == null) {
                    referenceCounter = new ReferenceCounter(csmReference);
                    this.counters.put(csmUID, referenceCounter);
                } else {
                    referenceCounter.increment();
                }
            }
        }

        @Override
        public List<CsmReference> getReferences() {
            ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>();
            for (ReferenceCounter referenceCounter : this.counters.values()) {
                if (referenceCounter.getCount() != 1) continue;
                arrayList.add(referenceCounter.getFirstReference());
            }
            return arrayList;
        }

        private boolean isWanted(CsmObject csmObject, CsmFile csmFile) {
            if (!CsmKindUtilities.isLocalVariable((CsmObject)csmObject)) {
                return false;
            }
            CsmVariable csmVariable = (CsmVariable)csmObject;
            if (!csmVariable.getContainingFile().equals(csmFile)) {
                return false;
            }
            if (CsmKindUtilities.isParameter((CsmObject)csmObject)) {
                Set<CsmUID> set = this.getFunctionDefinitionParameters(csmFile);
                return set.contains(csmVariable.getUID());
            }
            return true;
        }

        private Set<CsmUID> getFunctionDefinitionParameters(CsmFile csmFile) {
            if (this.parameters == null) {
                this.parameters = new HashSet<CsmUID>();
                CsmSelect csmSelect = CsmSelect.getDefault();
                CsmSelect.CsmFilter csmFilter = csmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION_DEFINITION});
                Iterator iterator = csmSelect.getDeclarations(csmFile, csmFilter);
                while (iterator.hasNext()) {
                    CsmFunctionDefinition csmFunctionDefinition = (CsmFunctionDefinition)iterator.next();
                    for (Object e : csmFunctionDefinition.getParameters()) {
                        this.parameters.add(((CsmParameter)e).getUID());
                    }
                }
            }
            return this.parameters;
        }
    }

    static class FunctionReferenceCollector
    extends AbstractReferenceCollector {
        FunctionReferenceCollector() {
        }

        public String getEntityName() {
            return "functions-names";
        }

        public void visit(CsmReference csmReference, CsmFile csmFile) {
            if (this.isWanted(csmReference, csmFile)) {
                this.list.add(csmReference);
            }
        }

        private boolean isWanted(CsmReference csmReference, CsmFile csmFile) {
            CsmFunctionDefinition csmFunctionDefinition;
            CsmObject csmObject = csmReference.getReferencedObject();
            if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmObject)) {
                CsmOffsetableDeclaration csmOffsetableDeclaration = (CsmOffsetableDeclaration)csmObject;
                if (csmOffsetableDeclaration.getContainingFile().equals(csmFile) && csmOffsetableDeclaration.getStartOffset() <= csmReference.getStartOffset() && csmOffsetableDeclaration.getEndOffset() >= csmReference.getEndOffset()) {
                    return true;
                }
                CsmFunctionDefinition csmFunctionDefinition2 = ((CsmFunction)csmObject).getDefinition();
                if (csmFunctionDefinition2 != null && csmFile.equals(csmFunctionDefinition2.getContainingFile()) && csmFunctionDefinition2.getStartOffset() <= csmReference.getStartOffset() && csmReference.getStartOffset() <= csmFunctionDefinition2.getBody().getStartOffset()) {
                    return true;
                }
            } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject) && csmFile.equals((csmFunctionDefinition = (CsmFunctionDefinition)csmObject).getContainingFile()) && csmFunctionDefinition.getStartOffset() <= csmReference.getStartOffset() && csmReference.getStartOffset() <= csmFunctionDefinition.getBody().getStartOffset()) {
                return true;
            }
            return false;
        }
    }

    static class TypedefReferenceCollector
    extends AbstractReferenceCollector {
        TypedefReferenceCollector() {
        }

        public String getEntityName() {
            return "typedefs";
        }

        public void visit(CsmReference csmReference, CsmFile csmFile) {
            CsmObject csmObject = csmReference.getReferencedObject();
            if (CsmKindUtilities.isTypedef((CsmObject)csmObject)) {
                this.list.add(csmReference);
            }
        }
    }

    static class FieldReferenceCollector
    extends AbstractReferenceCollector {
        FieldReferenceCollector() {
        }

        public String getEntityName() {
            return "class-fields";
        }

        public void visit(CsmReference csmReference, CsmFile csmFile) {
            CsmObject csmObject = csmReference.getReferencedObject();
            if (CsmKindUtilities.isField((CsmObject)csmObject)) {
                this.list.add(csmReference);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractReferenceCollector
    implements ReferenceCollector {
        protected final List<CsmReference> list = new ArrayList<CsmReference>();

        @Override
        public List<CsmReference> getReferences() {
            return this.list;
        }
    }
}

