/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.highlight.InterrupterImpl;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.ReferenceCollector;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntitiesProvider;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntity;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.modules.cnd.modelutil.NamedEntity;
import org.netbeans.modules.cnd.modelutil.NamedEntityOptions;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SemanticHighlighter
extends HighlighterBase {
    private static final boolean SHOW_TIMES = Boolean.getBoolean("cnd.highlighting.times");
    private static final int MAX_LINE_NUMBER;

    public SemanticHighlighter(Document document) {
        super(document);
        this.init(document);
    }

    @Override
    protected void updateFontColors(FontColorProvider fontColorProvider) {
        for (SemanticEntity semanticEntity : SemanticEntitiesProvider.instance().get()) {
            semanticEntity.updateFontColors(fontColorProvider);
        }
    }

    public static OffsetsBag getHighlightsBag(Document document) {
        if (document == null) {
            return null;
        }
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(SemanticHighlighter.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document);
            document.putProperty(SemanticHighlighter.class, offsetsBag);
        }
        return offsetsBag;
    }

    public static boolean isVeryBigDocument(Document document) {
        if (!(document instanceof BaseDocument) || MAX_LINE_NUMBER < 0) {
            return false;
        }
        try {
            if (document.getLength() < MAX_LINE_NUMBER) {
                return false;
            }
            return Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)(document.getLength() - 1)) > MAX_LINE_NUMBER;
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(final CsmReferenceRepository.Interrupter interrupter) {
        BaseDocument baseDocument = this.getDocument();
        if (baseDocument != null) {
            DocumentListener documentListener = null;
            if (interrupter instanceof InterrupterImpl) {
                documentListener = new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        ((InterrupterImpl)interrupter).cancel();
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        ((InterrupterImpl)interrupter).cancel();
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                    }
                };
                baseDocument.addDocumentListener(documentListener);
            }
            try {
                this.update(baseDocument, interrupter);
            }
            finally {
                if (documentListener != null) {
                    baseDocument.removeDocumentListener(documentListener);
                }
            }
        }
    }

    private void update(BaseDocument baseDocument, final CsmReferenceRepository.Interrupter interrupter) {
        OffsetsBag offsetsBag = new OffsetsBag((Document)baseDocument);
        offsetsBag.clear();
        final CsmFile csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)false);
        long l = System.currentTimeMillis();
        if (csmFile != null && csmFile.isParsed()) {
            ReferenceCollector referenceCollector;
            SemanticEntity semanticEntity;
            if (SHOW_TIMES) {
                System.err.println("#@# Semantic Highlighting update() have started for file " + csmFile.getAbsolutePath());
            }
            ArrayList<SemanticEntity> arrayList = new ArrayList<SemanticEntity>(SemanticEntitiesProvider.instance().get());
            final ArrayList<ReferenceCollector> arrayList2 = new ArrayList<ReferenceCollector>(arrayList.size());
            OffsetsBag offsetsBag2 = arrayList.iterator();
            while (offsetsBag2.hasNext()) {
                semanticEntity = (SemanticEntity)offsetsBag2.next();
                if (NamedEntityOptions.instance().isEnabled((NamedEntity)semanticEntity)) {
                    referenceCollector = semanticEntity.getCollector();
                    if (referenceCollector != null) {
                        arrayList2.add(referenceCollector);
                        continue;
                    }
                    this.addHighlights(offsetsBag, semanticEntity.getBlocks(csmFile), semanticEntity);
                    offsetsBag2.remove();
                    continue;
                }
                offsetsBag2.remove();
            }
            offsetsBag2 = SemanticHighlighter.getHighlightsBag((Document)baseDocument);
            if (offsetsBag2 != null) {
                semanticEntity = new OffsetsBag((Document)baseDocument);
                semanticEntity.addAllHighlights(offsetsBag.getHighlights(0, Integer.MAX_VALUE));
                referenceCollector = offsetsBag.getHighlights(0, Integer.MAX_VALUE);
                HashSet<AttributeSet> hashSet = new HashSet<AttributeSet>();
                while (referenceCollector.moveNext()) {
                    hashSet.add(referenceCollector.getAttributes());
                    semanticEntity.addAllHighlights((HighlightsSequence)referenceCollector);
                }
                referenceCollector = offsetsBag2.getHighlights(0, Integer.MAX_VALUE);
                while (referenceCollector.moveNext()) {
                    if (hashSet.contains(referenceCollector.getAttributes())) continue;
                    semanticEntity.addHighlight(referenceCollector.getStartOffset(), referenceCollector.getEndOffset(), referenceCollector.getAttributes());
                }
                SemanticHighlighter.getHighlightsBag((Document)baseDocument).setHighlights((OffsetsBag)semanticEntity);
            } else {
                SemanticHighlighter.getHighlightsBag((Document)baseDocument).setHighlights(offsetsBag);
            }
            if (!arrayList.isEmpty() && !SemanticHighlighter.isVeryBigDocument((Document)baseDocument)) {
                CsmFileReferences.getDefault().accept((CsmScope)csmFile, new CsmFileReferences.Visitor(){

                    public void visit(CsmReferenceContext csmReferenceContext) {
                        CsmReference csmReference = csmReferenceContext.getReference();
                        for (ReferenceCollector referenceCollector : arrayList2) {
                            if (interrupter.cancelled()) break;
                            referenceCollector.visit(csmReference, csmFile);
                        }
                    }
                });
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.addHighlights(offsetsBag, ((ReferenceCollector)arrayList2.get(i)).getReferences(), (SemanticEntity)arrayList.get(i));
                }
            }
            if (SHOW_TIMES) {
                System.err.println("#@# Semantic Highlighting update() done in " + (System.currentTimeMillis() - l) + "ms for file " + csmFile.getAbsolutePath());
            }
        }
        if (!interrupter.cancelled()) {
            SemanticHighlighter.getHighlightsBag((Document)baseDocument).setHighlights(offsetsBag);
        }
    }

    private void addHighlights(OffsetsBag offsetsBag, List<? extends CsmOffsetable> list, SemanticEntity semanticEntity) {
        for (CsmOffsetable csmOffsetable : list) {
            offsetsBag.addHighlight(csmOffsetable.getStartOffset(), csmOffsetable.getEndOffset(), semanticEntity.getAttributes(csmOffsetable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
        BaseDocument baseDocument;
        if (phase == CsmFileTaskFactory.PhaseRunner.Phase.PARSED || phase == CsmFileTaskFactory.PhaseRunner.Phase.INIT) {
            InterrupterImpl interrupterImpl = new InterrupterImpl();
            try {
                this.addCancelListener(interrupterImpl);
                this.update(interrupterImpl);
            }
            catch (AssertionError assertionError) {
                ((Throwable)((Object)assertionError)).printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.removeCancelListener(interrupterImpl);
            }
        } else if (phase == CsmFileTaskFactory.PhaseRunner.Phase.CLEANUP && (baseDocument = this.getDocument()) != null) {
            SemanticHighlighter.getHighlightsBag((Document)baseDocument).clear();
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean isHighPriority() {
        return false;
    }

    static {
        String string = System.getProperty("cnd.semantic.line.limit");
        int n = 4000;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MAX_LINE_NUMBER = n;
    }
}

