/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsps.parserapi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.FunctionInfo;

public abstract class ELNode {
    public abstract void accept(Visitor var1) throws JspException;

    public static class Visitor {
        public void visit(Root root) throws JspException {
            root.getExpression().visit(this);
        }

        public void visit(Function function) throws JspException {
        }

        public void visit(Text text) throws JspException {
        }

        public void visit(ELText eLText) throws JspException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Nodes {
        String mapName = null;
        private final List<ELNode> list = new ArrayList<ELNode>();

        public void add(ELNode eLNode) {
            this.list.add(eLNode);
        }

        public void visit(Visitor visitor) throws JspException {
            for (ELNode eLNode : this.list) {
                eLNode.accept(visitor);
            }
        }

        public Iterator<ELNode> iterator() {
            return this.list.iterator();
        }

        public boolean isEmpty() {
            return this.list.size() == 0;
        }

        public boolean containsEL() {
            for (ELNode eLNode : this.list) {
                if (!(eLNode instanceof Root)) continue;
                return true;
            }
            return false;
        }

        public void setMapName(String string) {
            this.mapName = string;
        }

        public String getMapName() {
            return this.mapName;
        }
    }

    public static class Function
    extends ELNode {
        private final String prefix;
        private final String name;
        private String uri;
        private FunctionInfo functionInfo;
        private String methodName;
        private String[] parameters;

        Function(String string, String string2) {
            this.prefix = string;
            this.name = string2;
        }

        public void accept(Visitor visitor) throws JspException {
            visitor.visit(this);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getName() {
            return this.name;
        }

        public void setUri(String string) {
            this.uri = string;
        }

        public String getUri() {
            return this.uri;
        }

        public void setFunctionInfo(FunctionInfo functionInfo) {
            this.functionInfo = functionInfo;
        }

        public FunctionInfo getFunctionInfo() {
            return this.functionInfo;
        }

        public void setMethodName(String string) {
            this.methodName = string;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setParameters(String[] stringArray) {
            this.parameters = stringArray;
        }

        public String[] getParameters() {
            return this.parameters;
        }
    }

    public static class ELText
    extends ELNode {
        private final String text;

        public ELText(String string) {
            this.text = string;
        }

        public void accept(Visitor visitor) throws JspException {
            visitor.visit(this);
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Text
    extends ELNode {
        private final String text;

        public Text(String string) {
            this.text = string;
        }

        public void accept(Visitor visitor) throws JspException {
            visitor.visit(this);
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Root
    extends ELNode {
        private Nodes expr;

        public Root(Nodes nodes) {
            this.expr = nodes;
        }

        public void accept(Visitor visitor) throws JspException {
            visitor.visit(this);
        }

        public Nodes getExpression() {
            return this.expr;
        }
    }
}

