/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.ui.schema;

import javax.swing.Icon;
import javax.xml.namespace.QName;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.schema.SchemaIcons;
import org.netbeans.modules.soa.ui.tree.TreeItem;
import org.netbeans.modules.soa.ui.tree.TreeItemInfoProvider;
import org.netbeans.modules.xml.schema.model.AnyAttribute;
import org.netbeans.modules.xml.schema.model.AnyElement;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.Include;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class SchemaTreeInfoProvider
implements TreeItemInfoProvider {
    private static SchemaTreeInfoProvider singleton = new SchemaTreeInfoProvider();

    public static SchemaTreeInfoProvider getInstance() {
        return singleton;
    }

    public static GlobalType getGlobalType(SchemaComponent schemaComponent) {
        NamedComponentReference namedComponentReference;
        if (schemaComponent == null) {
            return null;
        }
        GlobalType globalType = null;
        if (schemaComponent instanceof GlobalType) {
            globalType = (GlobalType)schemaComponent;
        } else if (schemaComponent instanceof TypeContainer) {
            TypeContainer typeContainer = (TypeContainer)schemaComponent;
            NamedComponentReference namedComponentReference2 = typeContainer.getType();
            if (namedComponentReference2 != null) {
                globalType = (GlobalType)namedComponentReference2.get();
            }
        } else if (schemaComponent instanceof LocalAttribute) {
            NamedComponentReference namedComponentReference3 = ((LocalAttribute)schemaComponent).getType();
            if (namedComponentReference3 != null) {
                globalType = (GlobalType)namedComponentReference3.get();
            }
        } else if (schemaComponent instanceof GlobalAttribute && (namedComponentReference = ((GlobalAttribute)schemaComponent).getType()) != null) {
            globalType = (GlobalType)namedComponentReference.get();
        }
        return globalType;
    }

    public String getDisplayName(TreeItem treeItem) {
        Object DataObject2 = treeItem.getDataObject();
        if (DataObject2 instanceof Schema) {
            Schema schema = (Schema)DataObject2;
            Object DataObject3 = treeItem.getParent().getDataObject();
            if (DataObject3 instanceof WSDLModel) {
                return schema.getModel().getEffectiveNamespace((SchemaComponent)schema);
            }
            return SchemaTreeInfoProvider.getDisplayName(schema.getModel());
        }
        return this.getDisplayByDataObj(DataObject2);
    }

    public String getDisplayByDataObj(Object object) {
        SchemaModel schemaModel;
        if (object instanceof Import) {
            try {
                schemaModel = ((Import)object).resolveReferencedModel();
                if (schemaModel != null) {
                    return SchemaTreeInfoProvider.getDisplayName(schemaModel);
                }
            }
            catch (CatalogModelException catalogModelException) {
                // empty catch block
            }
        }
        if (object instanceof Include) {
            try {
                schemaModel = ((Include)object).resolveReferencedModel();
                if (schemaModel != null) {
                    return SchemaTreeInfoProvider.getDisplayName(schemaModel);
                }
            }
            catch (CatalogModelException catalogModelException) {
                // empty catch block
            }
        }
        if (object instanceof ElementReference) {
            schemaModel = ((ElementReference)object).getRef();
            QName qName = schemaModel.getQName();
            return qName.getLocalPart();
        }
        if (object instanceof Named) {
            return ((Named)object).getName();
        }
        if (object instanceof AnyElement) {
            return ToolTipTitles.ANY_ELEMENT.getName();
        }
        if (object instanceof AnyAttribute) {
            return ToolTipTitles.ANY_ATTRIBUTE.getName();
        }
        return null;
    }

    public Icon getIcon(TreeItem treeItem) {
        Object DataObject2 = treeItem.getDataObject();
        return this.getIconByDataObj(DataObject2);
    }

    public Icon getIconByDataObj(Object object) {
        if (object instanceof SchemaComponent) {
            if (object instanceof Element) {
                LocalElement localElement;
                Element element = (Element)object;
                boolean bl = false;
                boolean bl2 = false;
                String string = null;
                if (element instanceof GlobalElement) {
                    return SchemaIcons.ELEMENT.getIcon();
                }
                if (element instanceof LocalElement) {
                    localElement = (LocalElement)element;
                    bl = localElement.getMinOccursEffective() < 1;
                    string = localElement.getMaxOccursEffective();
                } else if (element instanceof ElementReference) {
                    localElement = (ElementReference)element;
                    bl = localElement.getMinOccursEffective() < 1;
                    string = localElement.getMaxOccursEffective();
                }
                if (string != null) {
                    try {
                        int n = Integer.parseInt(string);
                        bl2 = n > 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl2 = true;
                    }
                }
                if (bl) {
                    if (bl2) {
                        return SchemaIcons.ELEMENT_OPTIONAL_REPEATING.getIcon();
                    }
                    return SchemaIcons.ELEMENT_OPTIONAL.getIcon();
                }
                if (bl2) {
                    return SchemaIcons.ELEMENT_REPEATING.getIcon();
                }
                return SchemaIcons.ELEMENT.getIcon();
            }
            if (object instanceof Attribute) {
                Attribute attribute = (Attribute)object;
                if (attribute instanceof LocalAttribute) {
                    Attribute.Use use = ((LocalAttribute)attribute).getUseEffective();
                    if (use == Attribute.Use.OPTIONAL) {
                        return SchemaIcons.ATTRIBUTE_OPTIONAL.getIcon();
                    }
                    return SchemaIcons.ATTRIBUTE.getIcon();
                }
                return SchemaIcons.ATTRIBUTE.getIcon();
            }
            if (object instanceof GlobalComplexType) {
                return SchemaIcons.COMPLEX_TYPE.getIcon();
            }
            if (object instanceof GlobalSimpleType) {
                return SchemaIcons.SIMPLE_TYPE.getIcon();
            }
            if (object instanceof AnyElement) {
                AnyElement anyElement = (AnyElement)object;
                boolean bl = anyElement.getMinOccursEffective() < 1;
                String string = anyElement.getMaxOccursEffective();
                boolean bl3 = false;
                if (string != null) {
                    try {
                        int n = Integer.parseInt(string);
                        bl3 = n > 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl3 = true;
                    }
                }
                if (bl) {
                    if (bl3) {
                        return SchemaIcons.ELEMENT_OPTIONAL_REPEATING.getIcon();
                    }
                    return SchemaIcons.ELEMENT_OPTIONAL.getIcon();
                }
                if (bl3) {
                    return SchemaIcons.ELEMENT_REPEATING.getIcon();
                }
                return SchemaIcons.ELEMENT.getIcon();
            }
            if (object instanceof AnyAttribute) {
                return SchemaIcons.ATTRIBUTE.getIcon();
            }
            if (object instanceof Import) {
                return SchemaIcons.SCHEMA_FILE.getIcon();
            }
            if (object instanceof Include) {
                return SchemaIcons.SCHEMA_FILE.getIcon();
            }
        }
        if (object instanceof SchemaModel || object instanceof Schema) {
            return SchemaIcons.SCHEMA_FILE.getIcon();
        }
        if (object instanceof WSDLModel || object instanceof Definitions) {
            return SchemaIcons.WSDL_FILE.getIcon();
        }
        return null;
    }

    public String getToolTipText(TreeItem treeItem) {
        Object DataObject2 = treeItem.getDataObject();
        if (DataObject2 instanceof Schema) {
            Schema schema = (Schema)DataObject2;
            Object DataObject3 = treeItem.getParent().getDataObject();
            if (DataObject3 instanceof WSDLModel) {
                String string = schema.getModel().getEffectiveNamespace((SchemaComponent)schema);
                return SchemaTreeInfoProvider.getColorTooltip(ToolTipTitles.EMBEDED_SCHEMA.getName(), null, null, string);
            }
            return SchemaTreeInfoProvider.getDisplayName(schema.getModel());
        }
        String string = this.getDisplayName(treeItem);
        return this.getToolTipTextByDataObj(DataObject2, string);
    }

    public String getToolTipTextByDataObj(Object object, String string) {
        if (object instanceof SchemaComponent) {
            Object object2;
            String string2 = ((SchemaComponent)object).getModel().getEffectiveNamespace((SchemaComponent)object);
            if (object instanceof GlobalElement && ((GlobalElement)object).getType() != null) {
                return SchemaTreeInfoProvider.getColorTooltip(ToolTipTitles.GLOBAL_ELEMENT.getName(), string, ((GlobalElement)object).getType().getRefString(), string2);
            }
            if (object instanceof LocalElement && ((LocalElement)object).getType() != null) {
                return SchemaTreeInfoProvider.getColorTooltip(ToolTipTitles.LOCAL_ELEMENT.getName(), string, ((LocalElement)object).getType().getRefString(), string2);
            }
            if (object instanceof LocalAttribute && ((LocalAttribute)object).getType() != null) {
                return SchemaTreeInfoProvider.getColorTooltip(ToolTipTitles.LOCAL_ATTRIBUTE.getName(), string, ((LocalAttribute)object).getType().getRefString(), string2);
            }
            if (object instanceof GlobalAttribute && ((GlobalAttribute)object).getType() != null) {
                return SchemaTreeInfoProvider.getColorTooltip(ToolTipTitles.GLOBAL_ATTRIBUTE.getName(), string, ((GlobalAttribute)object).getType().getRefString(), string2);
            }
            if (object instanceof GlobalType) {
                return SchemaTreeInfoProvider.getColorTooltip(ToolTipTitles.GLOBAL_TYPE.getName(), string, ((GlobalType)object).getName(), string2);
            }
            if (object instanceof AnyElement || object instanceof AnyAttribute) {
                return SchemaTreeInfoProvider.getColorTooltip(string, null, null, null);
            }
            if (object instanceof Import) {
                try {
                    object2 = ((Import)object).resolveReferencedModel();
                    if (object2 != null) {
                        String string3 = object2.getEffectiveNamespace((SchemaComponent)object2.getSchema());
                        return SchemaTreeInfoProvider.getColorTooltip(ToolTipTitles.IMPORTED_SCHEMA.getName(), string, null, string3);
                    }
                }
                catch (CatalogModelException catalogModelException) {
                    // empty catch block
                }
            }
            if (object instanceof Include) {
                try {
                    object2 = ((Include)object).resolveReferencedModel();
                    if (object2 != null) {
                        String string4 = object2.getEffectiveNamespace((SchemaComponent)object2.getSchema());
                        return SchemaTreeInfoProvider.getColorTooltip(ToolTipTitles.INCLUDED_SCHEMA.getName(), string, null, string4);
                    }
                }
                catch (CatalogModelException catalogModelException) {
                    // empty catch block
                }
            }
            object2 = NbBundle.getMessage(SchemaTreeInfoProvider.class, (String)"NOT_NAMED_TYPE");
            return new String("<html><body>" + string + "<b><font color=#7C0000>" + " " + (String)object2 + "</font></b> <hr> Localy define type, this type does not have name" + "</body>");
        }
        return null;
    }

    public static Project safeGetProject(Model model) {
        FileObject fileObject = SoaUtil.getFileObjectByModel(model);
        if (fileObject != null && fileObject.isValid()) {
            return FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        return null;
    }

    public static String getDisplayName(SchemaModel schemaModel) {
        Project project = SchemaTreeInfoProvider.safeGetProject((Model)schemaModel);
        if (project == null) {
            return schemaModel.getEffectiveNamespace((SchemaComponent)schemaModel.getSchema());
        }
        FileObject fileObject = SoaUtil.getFileObjectByModel((Model)schemaModel);
        String string = fileObject.getExt();
        if (string.equalsIgnoreCase("xsd")) {
            FileObject fileObject2 = project.getProjectDirectory();
            return FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        }
        return schemaModel.getEffectiveNamespace((SchemaComponent)schemaModel.getSchema());
    }

    public static String getColorTooltip(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append("<p align=\"center\"><b>" + string + "</b></p>");
        }
        if (string2 != null && string3 != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("<hr>");
            }
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            if (string3 != null) {
                stringBuilder.append("<b><font color=#7C0000> " + string3 + "</font></b>");
            }
        }
        if (string4 != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("<hr>");
            }
            stringBuilder.append("Namespace: " + string4);
        }
        return "<html><body>" + stringBuilder.toString() + "</body>";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToolTipTitles {
        ANY_ELEMENT,
        ANY_ATTRIBUTE,
        EMBEDED_SCHEMA,
        IMPORTED_SCHEMA,
        INCLUDED_SCHEMA,
        PRIMITIVE_TYPES,
        GLOBAL_ELEMENT,
        LOCAL_ELEMENT,
        GLOBAL_ATTRIBUTE,
        LOCAL_ATTRIBUTE,
        GLOBAL_TYPE;


        public String getName() {
            String string = NbBundle.getMessage(SchemaTreeInfoProvider.class, (String)this.toString());
            return string;
        }
    }
}

