/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.ui.tnv.scrollpane;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import org.netbeans.modules.soa.ui.tnv.api.ThumbnailPaintable;
import org.netbeans.modules.soa.ui.tnv.api.ThumbnailView;
import org.netbeans.modules.soa.ui.tnv.impl.ThumbnailViewImpl;
import org.netbeans.modules.soa.ui.tnv.scrollpane.ThumbnailScrollLayout;
import org.openide.util.NbBundle;

public class ThumbnailScrollPane
extends JScrollPane {
    private JToggleButton btnShowTNV;
    private ThumbnailView myTNView;
    private boolean isTnvVisible = false;
    private boolean isTnvEnabled = true;
    private TnvLocation myTnvLocation = TnvLocation.LOWER_RIGHT_CORNER;
    private int myTnvIndent = 0;
    private transient boolean ignoreMsg = false;

    public ThumbnailScrollPane() {
        this.createContent();
    }

    public ThumbnailScrollPane(JComponent jComponent) {
        super(jComponent);
        this.createContent();
    }

    private void createContent() {
        Serializable serializable;
        Object object;
        this.setLayout(new ThumbnailScrollLayout());
        this.btnShowTNV = new JToggleButton();
        this.setCorner("LOWER_TRAILING_CORNER", this.btnShowTNV);
        this.btnShowTNV.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!ThumbnailScrollPane.this.ignoreMsg) {
                    if (itemEvent.getStateChange() == 1) {
                        ThumbnailScrollPane.this.setTnvVisible(true, itemEvent.getSource());
                    }
                    if (itemEvent.getStateChange() == 2) {
                        ThumbnailScrollPane.this.setTnvVisible(false, itemEvent.getSource());
                    }
                }
            }
        });
        this.setTnvVisible(false, null);
        ClassLoader classLoader = ThumbnailScrollPane.class.getClassLoader();
        URL uRL = classLoader.getResource("org/netbeans/modules/soa/ui/tnv/scrollpane/thumbnail_view.png");
        if (uRL != null) {
            object = Toolkit.getDefaultToolkit().createImage(uRL);
            serializable = new ImageIcon((Image)object);
            this.btnShowTNV.setIcon((Icon)((Object)serializable));
        }
        object = NbBundle.getMessage(ThumbnailView.class, (String)"TOOLTIP_TNV_BUTTON");
        this.btnShowTNV.setToolTipText((String)object);
        this.btnShowTNV.setFocusable(false);
        serializable = this.getViewport().getView();
        if (!(serializable instanceof ThumbnailPaintable)) {
            this.setTnvEnabled(false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTnvVisible(boolean bl, Object object) {
        if (bl != this.isTnvVisible) {
            boolean bl2 = this.isTnvVisible && this.isTnvEnabled;
            this.isTnvVisible = bl;
            if (this.isTnvVisible && this.isTnvEnabled) {
                this.getThumbnailView().getUIComponent().setVisible(true);
            } else if (this.myTNView != null) {
                this.myTNView.getUIComponent().setVisible(false);
            }
            this.ignoreMsg = true;
            try {
                if (object == null || object != this.btnShowTNV) {
                    this.btnShowTNV.setSelected(this.isTnvVisible && this.isTnvEnabled);
                }
            }
            finally {
                this.ignoreMsg = false;
            }
            if (bl2 != (this.isTnvVisible && this.isTnvEnabled)) {
                this.revalidate();
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTnvEnabled(boolean bl, Object object) {
        if (this.isTnvEnabled != bl) {
            boolean bl2 = this.isTnvVisible && this.isTnvEnabled;
            this.isTnvEnabled = bl;
            this.btnShowTNV.setEnabled(this.isTnvEnabled);
            this.ignoreMsg = true;
            try {
                this.btnShowTNV.setSelected(this.isTnvVisible && this.isTnvEnabled);
            }
            finally {
                this.ignoreMsg = false;
            }
            if (this.myTNView != null) {
                this.myTNView.getUIComponent().setVisible(this.isTnvVisible && this.isTnvEnabled);
            }
            if (bl2 != (this.isTnvVisible && this.isTnvEnabled)) {
                this.revalidate();
                this.repaint();
            }
        }
    }

    public boolean isTnvEnabled() {
        return this.isTnvEnabled;
    }

    public boolean isTnvVisible() {
        return this.isTnvVisible;
    }

    protected ThumbnailView createDefaultThumbnailView() {
        ThumbnailViewImpl thumbnailViewImpl = new ThumbnailViewImpl();
        thumbnailViewImpl.getUIComponent().setPreferredSize(new Dimension(100, 100));
        return thumbnailViewImpl;
    }

    public synchronized void setThumbnailView(ThumbnailView thumbnailView) {
        JComponent jComponent;
        if (this.myTNView != null) {
            this.myTNView.setScrollPane(null);
            jComponent = this.myTNView.getUIComponent();
            this.remove(jComponent);
        }
        this.myTNView = thumbnailView;
        if (this.myTNView != null) {
            this.myTNView.setScrollPane(this);
            jComponent = this.myTNView.getUIComponent();
            this.add((Component)jComponent, 0);
        }
        this.revalidate();
        this.repaint();
    }

    public synchronized ThumbnailView getThumbnailView() {
        if (this.myTNView == null) {
            ThumbnailView thumbnailView = this.createDefaultThumbnailView();
            this.setThumbnailView(thumbnailView);
        }
        return this.myTNView;
    }

    public boolean isOptimizedDrawingEnabled() {
        if (this.isTnvVisible()) {
            return false;
        }
        return super.isOptimizedDrawingEnabled();
    }

    public void setTnvLocation(TnvLocation tnvLocation) {
        if (this.myTnvLocation != tnvLocation) {
            this.myTnvLocation = tnvLocation;
            this.revalidate();
            this.repaint();
        }
    }

    public TnvLocation getTnvLocation() {
        return this.myTnvLocation;
    }

    public void setTnvIndent(int n) {
        if (this.myTnvIndent != n) {
            this.myTnvIndent = n;
            this.revalidate();
            this.repaint();
        }
    }

    public int getTnvIndent() {
        return this.myTnvIndent;
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        if (this.getTnvLocation() == null) {
            if (ComponentOrientation.RIGHT_TO_LEFT.equals(componentOrientation)) {
                this.setTnvLocation(TnvLocation.LOWER_LEFT_CORNER);
            } else {
                this.setTnvLocation(TnvLocation.LOWER_RIGHT_CORNER);
            }
        }
        super.setComponentOrientation(componentOrientation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TnvLocation {
        LOWER_LEFT_CORNER,
        LOWER_RIGHT_CORNER,
        UPPER_LEFT_CORNER,
        UPPER_RIGHT_CORNER;

    }
}

