/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager;

import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.manager.WebServiceManager;
import org.netbeans.modules.websvc.manager.api.WebServiceDescriptor;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.model.WebServiceGroup;
import org.netbeans.modules.websvc.manager.model.WebServiceListModel;
import org.netbeans.modules.websvc.manager.util.ManagerUtil;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;

public class WebServicePersistenceManager
implements ExceptionListener {
    private File websvcDir = new File(WebServiceManager.WEBSVC_HOME);
    private File websvcRefFile = new File(this.websvcDir, "websvc_ref.xml");
    private List<WebServiceDescriptor> descriptorsToWrite = null;
    private boolean imported = true;

    public void setImported(boolean bl) {
        this.imported = bl;
    }

    public void load() {
        if (this.websvcRefFile.exists()) {
            try {
                Object object;
                HashMap<String, WebServiceGroup> hashMap;
                int n;
                int n2;
                SaasServicesModel saasServicesModel = SaasServicesModel.getInstance();
                XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(this.websvcRefFile)));
                ArrayList arrayList = new ArrayList();
                List<String> list = WebServiceListModel.getInstance().getPartnerServices();
                Object object2 = xMLDecoder.readObject();
                if (object2 instanceof List) {
                    List list2 = (List)object2;
                    for (String string : list2) {
                        list.add(string);
                    }
                    n2 = (Integer)xMLDecoder.readObject();
                } else {
                    n2 = (Integer)object2;
                }
                for (n = 0; n < n2; ++n) {
                    hashMap = null;
                    try {
                        hashMap = (WebServiceData)xMLDecoder.readObject();
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                        xMLDecoder.close();
                    }
                    arrayList.add(hashMap);
                }
                n = (Integer)xMLDecoder.readObject();
                hashMap = new HashMap<String, WebServiceGroup>();
                for (int i = 0; i < n; ++i) {
                    try {
                        WebServiceGroup exception = (WebServiceGroup)xMLDecoder.readObject();
                        hashMap.put(exception.getId(), exception);
                        if (exception.getName() == null) continue;
                        object = this.translateGroupName(exception);
                        if (this.imported || saasServicesModel.getRootGroup().getChildGroup(exception.getName()) != null || saasServicesModel.getRootGroup().getChildGroup((String)object) != null || "default".equals(exception.getName())) continue;
                        saasServicesModel.createTopGroup(exception.getName());
                        continue;
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                        xMLDecoder.close();
                    }
                }
                xMLDecoder.close();
                for (WebServiceData webServiceData : arrayList) {
                    if (this.imported) {
                        try {
                            object = WebServiceManager.getInstance().getWsdlModel(webServiceData);
                            webServiceData.setWsdlService(object.getServiceByName(webServiceData.getName()));
                        }
                        catch (IOException iOException) {
                            Logger.global.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                        }
                        if (webServiceData.getJaxRpcDescriptorPath() != null) {
                            webServiceData.setJaxRpcDescriptor(this.loadDescriptorFile(this.websvcDir + File.separator + webServiceData.getJaxRpcDescriptorPath()));
                        }
                        if (webServiceData.getJaxWsDescriptorPath() != null) {
                            webServiceData.setJaxWsDescriptor(this.loadDescriptorFile(this.websvcDir + File.separator + webServiceData.getJaxWsDescriptorPath()));
                        }
                    } else {
                        String string;
                        webServiceData.reset();
                        object = (WebServiceGroup)hashMap.get(webServiceData.getGroupId());
                        SaasGroup saasGroup = null;
                        saasGroup = ((WebServiceGroup)object).getName() == null ? saasServicesModel.getRootGroup() : saasServicesModel.getRootGroup().getChildGroup(this.translateGroupName((WebServiceGroup)object));
                        if (saasGroup == null) {
                            saasGroup = saasServicesModel.getRootGroup();
                        }
                        if (SaasUtil.getServiceByUrl((SaasGroup)saasGroup, (String)(string = webServiceData.getOriginalWsdlUrl())) != null) continue;
                        String string2 = WsdlUtil.getServiceDirName((String)string);
                        WsdlSaas wsdlSaas = new WsdlSaas(saasGroup, string2, string, webServiceData.getPackageName());
                        saasGroup.addService((Saas)wsdlSaas);
                        wsdlSaas.save();
                    }
                    WebServiceListModel.getInstance().addWebService(webServiceData);
                }
                try {
                    WebServiceGroup webServiceGroup = (WebServiceGroup)hashMap.get("default");
                    if (webServiceGroup != null) {
                        WebServiceListModel.getInstance().addWebServiceGroup(webServiceGroup);
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        WebServicePersistenceManager.loadPartnerServices();
    }

    private String translateGroupName(WebServiceGroup webServiceGroup) {
        String string = webServiceGroup.getName();
        if (string.endsWith(" Services")) {
            return string.substring(0, string.length() - 9);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        WebServiceListModel webServiceListModel = WebServiceListModel.getInstance();
        if (!webServiceListModel.isInitialized()) {
            return;
        }
        if (!this.websvcDir.exists()) {
            this.websvcDir.mkdirs();
        }
        if (this.websvcRefFile.exists()) {
            this.websvcRefFile.delete();
        }
        XMLEncoder xMLEncoder = null;
        try {
            xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(this.websvcRefFile)));
            xMLEncoder.setExceptionListener(this);
            DefaultPersistenceDelegate defaultPersistenceDelegate = new WebServiceDataPersistenceDelegate();
            xMLEncoder.setPersistenceDelegate(WSService.class, defaultPersistenceDelegate);
            xMLEncoder.setPersistenceDelegate(WebServiceDescriptor.class, defaultPersistenceDelegate);
            xMLEncoder.writeObject(webServiceListModel.getPartnerServices());
            List<WebServiceData> list = webServiceListModel.getWebServiceSet();
            xMLEncoder.writeObject(new Integer(list.size()));
            List<Object> list2 = list;
            synchronized (list2) {
                for (WebServiceData object : list) {
                    xMLEncoder.writeObject(object);
                }
            }
            list2 = webServiceListModel.getWebServiceGroupSet();
            xMLEncoder.writeObject(new Integer(list2.size()));
            Iterator<WebServiceDescriptor> iterator = list2;
            synchronized (iterator) {
                for (WebServiceGroup webServiceGroup : list2) {
                    xMLEncoder.writeObject(webServiceGroup);
                }
            }
            xMLEncoder.flush();
            defaultPersistenceDelegate = new DefaultPersistenceDelegate();
            xMLEncoder.setPersistenceDelegate(WSService.class, defaultPersistenceDelegate);
            xMLEncoder.setPersistenceDelegate(WebServiceDescriptor.class, defaultPersistenceDelegate);
            if (this.descriptorsToWrite != null) {
                for (WebServiceDescriptor webServiceDescriptor : this.descriptorsToWrite) {
                    this.saveWebServiceDescriptor(webServiceDescriptor);
                }
                this.descriptorsToWrite.clear();
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        finally {
            if (xMLEncoder != null) {
                xMLEncoder.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebServiceDescriptor loadDescriptorFile(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        XMLDecoder xMLDecoder = null;
        try {
            xMLDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(string)));
            WebServiceDescriptor webServiceDescriptor = (WebServiceDescriptor)((Object)xMLDecoder.readObject());
            return webServiceDescriptor;
        }
        catch (Exception exception) {
            this.exceptionThrown(exception);
            WebServiceDescriptor webServiceDescriptor = null;
            return webServiceDescriptor;
        }
        finally {
            if (xMLDecoder != null) {
                xMLDecoder.close();
            }
        }
    }

    public static void loadPartnerService(String string, String string2) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(string);
        WebServicePersistenceManager.loadPartnerFromFolder(fileObject, string2, true);
    }

    public static void loadPartnerServices() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("RestComponents");
        if (fileObject != null && fileObject.isFolder()) {
            Enumeration enumeration = fileObject.getFolders(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                String string = ManagerUtil.getLocalizedName(fileObject2);
                WebServicePersistenceManager.loadPartnerFromFolder(fileObject2, string, false);
            }
        }
    }

    private static void loadPartnerFromFolder(FileObject fileObject, String string, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator<Object> iterator;
        Object object6;
        if (fileObject == null || !fileObject.isFolder()) {
            return;
        }
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        List<String> list = WebServiceListModel.getInstance().getPartnerServices();
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            try {
                object6 = DocumentBuilderFactory.newInstance();
                iterator = ((DocumentBuilderFactory)object6).newDocumentBuilder();
                Document document = ((DocumentBuilder)((Object)iterator)).parse(fileObjectArray[i].getInputStream());
                object4 = document.getElementsByTagName("method");
                for (int j = 0; j < object4.getLength(); ++j) {
                    boolean bl2;
                    object3 = object4.item(j).getAttributes();
                    object2 = object3.getNamedItem("type").getNodeValue();
                    object = object3.getNamedItem("url").getNodeValue();
                    boolean bl3 = bl2 = !hashMap.containsKey(object) && (bl || !bl && !list.contains(object));
                    if (!"http://schemas.xmlsoap.org/wsdl/".equals(object2) || !bl2) continue;
                    String string2 = object3.getNamedItem("serviceName").getNodeValue();
                    hashMap.put(object, string2);
                }
                continue;
            }
            catch (Exception exception) {
                iterator = NbBundle.getMessage(WebServicePersistenceManager.class, (String)"MSG_BadContent", (Object)fileObjectArray[i].getPath());
                Throwable throwable = ErrorManager.getDefault().annotate((Throwable)exception, iterator);
                ErrorManager.getDefault().notify(throwable);
            }
        }
        if (hashMap.size() > 0) {
            WebServiceGroup object7 = null;
            object6 = WebServiceListModel.getInstance().getWebServiceGroupSet();
            iterator = object6.iterator();
            while (iterator.hasNext()) {
                WebServiceGroup webServiceGroup = (WebServiceGroup)iterator.next();
                if (webServiceGroup.isUserDefined() || !webServiceGroup.getName().equals(string)) continue;
                object7 = webServiceGroup;
                break;
            }
            if (object7 == null) {
                object7 = new WebServiceGroup(WebServiceListModel.getInstance().getUniqueWebServiceGroupId());
                object7.setName(string);
                object7.setUserDefined(false);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                Object object5;
                object4 = (String)entry.getKey();
                if (!bl || !list.contains(object4)) {
                    list.add((String)object4);
                    object5 = new WebServiceData((String)object4, object7.getId());
                    WebServiceListModel.getInstance().addWebService((WebServiceData)object5);
                    object7.add(((WebServiceData)object5).getId(), true);
                    continue;
                }
                object5 = null;
                object3 = WebServiceListModel.getInstance().getWebServiceSet();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (WebServiceData)object2.next();
                    if (!((WebServiceData)object).getOriginalWsdlUrl().equals(object4)) continue;
                    object5 = object;
                    break;
                }
                if (object5 != null) {
                    WebServiceManager.getInstance().resetWebService((WebServiceData)object5);
                    ((WebServiceData)object5).setName((String)entry.getValue());
                    continue;
                }
                object2 = new WebServiceData((String)object4, object7.getId());
                WebServiceListModel.getInstance().addWebService((WebServiceData)object2);
                object7.add(((WebServiceData)object2).getId(), true);
            }
            WebServiceListModel.getInstance().addWebServiceGroup(object7);
        }
    }

    public void saveDescriptor(WebServiceDescriptor webServiceDescriptor) throws IOException {
        XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(webServiceDescriptor.getXmlDescriptor())));
        xMLEncoder.setExceptionListener(this);
        WebServiceDataPersistenceDelegate webServiceDataPersistenceDelegate = new WebServiceDataPersistenceDelegate();
        xMLEncoder.setPersistenceDelegate(WSService.class, webServiceDataPersistenceDelegate);
        xMLEncoder.writeObject((Object)webServiceDescriptor);
        xMLEncoder.close();
        xMLEncoder.flush();
    }

    public void saveWebServiceDescriptor(WebServiceDescriptor webServiceDescriptor) {
        try {
            this.saveDescriptor(webServiceDescriptor);
        }
        catch (IOException iOException) {
            this.exceptionThrown(iOException);
        }
    }

    public void exceptionThrown(Exception exception) {
        ErrorManager.getDefault().notify((Throwable)exception);
    }

    public class WebServiceDataPersistenceDelegate
    extends DefaultPersistenceDelegate {
        public void writeObject(Object object, Encoder encoder) {
            if (object instanceof WSService) {
                return;
            }
            if (object instanceof WebServiceDescriptor) {
                return;
            }
            super.writeObject(object, encoder);
        }
    }
}

