/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.swing.outline;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.websvc.manager.swing.outline.DefaultOutlineModel;
import org.netbeans.modules.websvc.manager.swing.outline.Outline;
import org.netbeans.modules.websvc.manager.swing.outline.OutlineModel;
import org.netbeans.modules.websvc.manager.swing.outline.RenderDataProvider;
import org.netbeans.modules.websvc.manager.swing.outline.RowModel;
import org.openide.util.Utilities;

public class TestOutline
extends JFrame {
    private Outline outline;

    public TestOutline() {
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        TreeModel treeModel = TestOutline.createModel();
        OutlineModel outlineModel = DefaultOutlineModel.createOutlineModel(treeModel, new FileRowModel(), true);
        this.outline = new Outline();
        this.outline.setRenderDataProvider(new RenderData());
        this.outline.setRootVisible(true);
        this.outline.setModel(outlineModel);
        this.getContentPane().add((Component)new JScrollPane(this.outline), "Center");
        this.setBounds(20, 20, 700, 400);
    }

    public static TreeModel createModel() {
        FileTreeModel fileTreeModel = new FileTreeModel(File.listRoots()[Utilities.isWindows() ? 1 : 0]);
        return fileTreeModel;
    }

    public static void main(String[] stringArray) {
        new TestOutline().show();
    }

    private static class FileTreeModel
    implements TreeModel {
        private File root;

        public FileTreeModel(File file) {
            this.root = file;
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
        }

        public Object getChild(Object object, int n) {
            File file = (File)object;
            return file.listFiles()[n];
        }

        public int getChildCount(Object object) {
            File file = (File)object;
            if (!file.isDirectory()) {
                return 0;
            }
            return file.list().length;
        }

        public int getIndexOfChild(Object object, Object object2) {
            File file = (File)object;
            File file2 = (File)object2;
            return Arrays.asList(file.listFiles()).indexOf(file2);
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object object) {
            File file = (File)object;
            return !file.isDirectory();
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }
    }

    private class RenderData
    implements RenderDataProvider {
        private RenderData() {
        }

        public Color getBackground(Object object) {
            return null;
        }

        public String getDisplayName(Object object) {
            return ((File)object).getName();
        }

        public Color getForeground(Object object) {
            File file = (File)object;
            if (!file.isDirectory() && !file.canWrite()) {
                return UIManager.getColor("controlShadow");
            }
            return null;
        }

        public Icon getIcon(Object object) {
            return null;
        }

        public String getTooltipText(Object object) {
            File file = (File)object;
            return file.getAbsolutePath();
        }

        public boolean isHtmlDisplayName(Object object) {
            return false;
        }
    }

    private class FileRowModel
    implements RowModel {
        private FileRowModel() {
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Date.class;
                }
                case 1: {
                    return Long.class;
                }
            }
            assert (false);
            return null;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return n == 0 ? "Date" : "Size";
        }

        public Object getValueFor(Object object, int n) {
            File file = (File)object;
            switch (n) {
                case 0: {
                    return new Date(file.lastModified());
                }
                case 1: {
                    return new Long(file.length());
                }
            }
            assert (false);
            return null;
        }

        public boolean isCellEditable(Object object, int n) {
            return false;
        }

        public void setValueFor(Object object, int n, Object object2) {
        }
    }
}

