/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.trace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Action;
import javax.swing.text.Document;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelui.trace.TestProjectActionBase;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestErrorHighlightingAction
extends TestProjectActionBase {
    @Override
    protected void performAction(Collection<NativeProject> collection) {
        if (collection != null) {
            for (NativeProject nativeProject : collection) {
                try {
                    this.testProject(nativeProject);
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_TestErrorHighlighting");
    }

    public static Action getInstance() {
        return (Action)SharedClassObject.findObject(TestErrorHighlightingAction.class, (boolean)true);
    }

    private void testProject(NativeProject nativeProject) {
        String string = "Testing Error Highlighting - " + nativeProject.getProjectDisplayName();
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
        inputOutput.select();
        OutputWriter outputWriter = inputOutput.getOut();
        OutputWriter outputWriter2 = inputOutput.getErr();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string, (Cancellable)new Cancellable(){

            public boolean cancel() {
                atomicBoolean.set(true);
                return true;
            }
        });
        progressHandle.start();
        long l = System.currentTimeMillis();
        CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)nativeProject);
        BaseStatistics[] baseStatisticsArray = new BaseStatistics[]{new MessageStatistics(), new FileStatistics(csmProject)};
        if (!csmProject.isStable(null)) {
            inputOutput.getOut().printf("Waiting until the project is parsed", new Object[0]);
            csmProject.waitParse();
        }
        Collection collection = csmProject.getAllFiles();
        progressHandle.switchToDeterminate(collection.size());
        int n = 0;
        for (CsmFile csmFile : collection) {
            progressHandle.progress(((Object)csmFile.getName()).toString(), n++);
            if (atomicBoolean.get()) break;
            this.testFile(csmFile, outputWriter, outputWriter2, atomicBoolean, baseStatisticsArray);
        }
        progressHandle.finish();
        outputWriter.printf("%s\n", new Object[]{atomicBoolean.get() ? "Cancelled" : "Done"});
        outputWriter.printf("%s took %d ms\n", new Object[]{string, System.currentTimeMillis() - l});
        for (int i = 0; i < baseStatisticsArray.length; ++i) {
            baseStatisticsArray[i].print(outputWriter);
        }
        outputWriter2.flush();
        outputWriter.flush();
    }

    private void testFile(final CsmFile csmFile, OutputWriter outputWriter, final OutputWriter outputWriter2, AtomicBoolean atomicBoolean, final BaseStatistics[] baseStatisticsArray) {
        for (int i = 0; i < baseStatisticsArray.length; ++i) {
            baseStatisticsArray[i].startFile(csmFile);
        }
        RequestImpl requestImpl = new RequestImpl(csmFile, atomicBoolean);
        final LineConverter lineConverter = new LineConverter(csmFile);
        long l = System.currentTimeMillis();
        outputWriter.printf("\nChecking file %s    %s\n", new Object[]{csmFile.getName(), csmFile.getAbsolutePath()});
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        CsmErrorProvider.Response response = new CsmErrorProvider.Response(){

            public void addError(CsmErrorInfo csmErrorInfo) {
                if (csmErrorInfo.getSeverity() == CsmErrorInfo.Severity.ERROR) {
                    TestErrorHighlightingAction.this.reportError(csmFile, csmErrorInfo, outputWriter2, lineConverter);
                    for (int i = 0; i < baseStatisticsArray.length; ++i) {
                        baseStatisticsArray[i].consume(csmFile, csmErrorInfo);
                    }
                    atomicInteger.incrementAndGet();
                }
            }

            public void done() {
            }
        };
        CsmErrorProvider.getDefault().getErrors((CsmErrorProvider.Request)requestImpl, response);
        outputWriter.printf("Error count %d for file %s. The check took %d ms\n", new Object[]{atomicInteger.get(), csmFile.getName(), System.currentTimeMillis() - l});
    }

    private static OutputListener getOutputListener(CsmFile csmFile, CsmErrorInfo csmErrorInfo) {
        final OffsetableImpl offsetableImpl = new OffsetableImpl(csmFile, csmErrorInfo);
        return new OutputAdapter(){

            public void outputLineAction(OutputEvent outputEvent) {
                CsmUtilities.openSource((CsmObject)offsetableImpl);
            }
        };
    }

    private void reportError(CsmFile csmFile, CsmErrorInfo csmErrorInfo, OutputWriter outputWriter, LineConverter lineConverter) {
        LineColumn lineColumn = lineConverter.getLineColumn(csmErrorInfo.getStartOffset());
        String string = String.format("%s: %s %d:%d in %s", csmErrorInfo.getSeverity(), csmErrorInfo.getMessage(), lineColumn.line, lineColumn.column, csmFile.getName());
        try {
            outputWriter.println(string, TestErrorHighlightingAction.getOutputListener(csmFile, csmErrorInfo));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static int getLineCount(CsmFile csmFile) {
        CharSequence charSequence = csmFile.getText();
        String string = System.getProperty("line.separator");
        char c = string.length() > 1 ? string.charAt(1) : string.charAt(0);
        int n = 1;
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    private static class FileStatistics
    extends BaseStatistics {
        private CsmProject project;
        private int totalLineCount = 0;

        public FileStatistics(CsmProject csmProject) {
            this.project = csmProject;
        }

        protected String getTitle() {
            return "Statistics by file\n  Errors    %    Lines   Per 1K lines";
        }

        protected CharSequence getId(CsmFile csmFile, CsmErrorInfo csmErrorInfo) {
            return csmFile.getAbsolutePath();
        }

        protected BaseStatistics.Element createEntry(CsmFile csmFile, CsmErrorInfo csmErrorInfo) {
            return new FileElement(csmFile);
        }

        public void startFile(CsmFile csmFile) {
            this.getCreateEntry(csmFile, null);
        }

        protected void printTotal(OutputWriter outputWriter) {
            float f = (float)this.total * 1000.0f / (float)this.totalLineCount;
            outputWriter.printf("%8d      %8d %8.2f \n", new Object[]{this.total, this.totalLineCount, Float.valueOf(f)});
            outputWriter.printf("TOTAL for %s:\n%d errors    %d lines    %d files    %.2f errors per 1K lines \n\n", new Object[]{this.project.getName(), this.total, this.totalLineCount, this.data.size(), Float.valueOf(f)});
        }

        private class FileElement
        extends BaseStatistics.Element {
            private int lineCount;

            public FileElement(CsmFile csmFile) {
                super(csmFile);
                this.lineCount = TestErrorHighlightingAction.getLineCount(csmFile);
                FileStatistics.this.totalLineCount += this.lineCount;
            }

            protected OutputListener getOutputListener() {
                return new OutputAdapter(){

                    public void outputLineAction(OutputEvent outputEvent) {
                        CsmFile csmFile = FileElement.this.getFile();
                        if (csmFile != null) {
                            CsmUtilities.openSource((CsmFile)csmFile, (int)0, (int)0);
                        }
                    }
                };
            }

            protected String formatMessage(CharSequence charSequence) {
                int n = this.cnt * 100 / FileStatistics.this.total;
                float f = (float)this.cnt * 1000.0f / (float)this.lineCount;
                String string = String.format("%8d  %2d%% %8d %8.2f  %s", this.cnt, n, this.lineCount, Float.valueOf(f), charSequence);
                return string;
            }
        }
    }

    private static class MessageStatistics
    extends BaseStatistics {
        private MessageStatistics() {
        }

        protected String getTitle() {
            return "Statistics by message";
        }

        protected CharSequence getId(CsmFile csmFile, CsmErrorInfo csmErrorInfo) {
            return csmErrorInfo.getMessage();
        }

        protected BaseStatistics.Element createEntry(CsmFile csmFile, CsmErrorInfo csmErrorInfo) {
            return new MessageElement(csmFile, csmErrorInfo);
        }

        private class MessageElement
        extends BaseStatistics.Element {
            private CsmErrorInfo info;

            public MessageElement(CsmFile csmFile, CsmErrorInfo csmErrorInfo) {
                super(csmFile);
                this.info = csmErrorInfo;
            }

            public OutputListener getOutputListener() {
                return TestErrorHighlightingAction.getOutputListener(this.getFile(), this.info);
            }
        }
    }

    private static abstract class BaseStatistics {
        protected Map<CharSequence, Element> data = new HashMap<CharSequence, Element>();
        protected int total = 0;

        private BaseStatistics() {
        }

        protected abstract String getTitle();

        protected abstract CharSequence getId(CsmFile var1, CsmErrorInfo var2);

        protected abstract Element createEntry(CsmFile var1, CsmErrorInfo var2);

        public void startFile(CsmFile csmFile) {
        }

        public void consume(CsmFile csmFile, CsmErrorInfo csmErrorInfo) {
            this.getCreateEntry(csmFile, csmErrorInfo).consume();
        }

        protected Element getCreateEntry(CsmFile csmFile, CsmErrorInfo csmErrorInfo) {
            CharSequence charSequence = this.getId(csmFile, csmErrorInfo);
            Element element = this.data.get(charSequence);
            if (element == null) {
                element = this.createEntry(csmFile, csmErrorInfo);
                this.data.put(charSequence, element);
            }
            return element;
        }

        public void print(OutputWriter outputWriter) {
            Map.Entry entry;
            Element element;
            outputWriter.printf("\n%s\n", new Object[]{this.getTitle()});
            ArrayList<Map.Entry<CharSequence, Element>> arrayList = new ArrayList<Map.Entry<CharSequence, Element>>(this.data.entrySet());
            Collections.sort(arrayList, new Comparator<Map.Entry<CharSequence, Element>>(){

                @Override
                public int compare(Map.Entry<CharSequence, Element> entry, Map.Entry<CharSequence, Element> entry2) {
                    return entry2.getValue().getCount() - entry.getValue().getCount();
                }
            });
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && (element = (Element)(entry = (Map.Entry)iterator.next()).getValue()).getCount() > 0) {
                element.print(outputWriter, this.total, (CharSequence)entry.getKey());
            }
            this.printTotal(outputWriter);
        }

        protected void printTotal(OutputWriter outputWriter) {
            outputWriter.printf("%8d TOTAL\n", new Object[]{this.total});
        }

        protected abstract class Element {
            protected int cnt;
            private CsmUID<CsmFile> fileUID;

            protected Element(CsmFile csmFile) {
                this.fileUID = csmFile.getUID();
            }

            protected abstract OutputListener getOutputListener();

            protected CsmFile getFile() {
                return (CsmFile)this.fileUID.getObject();
            }

            public void consume() {
                ++this.cnt;
                ++BaseStatistics.this.total;
            }

            public int getCount() {
                return this.cnt;
            }

            public void print(OutputWriter outputWriter, int n, CharSequence charSequence) {
                try {
                    outputWriter.println(this.formatMessage(charSequence), this.getOutputListener());
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }

            protected String formatMessage(CharSequence charSequence) {
                int n = this.cnt * 100 / BaseStatistics.this.total;
                String string = String.format("%8d  %2d%%  %s", this.cnt, n, charSequence);
                return string;
            }
        }
    }

    private static class LineConverter {
        private CsmFile file;
        private CharSequence text;

        public LineConverter(CsmFile csmFile) {
            this.file = csmFile;
        }

        public LineColumn getLineColumn(int n) {
            if (this.text == null) {
                this.text = this.file.getText();
            }
            int n2 = 1;
            int n3 = 1;
            char c = System.getProperty("line.separator").charAt(0);
            for (int i = 0; i < n; ++i) {
                if (this.text.charAt(i) == c) {
                    ++n2;
                    n3 = 1;
                    continue;
                }
                ++n3;
            }
            return new LineColumn(n2, n3);
        }
    }

    private static class LineColumn {
        public final int line;
        public final int column;

        public LineColumn(int n, int n2) {
            this.line = n;
            this.column = n2;
        }
    }

    private static class RequestImpl
    implements CsmErrorProvider.Request {
        private CsmFile file;
        private AtomicBoolean cancelled;

        public RequestImpl(CsmFile csmFile, AtomicBoolean atomicBoolean) {
            this.file = csmFile;
            this.cancelled = atomicBoolean;
        }

        public CsmFile getFile() {
            return this.file;
        }

        public boolean isCancelled() {
            return this.cancelled.get();
        }

        public Document getDocument() {
            return null;
        }
    }

    private static class OffsetableImpl
    implements CsmOffsetable {
        private CsmUID<CsmFile> fileUID;
        private CsmErrorInfo errorInfo;

        public OffsetableImpl(CsmFile csmFile, CsmErrorInfo csmErrorInfo) {
            this.fileUID = csmFile.getUID();
            this.errorInfo = csmErrorInfo;
        }

        public CsmFile getContainingFile() {
            return (CsmFile)this.fileUID.getObject();
        }

        public int getEndOffset() {
            return this.errorInfo.getEndOffset();
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getStartOffset() {
            return this.errorInfo.getEndOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CharSequence getText() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class OutputAdapter
    implements OutputListener {
        private OutputAdapter() {
        }

        public void outputLineAction(OutputEvent outputEvent) {
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }
    }
}

