/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.validation.core;

import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.prefs.Preferences;
import org.netbeans.modules.soa.validation.core.Annotation;
import org.netbeans.modules.soa.validation.core.Listener;
import org.netbeans.modules.soa.validation.util.LineUtil;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.ui.UI;
import org.netbeans.modules.xml.validation.ValidateAction;
import org.netbeans.modules.xml.validation.ValidationOutputWindowController;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.text.Annotatable;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Controller
implements ComponentListener {
    private Model myModel;
    private Timer myTimer;
    private List<Validator.ResultItem> myResult;
    private List<Annotation> myAnnotations;
    private Map<Listener, Object> myListeners;
    private static final long DELAY = 5432L;
    private static final String ALLOW_BACKGROUND_VALIDATION = "allow.background.validation";

    public Controller(Model model) {
        this.myModel = model;
        this.myTimer = new Timer();
        this.myResult = new LinkedList<Validator.ResultItem>();
        this.myListeners = new WeakHashMap<Listener, Object>();
        this.myAnnotations = new LinkedList<Annotation>();
    }

    public Model getModel() {
        return this.myModel;
    }

    public void attach() {
        this.myModel.addComponentListener((ComponentListener)this);
    }

    public void detach() {
        if (this.myModel != null) {
            this.myModel.removeComponentListener((ComponentListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        Map<Listener, Object> map = this.myListeners;
        synchronized (map) {
            this.myListeners.put(listener, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        Map<Listener, Object> map = this.myListeners;
        synchronized (map) {
            this.myListeners.remove(listener);
        }
    }

    public List<Validator.ResultItem> getResult() {
        return this.myResult;
    }

    public void startValidation() {
        UI.log();
        UI.log((Object)"START ...");
        this.doValidation(true, true);
    }

    public void runValidation() {
        UI.log();
        UI.log((Object)"RUN ...");
        this.doValidation(true, false);
    }

    public void triggerValidation() {
        UI.log();
        UI.log((Object)("ALLOW Background Validation: " + this.isAllowBackgroundValidation()));
        UI.log();
        if (!this.isAllowBackgroundValidation()) {
            return;
        }
        UI.log();
        UI.log((Object)"TIMER-TRIGGER");
        UI.log();
        this.cancelValidation();
        this.myTimer.schedule(new TimerTask(){

            public void run() {
                Controller.this.doValidation(false, false);
            }
        }, 5432L);
    }

    public boolean cliValidate(File file) {
        return this.validate(file, true);
    }

    public boolean ideValidate(File file) {
        return this.validate(file, false);
    }

    private boolean validate(File file, boolean bl) {
        List<Validator.ResultItem> list;
        PrintStream printStream;
        if (bl) {
            printStream = System.out;
            list = this.validate(Validation.ValidationType.PARTIAL);
        } else {
            printStream = System.err;
            list = this.validate(Validation.ValidationType.COMPLETE);
        }
        boolean bl2 = false;
        for (Validator.ResultItem resultItem : list) {
            if (resultItem.getType() == Validator.ResultType.ERROR) {
                bl2 = true;
            } else if (bl) continue;
            printStream.println(LineUtil.getValidationError(file, resultItem));
            printStream.println();
        }
        return bl2;
    }

    public List<Validator.ResultItem> validate(Validation.ValidationType validationType) {
        Validation validation = new Validation();
        validation.validate(this.myModel, validationType);
        return validation.getValidationResult();
    }

    private void doValidation(boolean bl, boolean bl2) {
        List list;
        int n;
        Validation.ValidationType validationType;
        this.cancelValidation();
        if (bl) {
            validationType = Validation.ValidationType.COMPLETE;
            n = 10;
        } else {
            validationType = Validation.ValidationType.PARTIAL;
            n = 1;
        }
        Thread.currentThread().setPriority(n);
        UI.log();
        UI.log((Object)("VALIDATION: " + validationType));
        UI.startTimeln();
        if (bl2) {
            ValidateAction.RunAction runAction = new ValidateAction.RunAction(new ValidateAction(this.myModel));
            runAction.run();
            list = runAction.getValidationResults();
        } else {
            list = bl ? new ValidationOutputWindowController().validate(this.myModel) : this.validate(validationType);
        }
        UI.endTime((Object)"validation");
        UI.log((Object)("end: " + validationType));
        this.notifyListeners(list);
    }

    private void cancelValidation() {
        this.myTimer.cancel();
        this.myTimer = new Timer();
        Validation.stop();
    }

    private boolean isAllowBackgroundValidation() {
        return this.get(ALLOW_BACKGROUND_VALIDATION, true);
    }

    private boolean get(String string, boolean bl) {
        return this.getPreferences().getBoolean(string, bl);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(SchemaModel.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(List<Validator.ResultItem> list) {
        if (list == null) {
            return;
        }
        this.myResult = list;
        UI.log((Object)"+++: Notify listeners");
        Map<Listener, Object> map = this.myListeners;
        synchronized (map) {
            for (Listener listener : this.myListeners.keySet()) {
                if (listener == null) continue;
                listener.validationUpdated(this.myResult);
            }
        }
        this.showAnnotations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAnnotations() {
        List<Annotation> list = this.myAnnotations;
        synchronized (list) {
            LinkedList<Validator.ResultItem> linkedList;
            Object object;
            for (Annotation iterator : this.myAnnotations) {
                iterator.detach();
            }
            this.myAnnotations.clear();
            HashMap hashMap = new HashMap();
            for (Validator.ResultItem resultItem : this.myResult) {
                if (resultItem.getType() != Validator.ResultType.ERROR || (object = LineUtil.getLinePart(resultItem)) == null) continue;
                linkedList = (LinkedList<Validator.ResultItem>)hashMap.get(object);
                if (linkedList == null) {
                    linkedList = new LinkedList<Validator.ResultItem>();
                    hashMap.put(object, linkedList);
                }
                linkedList.add(resultItem);
            }
            for (Validator.ResultItem resultItem : hashMap.keySet()) {
                object = new StringBuilder();
                linkedList = (List)hashMap.get(resultItem);
                for (int i = 0; i < linkedList.size(); ++i) {
                    ((StringBuilder)object).append(((Validator.ResultItem)linkedList.get(i)).getDescription());
                    if (i >= linkedList.size() - 1) continue;
                    ((StringBuilder)object).append("\n\n");
                }
                this.myAnnotations.add(new Annotation((Annotatable)resultItem, ((StringBuilder)object).toString()));
            }
        }
    }

    public void valueChanged(ComponentEvent componentEvent) {
        this.triggerValidation();
    }

    public void childrenAdded(ComponentEvent componentEvent) {
        this.triggerValidation();
    }

    public void childrenDeleted(ComponentEvent componentEvent) {
        this.triggerValidation();
    }
}

