/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.model.xml;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.asm.model.lang.BitWidth;
import org.netbeans.modules.asm.model.lang.Register;
import org.netbeans.modules.asm.model.lang.instruction.Instruction;
import org.netbeans.modules.asm.model.lang.instruction.InstructionArgs;
import org.netbeans.modules.asm.model.util.Pair;
import org.netbeans.modules.asm.model.xml.DefaultXMLBaseRegister;
import org.netbeans.modules.asm.model.xml.ModelXMLReaderException;
import org.netbeans.modules.asm.model.xml.XMLBaseInstruction;
import org.netbeans.modules.asm.model.xml.XMLBaseRegister;
import org.netbeans.modules.asm.model.xml.XMLInstructionArgs;
import org.netbeans.modules.asm.model.xml.XMLReaderContext;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelXMLRootContext
implements XMLReaderContext {
    private String asmName;
    private List<Instruction> instrs = new LinkedList<Instruction>();
    private List<Register> regs = new LinkedList<Register>();

    public List<Instruction> getInstructions() {
        return this.instrs;
    }

    public List<Register> getRegisters() {
        return this.regs;
    }

    private String checkForName(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            throw new ModelXMLReaderException("Can't find attribute: " + string);
        }
        return string2;
    }

    private Map<String, String> copyAttribute(Attributes attributes, String ... stringArray) {
        int n = attributes.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>(n);
        block0: for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            for (String string2 : stringArray) {
                if (string.equals(string2)) continue block0;
            }
            hashMap.put(string, attributes.getValue(i));
        }
        return hashMap;
    }

    public XMLReaderContext assemblerStart(Attributes attributes) {
        this.asmName = attributes.getValue("name");
        return this;
    }

    public XMLReaderContext register_groupStart(Attributes attributes) {
        return new RegisterGroupContext(attributes);
    }

    public void register_groupEnd(RegisterGroupContext registerGroupContext) {
        this.regs.addAll(registerGroupContext.makeRegisters());
    }

    public XMLReaderContext instruction_groupStart(Attributes attributes) {
        return new InstructionGroupContext(attributes);
    }

    private class InstructionGroupContext
    implements XMLReaderContext {
        public String groupName;

        public InstructionGroupContext(Attributes attributes) {
            this.groupName = ModelXMLRootContext.this.checkForName(attributes, "name");
        }

        public XMLReaderContext instructionStart(Attributes attributes) {
            return new InstructionContext(attributes);
        }

        public void instructionEnd(InstructionContext instructionContext) {
            ModelXMLRootContext.this.instrs.add(instructionContext.makeInstruction());
        }

        class InstructionContext
        implements XMLReaderContext {
            private final String name;
            private String clazz;
            private final String descr;
            private Map<String, String> attr;
            private final List<InstructionArgs> arguments;

            public InstructionContext(Attributes attributes) {
                this.name = ModelXMLRootContext.this.checkForName(attributes, "name");
                this.clazz = ModelXMLRootContext.this.checkForName(attributes, "clazz");
                this.descr = ModelXMLRootContext.this.checkForName(attributes, "description");
                this.attr = new HashMap<String, String>();
                this.arguments = new LinkedList<InstructionArgs>();
                this.attr = ModelXMLRootContext.this.copyAttribute(attributes, new String[]{"name", "clazz", "description"});
            }

            public XMLReaderContext argStart(Attributes attributes) {
                return new ArgContext(attributes);
            }

            public void argEnd(ArgContext argContext) {
                this.arguments.add(argContext.getArgument());
            }

            public Instruction makeInstruction() {
                XMLBaseInstruction xMLBaseInstruction = null;
                this.clazz = "org.netbeans.modules.asm.model.xml.DefaultXMLBaseInstruction";
                try {
                    Class<?> clazz = Class.forName(this.clazz);
                    if (!XMLBaseInstruction.class.isAssignableFrom(clazz)) {
                        throw new Exception(this.clazz + " is't super class of " + "org.netbeans.modules.asm.model.xml.DefaultXMLBaseInstruction");
                    }
                    Constructor<?> object = clazz.getConstructor(String.class, String.class, String.class, Collection.class);
                    xMLBaseInstruction = (XMLBaseInstruction)object.newInstance(this.name, this.descr, InstructionGroupContext.this.groupName, this.arguments);
                }
                catch (Exception exception) {
                    throw new ModelXMLReaderException(exception.getMessage());
                }
                for (Map.Entry entry : this.attr.entrySet()) {
                    xMLBaseInstruction.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                return xMLBaseInstruction;
            }

            private class ArgContext
            implements XMLReaderContext {
                private String descr;
                private List<String> params;

                public ArgContext(Attributes attributes) {
                    this.descr = ModelXMLRootContext.this.checkForName(attributes, "description");
                    this.params = new LinkedList<String>();
                }

                public XMLInstructionArgs getArgument() {
                    return new XMLInstructionArgs(this.params, this.descr);
                }

                public XMLReaderContext paramStart(Attributes attributes) {
                    String string = ModelXMLRootContext.this.checkForName(attributes, "val");
                    this.params.add(string);
                    return null;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegisterGroupContext
    implements XMLReaderContext {
        private String groupName;
        private List<RegisterContext> regCtxs;

        public RegisterGroupContext(Attributes attributes) {
            this.groupName = ModelXMLRootContext.this.checkForName(attributes, "name");
            this.regCtxs = new LinkedList<RegisterContext>();
        }

        public List<Register> makeRegisters() {
            ArrayList<Register> arrayList = new ArrayList<Register>(this.regCtxs.size());
            RegisterMakeHelper registerMakeHelper = new RegisterMakeHelper();
            for (RegisterContext registerContext : this.regCtxs) {
                XMLBaseRegister xMLBaseRegister = registerMakeHelper.process(registerContext);
                for (Map.Entry<String, String> entry : registerContext.getAttributes().entrySet()) {
                    xMLBaseRegister.setProperty(entry.getKey(), entry.getValue());
                }
                arrayList.add(xMLBaseRegister);
            }
            return arrayList;
        }

        public XMLReaderContext registerStart(Attributes attributes) {
            return new RegisterContext(attributes);
        }

        public void registerEnd(RegisterContext registerContext) {
            this.regCtxs.add(registerContext);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RegisterContext
        implements XMLReaderContext {
            private String name;
            private BitWidth width;
            private List<Pair<String, Integer>> children;
            private Map<String, String> attr;

            public RegisterContext(Attributes attributes) {
                this.name = ModelXMLRootContext.this.checkForName(attributes, "name");
                String string = ModelXMLRootContext.this.checkForName(attributes, "bitwidth");
                this.width = BitWidth.getBitWidth(Integer.parseInt(string));
                this.children = new LinkedList<Pair<String, Integer>>();
                this.attr = new HashMap<String, String>();
                this.attr = ModelXMLRootContext.this.copyAttribute(attributes, new String[]{"name", "bitwidth"});
            }

            public XMLReaderContext childStart(Attributes attributes) {
                String string = ModelXMLRootContext.this.checkForName(attributes, "name");
                String string2 = ModelXMLRootContext.this.checkForName(attributes, "offset");
                this.children.add(new Pair<String, Integer>(string, Integer.parseInt(string2)));
                return null;
            }

            public String getName() {
                return this.name;
            }

            public BitWidth getWidth() {
                return this.width;
            }

            public Map<String, String> getAttributes() {
                return this.attr;
            }

            public List<Pair<String, Integer>> getChildren() {
                return this.children;
            }
        }

        private class RegisterMakeHelper {
            private Set<RegisterContext> inProcesses = new HashSet<RegisterContext>();
            private XMLBaseRegister[] results;

            public RegisterMakeHelper() {
                this.results = new XMLBaseRegister[RegisterGroupContext.this.regCtxs.size()];
            }

            public XMLBaseRegister process(RegisterContext registerContext) {
                int n = RegisterGroupContext.this.regCtxs.indexOf(registerContext);
                if (this.results[n] == null) {
                    if (this.inProcesses.add(registerContext)) {
                        new ModelXMLReaderException("Cyclic dependence for register:  " + registerContext.getName());
                    }
                    DefaultXMLBaseRegister defaultXMLBaseRegister = new DefaultXMLBaseRegister(registerContext.getName(), registerContext.getWidth());
                    HashSet<Register> hashSet = new HashSet<Register>();
                    for (Pair<String, Integer> pair : registerContext.getChildren()) {
                        XMLBaseRegister xMLBaseRegister = this.process(this.getForName(pair.getFirst()));
                        hashSet.addAll(xMLBaseRegister.getChildren());
                        hashSet.add(xMLBaseRegister);
                        xMLBaseRegister.setDirectParent(defaultXMLBaseRegister);
                    }
                    defaultXMLBaseRegister.setChildren(hashSet);
                    this.results[n] = defaultXMLBaseRegister;
                }
                return this.results[n];
            }

            private RegisterContext getForName(String string) {
                for (RegisterContext registerContext : RegisterGroupContext.this.regCtxs) {
                    if (!registerContext.getName().equals(string)) continue;
                    return registerContext;
                }
                throw new ModelXMLReaderException("Undefined register:  " + string);
            }
        }
    }
}

