/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmRefactoringUtils {
    private CsmRefactoringUtils() {
    }

    public static CsmProject getContextCsmProject(CsmObject csmObject) {
        CsmFile csmFile = null;
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            csmFile = ((CsmOffsetable)csmObject).getContainingFile();
        } else if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            csmFile = (CsmFile)csmObject;
        }
        CsmProject csmProject = null;
        if (csmFile != null) {
            csmProject = csmFile.getProject();
        } else if (CsmKindUtilities.isNamespace((CsmObject)csmObject)) {
            csmProject = ((CsmNamespace)csmObject).getProject();
        }
        return csmProject;
    }

    public static Collection<CsmProject> getRelatedCsmProjects(CsmObject csmObject, boolean bl) {
        List<CsmProject> list = Collections.emptyList();
        if (!bl) {
            CsmProject csmProject = CsmRefactoringUtils.getContextCsmProject(csmObject);
            list = Collections.singleton(csmProject);
        } else {
            Collection collection = CsmModelAccessor.getModel().projects();
            list = collection;
            CsmProject csmProject = CsmRefactoringUtils.getContextCsmProject(csmObject);
            if (csmProject != null && csmProject.isArtificial()) {
                HashSet hashSet = new HashSet();
                for (CsmProject csmProject2 : collection) {
                    hashSet.addAll(csmProject2.getLibraries());
                }
                list = new ArrayList(collection);
                list.addAll(hashSet);
            }
        }
        return list;
    }

    public static Project getContextProject(CsmObject csmObject) {
        CsmProject csmProject = CsmRefactoringUtils.getContextCsmProject(csmObject);
        Project project = null;
        if (csmProject != null) {
            Object object = csmProject.getPlatformProject();
            if (object instanceof NativeProject) {
                object = ((NativeProject)object).getProject();
            }
            if (object instanceof Project) {
                project = (Project)object;
            }
        }
        return project;
    }

    public static CsmObject getReferencedElement(CsmObject csmObject) {
        if (csmObject instanceof CsmReference) {
            return CsmRefactoringUtils.getReferencedElement(((CsmReference)csmObject).getReferencedObject());
        }
        return csmObject;
    }

    public static String getSimpleText(CsmObject csmObject) {
        String string = "";
        if (csmObject != null) {
            if (CsmKindUtilities.isNamedElement((CsmObject)csmObject)) {
                string = ((Object)((CsmNamedElement)csmObject).getName()).toString();
            } else if (CsmKindUtilities.isStatement((CsmObject)csmObject)) {
                string = ((Object)((CsmStatement)csmObject).getText()).toString();
            } else if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
                string = ((Object)((CsmOffsetable)csmObject).getText()).toString();
            }
        }
        return string;
    }

    public static FileObject getFileObject(CsmObject csmObject) {
        CsmFile csmFile = null;
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            csmFile = (CsmFile)csmObject;
        } else if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            csmFile = ((CsmOffsetable)csmObject).getContainingFile();
        }
        return csmFile == null ? null : CsmUtilities.getFileObject((CsmFile)csmFile);
    }

    public static CsmReference findReference(Lookup lookup) {
        Node node;
        CsmReference csmReference = (CsmReference)lookup.lookup(CsmReference.class);
        if (csmReference == null && (node = (Node)lookup.lookup(Node.class)) != null) {
            csmReference = CsmReferenceResolver.getDefault().findReference(node);
        }
        return csmReference;
    }

    public static <T> CsmUID<T> getHandler(T t) {
        SelfUID<T> selfUID = null;
        if (CsmKindUtilities.isIdentifiable(t)) {
            selfUID = ((CsmIdentifiable)t).getUID();
            boolean bl = true;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (bl && selfUID.getObject() == null) {
                System.err.println("UID " + selfUID + "can't return object " + t);
                selfUID = null;
            }
        }
        if (selfUID == null) {
            selfUID = new SelfUID<T>(t);
        }
        return selfUID;
    }

    public static <T> T getObject(CsmUID<T> csmUID) {
        return (T)(csmUID == null ? null : csmUID.getObject());
    }

    public static boolean isSupportedReference(CsmReference csmReference) {
        return csmReference != null;
    }

    public static String getHtml(CsmObject csmObject) {
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return CsmRefactoringUtils.getHtml((CsmOffsetable)csmObject);
        }
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            return CsmDisplayUtilities.htmlize((CharSequence)((Object)((CsmFile)csmObject).getName()).toString());
        }
        return csmObject.toString();
    }

    public static CsmObject getEnclosingElement(CsmObject csmObject) {
        CsmObject csmObject2;
        assert (csmObject != null);
        if (csmObject instanceof CsmReference) {
            csmObject = ((CsmReference)csmObject).getOwner();
        }
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return CsmRefactoringUtils.findInnerFileObject((CsmOffsetable)csmObject);
        }
        CsmObject csmObject3 = csmObject2 = csmObject instanceof CsmReference ? ((CsmReference)csmObject).getOwner() : csmObject;
        while (CsmKindUtilities.isScopeElement((CsmObject)csmObject2)) {
            CsmScope csmScope = ((CsmScopeElement)csmObject2).getScope();
            if (CsmRefactoringUtils.isLangContainerFeature((CsmObject)csmScope)) {
                return csmScope;
            }
            if (CsmKindUtilities.isScopeElement((CsmObject)csmScope)) {
                csmObject2 = (CsmScopeElement)csmScope;
                continue;
            }
            if (csmScope != null) break;
            System.err.println("scope element without scope " + csmObject2);
            break;
        }
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return ((CsmOffsetable)csmObject).getContainingFile();
        }
        return null;
    }

    static boolean isLangContainerFeature(CsmObject csmObject) {
        assert (csmObject != null);
        return CsmKindUtilities.isFunction((CsmObject)csmObject) || CsmKindUtilities.isClass((CsmObject)csmObject) || CsmKindUtilities.isEnum((CsmObject)csmObject) || CsmKindUtilities.isNamespaceDefinition((CsmObject)csmObject) || CsmKindUtilities.isFile((CsmObject)csmObject);
    }

    private static String getHtml(CsmOffsetable csmOffsetable) {
        CsmFile csmFile = csmOffsetable.getContainingFile();
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
        BaseDocument baseDocument = null;
        String string = null;
        if (cloneableEditorSupport != null && cloneableEditorSupport.getDocument() instanceof BaseDocument) {
            baseDocument = (BaseDocument)cloneableEditorSupport.getDocument();
            try {
                int n = csmOffsetable.getStartOffset();
                int n2 = csmOffsetable.getEndOffset();
                int n3 = 1;
                if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetable) || CsmKindUtilities.isEnum((CsmObject)csmOffsetable)) {
                    n2 = n;
                    n3 = 0;
                } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetable)) {
                    n2 = ((CsmFunctionDefinition)csmOffsetable).getBody().getStartOffset() - 1;
                } else if (CsmKindUtilities.isClass((CsmObject)csmOffsetable)) {
                    n2 = ((CsmClass)csmOffsetable).getLeftBracketOffset() - 1;
                }
                int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                int n5 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n2) + n3;
                string = CsmDisplayUtilities.getLineHtml((int)n4, (int)n5, (int)-1, (int)-1, (BaseDocument)baseDocument);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = CsmDisplayUtilities.htmlize((CharSequence)((Object)csmOffsetable.getText()).toString());
        }
        return string;
    }

    private static boolean isInObject(CsmObject csmObject, int n) {
        if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return false;
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        return csmOffsetable.getStartOffset() <= n && n <= csmOffsetable.getEndOffset();
    }

    public static boolean isBeforeObject(CsmObject csmObject, int n) {
        if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return false;
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        return n < csmOffsetable.getStartOffset();
    }

    public static CsmObject findInnerFileObject(CsmFile csmFile, int n) {
        assert (csmFile != null) : "can't be null file in findInnerFileObject";
        CsmDeclaration csmDeclaration = CsmRefactoringUtils.findInnerDeclaration(csmFile.getDeclarations().iterator(), n);
        return csmDeclaration;
    }

    private static CsmDeclaration findInnerDeclaration(Iterator<? extends CsmDeclaration> iterator, int n) {
        CsmDeclaration csmDeclaration = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                CsmDeclaration csmDeclaration2 = iterator.next();
                assert (csmDeclaration2 != null) : "can't be null declaration";
                if (CsmRefactoringUtils.isInObject((CsmObject)csmDeclaration2, n) && CsmRefactoringUtils.isLangContainerFeature((CsmObject)csmDeclaration2)) {
                    csmDeclaration = CsmRefactoringUtils.findInnerDeclaration(csmDeclaration2, n);
                    if (csmDeclaration != null) {
                        return csmDeclaration;
                    }
                    return csmDeclaration2;
                }
                if (!CsmRefactoringUtils.isBeforeObject((CsmObject)csmDeclaration2, n)) continue;
                break;
            }
        }
        return csmDeclaration;
    }

    private static CsmDeclaration findInnerDeclaration(CsmDeclaration csmDeclaration, int n) {
        assert (CsmRefactoringUtils.isInObject((CsmObject)csmDeclaration, n)) : "must be in outDecl object!";
        Iterator iterator = null;
        if (CsmKindUtilities.isNamespace((CsmObject)csmDeclaration)) {
            CsmNamespace csmNamespace = (CsmNamespace)csmDeclaration;
            iterator = csmNamespace.getDeclarations().iterator();
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmDeclaration)) {
            iterator = ((CsmNamespaceDefinition)csmDeclaration).getDeclarations().iterator();
        } else if (CsmKindUtilities.isClass((CsmObject)csmDeclaration)) {
            CsmClass csmClass = (CsmClass)csmDeclaration;
            iterator = csmClass.getMembers().iterator();
        } else if (CsmKindUtilities.isEnum((CsmObject)csmDeclaration)) {
            CsmEnum csmEnum = (CsmEnum)csmDeclaration;
            iterator = csmEnum.getEnumerators().iterator();
        }
        return CsmRefactoringUtils.findInnerDeclaration(iterator, n);
    }

    private static CsmObject findInnerFileObject(CsmOffsetable csmOffsetable) {
        CsmObject csmObject = CsmRefactoringUtils.findInnerFileObject(csmOffsetable.getContainingFile(), csmOffsetable.getStartOffset() - 1);
        if (csmObject == null) {
            csmObject = csmOffsetable.getContainingFile();
        }
        return csmObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SelfUID<T>
    implements CsmUID<T> {
        private final T element;

        SelfUID(T t) {
            this.element = t;
        }

        public T getObject() {
            return this.element;
        }
    }
}

