/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.ui.RenameRefactoringUI;
import org.netbeans.modules.cnd.refactoring.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    public boolean canFindUsages(Lookup lookup) {
        CsmReference csmReference = CsmRefactoringUtils.findReference(lookup);
        return CsmRefactoringUtils.isSupportedReference(csmReference);
    }

    public void doFindUsages(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        Runnable runnable = RefactoringActionsProvider.isFromEditor(editorCookie) ? new TextComponentTask(editorCookie, lookup){

            protected RefactoringUI createRefactoringUI(CsmObject csmObject, int n, int n2) {
                return new WhereUsedQueryUI(csmObject);
            }
        } : new NodeToElementTask(lookup.lookupAll(Node.class)){

            protected RefactoringUI createRefactoringUI(CsmObject csmObject) {
                return new WhereUsedQueryUI(csmObject);
            }
        };
        runnable.run();
    }

    public void doRename(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        Runnable runnable = RefactoringActionsProvider.isFromEditor(editorCookie) ? new TextComponentTask(editorCookie, lookup){

            protected RefactoringUI createRefactoringUI(CsmObject csmObject, int n, int n2) {
                return new RenameRefactoringUI(csmObject);
            }
        } : new NodeToElementTask(lookup.lookupAll(Node.class)){

            protected RefactoringUI createRefactoringUI(CsmObject csmObject) {
                return new RenameRefactoringUI(csmObject);
            }
        };
        runnable.run();
    }

    private static String getActionName(Action action) {
        String string = (String)action.getValue("Name");
        string = Utilities.replaceString((String)string, (String)"&", (String)"");
        return Utilities.replaceString((String)string, (String)"...", (String)"");
    }

    public boolean canRename(Lookup lookup) {
        if (CsmModelAccessor.getModelState() != CsmModelState.ON) {
            return false;
        }
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() > 1) {
            return false;
        }
        CsmReference csmReference = CsmRefactoringUtils.findReference(lookup);
        return CsmRefactoringUtils.isSupportedReference(csmReference);
    }

    static boolean isFromEditor(EditorCookie editorCookie) {
        return editorCookie != null && editorCookie.getOpenedPanes() != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeToFileObjectTask
    implements Runnable {
        private Collection<? extends Node> nodes;
        private RefactoringUI ui;
        public NonRecursiveFolder[] pkg;
        Collection<CsmObject> handles = new ArrayList<CsmObject>();

        public NodeToFileObjectTask(Collection<? extends Node> collection) {
            this.nodes = collection;
        }

        public void cancel() {
        }

        @Override
        public void run() {
            FileObject[] fileObjectArray = new FileObject[this.nodes.size()];
            this.pkg = new NonRecursiveFolder[fileObjectArray.length];
            int n = 0;
            for (Node node : this.nodes) {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject == null) continue;
                fileObjectArray[n] = dataObject.getPrimaryFile();
                this.pkg[n++] = (NonRecursiveFolder)node.getLookup().lookup(NonRecursiveFolder.class);
            }
            UI.openRefactoringUI((RefactoringUI)this.createRefactoringUI(fileObjectArray, this.handles));
        }

        protected abstract RefactoringUI createRefactoringUI(FileObject[] var1, Collection<CsmObject> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeToElementTask
    implements Runnable {
        private Node node;
        private RefactoringUI ui;

        public NodeToElementTask(Collection<? extends Node> collection) {
            assert (collection.size() == 1);
            this.node = collection.iterator().next();
        }

        public void cancel() {
        }

        @Override
        public final void run() {
            CsmReference csmReference = CsmReferenceResolver.getDefault().findReference(this.node);
            if (!CsmRefactoringUtils.isSupportedReference(csmReference)) {
                return;
            }
            this.ui = this.createRefactoringUI((CsmObject)csmReference);
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)topComponent);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRenameLoc"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(CsmObject var1);
    }

    public static abstract class TextComponentTask
    implements Runnable {
        private JTextComponent textC;
        private int caret;
        private int start;
        private int end;
        private RefactoringUI ui;
        private Lookup lookup;

        public TextComponentTask(EditorCookie editorCookie, Lookup lookup) {
            this.textC = editorCookie.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            this.lookup = lookup;
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        public final void run() {
            CsmReference csmReference = CsmRefactoringUtils.findReference(this.lookup);
            if (!CsmRefactoringUtils.isSupportedReference(csmReference)) {
                return;
            }
            this.ui = this.createRefactoringUI((CsmObject)csmReference, this.start, this.end);
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)topComponent);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRenameLoc"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(CsmObject var1, int var2, int var3);
    }
}

