/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui.tree;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class FileTreeElement
implements TreeElement {
    private final FileObject fo;
    private final CsmUID<CsmProject> csmProject;
    private final Icon icon;

    FileTreeElement(FileObject fileObject, CsmFile csmFile) {
        this.fo = fileObject;
        ImageIcon imageIcon = null;
        try {
            imageIcon = new ImageIcon(DataObject.find((FileObject)fileObject).getNodeDelegate().getIcon(1));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            imageIcon = null;
        }
        this.icon = imageIcon;
        this.csmProject = CsmRefactoringUtils.getHandler(csmFile.getProject());
    }

    public TreeElement getParent(boolean bl) {
        CsmProject csmProject = (CsmProject)this.csmProject.getObject();
        if (csmProject == null) {
            return null;
        }
        return TreeElementFactory.getTreeElement((Object)csmProject);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getText(boolean bl) {
        return this.fo.getNameExt();
    }

    public Object getUserObject() {
        return this.fo;
    }
}

