/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RefactoringInfo;
import org.netbeans.modules.form.ResourceSupport;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FormRefactoringUpdate
extends SimpleRefactoringElementImplementation
implements Transaction {
    private RefactoringInfo refInfo;
    private RefactoringElementImplementation previewElement;
    private FileObject changingFile;
    private FormDataObject formDataObject;
    private FormEditor formEditor;
    private boolean loadingFailed;
    private boolean guardedCodeChanging;
    private boolean transactionDone;
    private boolean formFileRenameDone;
    private List<BackupFacility.Handle> backups;
    private static final String[] FORM_ELEMENTS_ATTRS = new String[]{"<Component ", " class=\"", "<AuxValue name=\"JavaCodeGenerator_", " value=\"", "<Property ", " preCode=\"", "<Property ", " postCode=\"", "<Connection ", " code=\""};

    public FormRefactoringUpdate(RefactoringInfo refactoringInfo, FileObject fileObject) {
        block3: {
            this.refInfo = refactoringInfo;
            this.changingFile = fileObject;
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (dataObject instanceof FormDataObject) {
                    this.formDataObject = (FormDataObject)dataObject;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    FormDataObject getFormDataObject() {
        return this.formDataObject;
    }

    RefactoringElementImplementation getPreviewElement() {
        if (this.previewElement == null) {
            this.previewElement = new PreviewElement(this.changingFile);
        }
        return this.previewElement;
    }

    void setGaurdedCodeChanging(boolean bl) {
        this.guardedCodeChanging = bl;
    }

    boolean isGuardedCodeChanging() {
        return this.guardedCodeChanging;
    }

    public void commit() {
        if (this.previewElement != null && !this.previewElement.isEnabled()) {
            return;
        }
        block7: for (FileObject fileObject : this.refInfo.getOriginalFiles()) {
            switch (this.refInfo.getChangeType()) {
                case VARIABLE_RENAME: {
                    if (!fileObject.equals(this.changingFile)) continue block7;
                    this.renameMetaComponent(this.refInfo.getOldName(fileObject), this.refInfo.getNewName());
                    this.transactionDone = true;
                    continue block7;
                }
                case CLASS_RENAME: {
                    if (fileObject.equals(this.changingFile)) continue block7;
                    this.componentClassRename(fileObject);
                    this.transactionDone = true;
                    continue block7;
                }
                case CLASS_MOVE: {
                    if (fileObject.equals(this.changingFile) || !this.isGuardedCodeChanging()) continue block7;
                    this.componentChange(this.refInfo.getOldName(fileObject), this.refInfo.getNewName(fileObject));
                    this.transactionDone = !this.refInfo.containsOriginalFile(this.changingFile);
                    continue block7;
                }
                case CLASS_DELETE: {
                    if (!fileObject.equals(this.changingFile)) continue block7;
                    this.saveFormForUndo();
                    this.transactionDone = true;
                    continue block7;
                }
                case PACKAGE_RENAME: {
                    if (this.changingFile.getParent().equals(fileObject)) continue block7;
                    this.packageRename(fileObject);
                    this.transactionDone = true;
                    continue block7;
                }
                default: {
                    return;
                }
            }
        }
    }

    public void rollback() {
        if (this.previewElement != null && !this.previewElement.isEnabled()) {
            return;
        }
        this.undoFromBackups();
    }

    public void performChange() {
        if (this.previewElement != null && !this.previewElement.isEnabled()) {
            return;
        }
        if (this.transactionDone) {
            this.processCustomCode();
            return;
        }
        block6: for (FileObject fileObject : this.refInfo.getOriginalFiles()) {
            switch (this.refInfo.getChangeType()) {
                case CLASS_RENAME: {
                    if (!fileObject.equals(this.changingFile)) continue block6;
                    this.formRename();
                    continue block6;
                }
                case CLASS_MOVE: {
                    if (!fileObject.equals(this.changingFile) || !this.prepareForm(false)) continue block6;
                    this.formMove();
                    continue block6;
                }
                case CLASS_COPY: {
                    if (!fileObject.equals(this.changingFile) || !this.prepareForm(false)) continue block6;
                    this.formCopy();
                    continue block6;
                }
                case PACKAGE_RENAME: 
                case FOLDER_RENAME: {
                    this.packageRename(fileObject);
                }
            }
        }
        this.processCustomCode();
    }

    public void undoChange() {
        if (this.previewElement != null && !this.previewElement.isEnabled()) {
            return;
        }
        if (this.transactionDone) {
            return;
        }
        this.undoFromBackups();
    }

    private void renameMetaComponent(String string, String string2) {
        RADComponent rADComponent;
        if (this.prepareForm(true) && (rADComponent = this.formEditor.getFormModel().findRADComponent(string)) != null) {
            this.saveFormForUndo();
            this.saveResourcesForContentChangeUndo();
            rADComponent.setName(string2);
            this.updateForm(false);
        }
    }

    private void formRename() {
        if (this.prepareForm(true)) {
            this.saveFormForUndo();
            this.saveResourcesForFormRenameUndo();
            ResourceSupport.formMoved(this.formEditor.getFormModel(), null, this.refInfo.getOldName(this.changingFile), false);
            this.updateForm(true);
        }
    }

    private void componentClassRename(FileObject fileObject) {
        String string = this.refInfo.getOldName(fileObject);
        String string2 = this.refInfo.getNewName();
        String string3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject.getParent(), '.', false);
        String string4 = string3 != null && string3.length() > 0 ? string3 + "." + string : string;
        String string5 = string3 != null && string3.length() > 0 ? string3 + "." + string2 : string2;
        this.componentChange(string4, string5);
    }

    private void formMove() {
        final FormEditorSupport formEditorSupport = this.formDataObject.getFormEditorSupport();
        if (formEditorSupport.isOpened()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FormRefactoringUpdate.this.formEditor = formEditorSupport.reloadFormEditor();
                    FormRefactoringUpdate.this.formMove2();
                }
            });
        } else {
            assert (!this.formEditor.isFormLoaded());
            this.formMove2();
        }
    }

    private void formMove2() {
        if (this.prepareForm(true)) {
            this.saveFormForUndo();
            FileObject fileObject = this.changingFile.getParent();
            this.saveResourcesForFormMoveUndo(fileObject);
            String string = this.refInfo.getOldName(this.changingFile);
            string = string.substring(string.lastIndexOf(46) + 1);
            ResourceSupport.formMoved(this.formEditor.getFormModel(), fileObject, string, false);
            this.updateForm(true);
        }
    }

    private void formCopy() {
        if (this.refInfo.getRefactoring() instanceof SingleCopyRefactoring) {
            FileObject fileObject;
            FileObject fileObject2;
            FormDataObject formDataObject;
            FileObject fileObject3;
            block6: {
                fileObject3 = this.changingFile;
                formDataObject = this.formDataObject;
                fileObject2 = this.changingFile.getParent();
                SingleCopyRefactoring singleCopyRefactoring = (SingleCopyRefactoring)this.refInfo.getRefactoring();
                String string = singleCopyRefactoring.getNewName();
                Lookup lookup = singleCopyRefactoring.getTarget();
                fileObject = URLMapper.findFileObject((URL)((URL)lookup.lookup(URL.class)));
                this.changingFile = fileObject.getFileObject(string, "java");
                try {
                    DataObject dataObject = DataObject.find((FileObject)this.changingFile);
                    if (dataObject instanceof FormDataObject) {
                        this.formDataObject = (FormDataObject)dataObject;
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            this.formEditor = null;
            if (this.prepareForm(true)) {
                this.saveResourcesForFormRenameUndo();
                if (fileObject2 == fileObject) {
                    fileObject2 = null;
                }
                ResourceSupport.formMoved(this.formEditor.getFormModel(), fileObject2, fileObject3.getName(), true);
                this.updateForm(true);
            }
            this.changingFile = fileObject3;
            this.formDataObject = formDataObject;
        }
    }

    private void componentChange(String string, String string2) {
        FormEditorSupport formEditorSupport = this.formDataObject.getFormEditorSupport();
        if (formEditorSupport.isOpened()) {
            formEditorSupport.closeFormEditor();
        }
        String[] stringArray = new String[]{string};
        String[] stringArray2 = new String[]{string2};
        this.replaceClassOrPkgName(stringArray, stringArray2, false);
        this.replaceShortClassName(stringArray, stringArray2);
    }

    private boolean replaceShortClassName(String[] stringArray, String[] stringArray2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].contains(".")) continue;
            String string = stringArray[i].substring(stringArray[i].lastIndexOf(46) + 1);
            String string2 = stringArray2[i].substring(stringArray2[i].lastIndexOf(46) + 1);
            if (string2.equals(string)) continue;
            linkedList.add(string);
            linkedList2.add(stringArray2[i]);
        }
        if (!linkedList.isEmpty()) {
            stringArray = linkedList.toArray(new String[linkedList.size()]);
            stringArray2 = linkedList2.toArray(new String[linkedList2.size()]);
            return this.replaceClassOrPkgName(stringArray, stringArray2, false);
        }
        return false;
    }

    private void packageRename(FileObject fileObject) {
        FormEditorSupport formEditorSupport = this.formDataObject.getFormEditorSupport();
        if (formEditorSupport.isOpened()) {
            formEditorSupport.closeFormEditor();
        }
        if (this.replaceClassOrPkgName(new String[]{this.refInfo.getOldName(fileObject)}, new String[]{this.refInfo.getNewName()}, true) && !this.isGuardedCodeChanging()) {
            this.updateForm(true);
        }
    }

    private void processCustomCode() {
        if (this.isGuardedCodeChanging() && !this.formFileRenameDone) {
            boolean bl = false;
            LinkedList<String> linkedList = new LinkedList<String>();
            LinkedList<String> linkedList2 = new LinkedList<String>();
            for (FileObject fileObject : this.refInfo.getOriginalFiles()) {
                String string = this.refInfo.getOldName(fileObject);
                String string2 = this.refInfo.getNewName(fileObject);
                if (string == null || string2 == null) continue;
                linkedList.add(string);
                linkedList2.add(string2);
            }
            if (!linkedList.isEmpty()) {
                String[] stringArray = linkedList.toArray(new String[linkedList.size()]);
                String[] stringArray2 = linkedList2.toArray(new String[linkedList2.size()]);
                bl |= this.replaceClassOrPkgName(stringArray, stringArray2, false);
                switch (this.refInfo.getChangeType()) {
                    case CLASS_RENAME: 
                    case CLASS_MOVE: {
                        bl |= this.replaceShortClassName(stringArray, stringArray2);
                    }
                }
            }
            if (bl) {
                final FormEditorSupport formEditorSupport = this.formDataObject.getFormEditorSupport();
                if (formEditorSupport.isOpened()) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            FormRefactoringUpdate.this.formEditor = formEditorSupport.reloadFormEditor();
                            FormRefactoringUpdate.this.updateForm(true);
                        }
                    });
                } else {
                    if (this.formEditor != null && this.formEditor.isFormLoaded()) {
                        this.formEditor.closeForm();
                    }
                    if (this.prepareForm(true)) {
                        this.updateForm(true);
                    }
                }
            }
            this.formFileRenameDone = false;
        }
    }

    private void updateForm(boolean bl) {
        if (!this.prepareForm(true)) {
            return;
        }
        this.formEditor.getFormModel().fireFormChanged(true);
        FormEditorSupport formEditorSupport = this.getFormDataObject().getFormEditorSupport();
        try {
            if (!formEditorSupport.isOpened()) {
                this.formEditor.saveFormData();
                if (bl) {
                    formEditorSupport.saveSourceOnly();
                }
                this.formEditor.closeForm();
            } else if (bl) {
                formEditorSupport.saveDocument();
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean prepareForm(boolean bl) {
        if (this.formDataObject != null) {
            FormEditor formEditor = this.formDataObject.getFormEditorSupport().getFormEditor();
            if (formEditor != null) {
                this.formEditor = formEditor;
            } else if (this.formEditor == null) {
                this.formEditor = new FormEditor(this.formDataObject);
            }
        }
        if (this.formEditor == null) return false;
        if (this.formEditor.isFormLoaded() || !bl) {
            return true;
        }
        if (this.loadingFailed) return false;
        if (this.formEditor.loadForm()) {
            if (!this.formEditor.anyPersistenceError()) return true;
            this.formEditor.closeForm();
            this.loadingFailed = true;
            return false;
        } else {
            this.loadingFailed = true;
        }
        return false;
    }

    private void saveFormForUndo() {
        this.saveForUndo(this.formDataObject.getFormFile());
    }

    private void saveResourcesForContentChangeUndo() {
        for (URL uRL : ResourceSupport.getFilesForContentChangeBackup(this.formEditor.getFormModel())) {
            this.saveForUndo(uRL);
        }
    }

    private void saveResourcesForFormRenameUndo() {
        for (URL uRL : ResourceSupport.getFilesForFormRenameBackup(this.formEditor.getFormModel())) {
            this.saveForUndo(uRL);
        }
    }

    private void saveResourcesForFormMoveUndo(FileObject fileObject) {
        for (URL uRL : ResourceSupport.getFilesForFormMoveBackup(this.formEditor.getFormModel(), fileObject)) {
            this.saveForUndo(uRL);
        }
    }

    private void saveForUndo(final URL uRL) {
        BackupFacility.Handle handle;
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject != null) {
            try {
                handle = BackupFacility.getDefault().backup(new FileObject[]{fileObject});
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return;
            }
        } else {
            handle = new BackupFacility.Handle(){

                public void restore() throws IOException {
                    FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                    if (fileObject != null) {
                        fileObject.delete();
                    }
                }
            };
        }
        if (this.backups == null) {
            this.backups = new ArrayList<BackupFacility.Handle>();
        }
        this.backups.add(handle);
    }

    private void saveForUndo(FileObject fileObject) {
        try {
            BackupFacility.Handle handle = BackupFacility.getDefault().backup(new FileObject[]{fileObject});
            if (this.backups == null) {
                this.backups = new ArrayList<BackupFacility.Handle>();
            }
            this.backups.add(handle);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void undoFromBackups() {
        if (this.backups != null) {
            try {
                for (BackupFacility.Handle handle : this.backups) {
                    handle.restore();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            this.backups.clear();
        }
    }

    public String getText() {
        return "GUI form update";
    }

    public String getDisplayText() {
        return NbBundle.getMessage(FormRefactoringUpdate.class, (String)"CTL_RefactoringUpdate2");
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public FileObject getParentFile() {
        return this.changingFile;
    }

    public PositionBounds getPosition() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replaceClassOrPkgName(String[] stringArray, String[] stringArray2, boolean bl) {
        FileObject fileObject = this.formDataObject.getFormFile();
        FileLock fileLock = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            String string;
            int n;
            String string2;
            String[] stringArray3;
            String[] stringArray4;
            fileLock = fileObject.lock();
            boolean bl2 = false;
            if (bl) {
                stringArray4 = new String[stringArray.length * 3];
                stringArray3 = new String[stringArray2.length * 3];
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i] + ".";
                    String string4 = stringArray2[i] + ".";
                    String object2 = string3.replace('.', '/');
                    string2 = string4.replace('.', '/');
                    n = i * 3;
                    stringArray4[n] = string3;
                    stringArray4[n + 1] = object2;
                    stringArray4[n + 2] = "/" + object2;
                    stringArray3[n] = string4;
                    stringArray3[n + 1] = string2;
                    stringArray3[n + 2] = "/" + string2;
                }
            } else {
                for (String string3 : stringArray) {
                    if (string3.contains(".")) continue;
                    bl2 = true;
                    break;
                }
                stringArray4 = stringArray;
                stringArray3 = stringArray2;
            }
            String string5 = "UTF-8";
            inputStream = fileObject.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string5));
            if (!bl2) {
                NameReplacer nameReplacer = new NameReplacer(stringArray4, stringArray3, (int)fileObject.getSize());
                string2 = bufferedReader.readLine();
                while (string2 != null) {
                    nameReplacer.append(string2);
                    string2 = bufferedReader.readLine();
                    if (string2 == null) continue;
                    nameReplacer.append("\n");
                }
                string = nameReplacer.getResult();
                if (!nameReplacer.anythingChanged()) {
                    n = 0;
                    return n != 0;
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder((int)fileObject.getSize());
                boolean bl3 = false;
                String string4 = bufferedReader.readLine();
                while (string4 != null) {
                    String string6 = string4.trim();
                    for (int i = 0; i < FORM_ELEMENTS_ATTRS.length; i += 2) {
                        int n2;
                        String string7;
                        int n3;
                        if (!string6.startsWith(FORM_ELEMENTS_ATTRS[i]) || (n3 = string4.indexOf(string7 = FORM_ELEMENTS_ATTRS[i + 1])) <= 0) continue;
                        int n4 = n3 + string7.length();
                        if (!string7.endsWith("\"")) {
                            while (n4 < string4.length() && string4.charAt(n4) != '\"') {
                                ++n4;
                            }
                        }
                        for (n2 = ++n4; n2 < string4.length() && string4.charAt(n2) != '\"'; ++n2) {
                        }
                        if (n4 >= string4.length() || n2 >= string4.length()) continue;
                        String string8 = string4.substring(n4, n2);
                        boolean bl4 = false;
                        for (String string9 : stringArray4) {
                            if (!string8.contains(string9)) continue;
                            bl4 = true;
                            break;
                        }
                        if (!bl4) continue;
                        NameReplacer nameReplacer = new NameReplacer(stringArray4, stringArray3, string8.length());
                        nameReplacer.append(string8);
                        string8 = nameReplacer.getResult();
                        if (!nameReplacer.anythingChanged()) continue;
                        string4 = string4.substring(0, n4) + string8 + string4.substring(n2);
                        bl3 = true;
                    }
                    stringBuilder.append(string4);
                    string4 = bufferedReader.readLine();
                    if (string4 == null) continue;
                    stringBuilder.append("\n");
                }
                if (!bl3) {
                    boolean bl5 = false;
                    return bl5;
                }
                string = stringBuilder.toString();
            }
            this.saveForUndo(fileObject);
            inputStream.close();
            inputStream = null;
            outputStream = fileObject.getOutputStream(fileLock);
            outputStream.write(string.getBytes(string5));
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            boolean bl6 = false;
            return bl6;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        this.formFileRenameDone = true;
        return true;
    }

    private static class NameReplacer {
        private String[] toReplace;
        private String[] replaceWith;
        private int[] matchCounts;
        private StringBuilder buffer;
        private StringBuilder pendingChars;
        private char lastChar;
        private boolean anyChange;
        private boolean ended;

        public NameReplacer(String[] stringArray, String[] stringArray2, int n) {
            this.toReplace = stringArray;
            for (String string : stringArray) {
                assert (string != null && string.length() > 0);
            }
            for (String string : stringArray2) {
                assert (string != null && string.length() > 0);
            }
            this.replaceWith = stringArray2;
            this.pendingChars = new StringBuilder(50);
            this.buffer = new StringBuilder(n);
            this.matchCounts = new int[stringArray.length];
        }

        public void append(String string) {
            assert (!this.ended);
            for (int i = 0; i < string.length(); ++i) {
                this.append(string.charAt(i));
            }
        }

        public String getResult() {
            for (int i = 0; i < this.toReplace.length; ++i) {
                int n = this.matchCounts[i];
                String string = this.toReplace[i];
                if (n != string.length()) continue;
                this.replace(i);
                break;
            }
            this.writePendingChars();
            this.ended = true;
            return this.buffer.toString();
        }

        public boolean anythingChanged() {
            return this.anyChange;
        }

        private void append(char c) {
            int n = -1;
            boolean bl = false;
            for (int i = 0; i < this.toReplace.length; ++i) {
                int n2 = this.matchCounts[i];
                String string = this.toReplace[i];
                if (n2 == string.length()) {
                    if (this.canEndHere(c)) {
                        n = i;
                        break;
                    }
                    this.matchCounts[i] = 0;
                    continue;
                }
                if (string.charAt(n2) == c) {
                    if (n2 <= 0 && !this.canStartHere()) continue;
                    this.matchCounts[i] = n2 + 1;
                    bl = true;
                    continue;
                }
                this.matchCounts[i] = 0;
            }
            if (n >= 0) {
                this.replace(n);
                this.buffer.append(c);
            } else if (bl) {
                this.pendingChars.append(c);
            } else {
                this.writePendingChars();
                this.buffer.append(c);
            }
            this.lastChar = c;
        }

        private boolean canStartHere() {
            return this.lastChar != '.' && this.lastChar != '/' && (this.lastChar <= ' ' || !Character.isJavaIdentifierPart(this.lastChar));
        }

        private boolean canEndHere(char c) {
            return this.lastChar == '.' || this.lastChar == '/' || !Character.isJavaIdentifierPart(c);
        }

        private void replace(int n) {
            int n2 = this.pendingChars.length() - this.matchCounts[n];
            if (n2 > 0) {
                this.buffer.append(this.pendingChars.substring(0, n2));
            }
            this.buffer.append(this.replaceWith[n]);
            for (int i = 0; i < this.matchCounts.length; ++i) {
                this.matchCounts[i] = 0;
            }
            this.pendingChars.delete(0, this.pendingChars.length());
            this.anyChange = true;
        }

        private void writePendingChars() {
            if (this.pendingChars.length() > 0) {
                this.buffer.append(this.pendingChars.toString());
                this.pendingChars.delete(0, this.pendingChars.length());
            }
        }
    }

    private static class PreviewElement
    extends SimpleRefactoringElementImplementation {
        private FileObject file;

        PreviewElement(FileObject fileObject) {
            this.file = fileObject;
        }

        public String getText() {
            return "GUI form update";
        }

        public String getDisplayText() {
            return NbBundle.getMessage(FormRefactoringUpdate.class, (String)"CTL_RefactoringUpdate1");
        }

        public void performChange() {
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

