/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreeModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.editors2.TreeModelEditor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TreeModelCustomizer
extends JPanel {
    private TreeModelEditor propEditor;
    private JLabel label;
    private JScrollPane scrollPane1;
    private JScrollPane scrollPane2;
    private JSplitPane splitPane;
    private JTextArea textArea;
    private JTree tree;
    private JLabel warningLabel;

    public TreeModelCustomizer(TreeModelEditor treeModelEditor) {
        this.propEditor = treeModelEditor;
        this.initComponents();
        String string = treeModelEditor.getCodeValue();
        if (string == null) {
            String string2 = "JTree\n colors\n  blue\n  violet\n  red\n  yellow\n sports\n  basketball\n  soccer\n  football\n  hockey\n food\n  hot dogs\n  pizza\n  ravioli\n  bananas";
            this.textArea.setText(string2);
            this.expandTree();
        }
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                TreeModelCustomizer.this.updateTree();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                TreeModelCustomizer.this.updateTree();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                TreeModelCustomizer.this.updateTree();
            }
        });
        if (string != null) {
            this.textArea.setText(string);
            this.updateTree();
        }
    }

    private void updateTree() {
        String string = this.textArea.getText();
        int n = this.textArea.getTabSize();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
        string = string.replace("\t", stringBuilder.toString());
        TreeModel treeModel = this.propEditor.createTreeModel(string);
        this.tree.setModel(treeModel);
        this.expandTree();
        this.propEditor.setValue(treeModel);
    }

    private void expandTree() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.scrollPane1 = new JScrollPane();
        this.textArea = new JTextArea();
        this.scrollPane2 = new JScrollPane();
        this.tree = new JTree();
        this.label = new JLabel();
        this.warningLabel = new JLabel();
        this.splitPane.setDividerLocation(150);
        this.scrollPane1.setViewportView(this.textArea);
        this.textArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TreeModelCustomizer.class, (String)"ACSD_TreeModelEditor_TextArea"));
        this.splitPane.setLeftComponent(this.scrollPane1);
        this.scrollPane2.setViewportView(this.tree);
        this.tree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TreeModelCustomizer.class, (String)"ACSD_TreeModelEditor_Tree"));
        this.splitPane.setRightComponent(this.scrollPane2);
        this.label.setLabelFor(this.textArea);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getMessage(TreeModelCustomizer.class, (String)"TreeModelCustomizer.label.text"));
        this.warningLabel.setLabelFor(this.tree);
        Mnemonics.setLocalizedText((JLabel)this.warningLabel, (String)NbBundle.getMessage(TreeModelCustomizer.class, (String)"TreeModelCustomizer.warningLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.label, -1, 380, Short.MAX_VALUE).add((Component)this.splitPane, -1, 380, Short.MAX_VALUE).add((Component)this.warningLabel, -1, 380, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.label).addPreferredGap(0).add((Component)this.splitPane, -1, 40, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.warningLabel).addContainerGap()));
    }
}

