/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeExpressionOrigin;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.DefaultLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutNode;
import org.netbeans.modules.form.layoutsupport.LayoutSupportContext;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.layoutsupport.LayoutSupportRegistry;
import org.netbeans.modules.form.layoutsupport.UnknownLayoutSupport;
import org.netbeans.modules.form.layoutsupport.delegates.NullLayoutSupport;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public final class LayoutSupportManager
implements LayoutSupportContext {
    public static final int RESIZE_UP = 1;
    public static final int RESIZE_DOWN = 2;
    public static final int RESIZE_LEFT = 4;
    public static final int RESIZE_RIGHT = 8;
    private LayoutSupportDelegate layoutDelegate;
    private boolean needInit;
    private boolean initializeFromInstance;
    private boolean initializeFromCode;
    private Node.PropertySet[] propertySets;
    private LayoutListener layoutListener;
    private RADVisualContainer metaContainer;
    private Container primaryContainer;
    private Container primaryContainerDelegate;
    private CodeStructure codeStructure;
    private CodeExpression containerCodeExpression;
    private CodeExpression containerDelegateCodeExpression;

    public LayoutSupportManager(RADVisualContainer rADVisualContainer, CodeStructure codeStructure) {
        this.metaContainer = rADVisualContainer;
        this.codeStructure = codeStructure;
    }

    public boolean prepareLayoutDelegate(boolean bl, boolean bl2) throws Exception {
        LayoutSupportDelegate layoutSupportDelegate = null;
        LayoutManager layoutManager = null;
        FormModel formModel = this.metaContainer.getFormModel();
        LayoutSupportRegistry layoutSupportRegistry = LayoutSupportRegistry.getRegistry(formModel);
        Class clazz = layoutSupportRegistry.getSupportClassForContainer(this.metaContainer.getBeanClass());
        if (clazz != null) {
            layoutSupportDelegate = LayoutSupportRegistry.createSupportInstance(clazz);
            if (!bl && !layoutSupportDelegate.checkEmptyContainer(this.getPrimaryContainer())) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, AbstractLayoutSupport.getBundle().getString("MSG_ERR_NonEmptyContainer"));
                throw illegalArgumentException;
            }
        } else {
            CodeExpressionOrigin codeExpressionOrigin;
            Object object;
            Object object2;
            if (bl && ((CodeStatement[])(object2 = CodeStructure.filterStatements((Iterator)(object = CodeStructure.getDefinedStatementsIterator(this.getContainerDelegateCodeExpression())), AbstractLayoutSupport.getSetLayoutMethod()))).length > 0 && (layoutSupportDelegate = layoutSupportRegistry.createSupportForLayout((codeExpressionOrigin = object2[0].getStatementParameters()[0].getOrigin()).getType())) == null) {
                if (codeExpressionOrigin.getType() == LayoutManager.class && codeExpressionOrigin.getCreationParameters().length == 0 && codeExpressionOrigin.getParentExpression() == null && "null".equals(codeExpressionOrigin.getJavaCodeString(null, null))) {
                    layoutSupportDelegate = new NullLayoutSupport();
                } else {
                    return false;
                }
            }
            if (layoutSupportDelegate == null) {
                object = this.getPrimaryContainerDelegate();
                if (((Container)object).getComponentCount() == 0) {
                    layoutManager = ((Container)object).getLayout();
                    layoutSupportDelegate = layoutManager != null ? layoutSupportRegistry.createSupportForLayout(layoutManager.getClass()) : new NullLayoutSupport();
                } else {
                    object2 = new IllegalArgumentException();
                    ErrorManager.getDefault().annotate((Throwable)object2, AbstractLayoutSupport.getBundle().getString("MSG_ERR_NonEmptyContainer"));
                    throw object2;
                }
            }
        }
        if (layoutSupportDelegate == null) {
            return false;
        }
        if (bl2) {
            this.setLayoutDelegate(layoutSupportDelegate, bl);
        } else {
            this.layoutDelegate = layoutSupportDelegate;
            this.needInit = true;
            this.initializeFromInstance = layoutManager != null;
            this.initializeFromCode = bl;
        }
        return true;
    }

    public void initializeLayoutDelegate() throws Exception {
        if (this.layoutDelegate != null && this.needInit) {
            LayoutManager layoutManager = this.initializeFromInstance ? this.getPrimaryContainerDelegate().getLayout() : null;
            this.layoutDelegate.initialize(this, layoutManager, this.initializeFromCode);
            this.fillLayout(null);
            this.getPropertySets();
            this.needInit = false;
        }
    }

    public void setLayoutDelegate(LayoutSupportDelegate layoutSupportDelegate, boolean bl) throws Exception {
        LayoutSupportDelegate layoutSupportDelegate2 = this.layoutDelegate;
        LayoutConstraints[] layoutConstraintsArray = this.layoutDelegate != null && (this.layoutDelegate != layoutSupportDelegate || !bl) ? this.removeLayoutDelegate(true) : null;
        this.layoutDelegate = layoutSupportDelegate;
        this.propertySets = null;
        this.needInit = false;
        if (this.layoutDelegate != null) {
            try {
                this.layoutDelegate.initialize(this, null, bl);
                if (!bl) {
                    this.fillLayout(layoutConstraintsArray);
                }
                this.getPropertySets();
            }
            catch (Exception exception) {
                this.removeLayoutDelegate(false);
                this.layoutDelegate = layoutSupportDelegate2;
                if (this.layoutDelegate != null) {
                    this.fillLayout(null);
                }
                throw exception;
            }
        }
    }

    public LayoutSupportDelegate getLayoutDelegate() {
        return this.layoutDelegate;
    }

    public void setUnknownLayoutDelegate(boolean bl) {
        try {
            this.setLayoutDelegate(new UnknownLayoutSupport(), bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isUnknownLayout() {
        return this.layoutDelegate == null || this.layoutDelegate instanceof UnknownLayoutSupport;
    }

    public boolean isSpecialLayout() {
        return this.layoutDelegate instanceof DefaultLayoutSupport;
    }

    public void copyLayoutDelegateFrom(LayoutSupportManager layoutSupportManager, RADVisualComponent[] rADVisualComponentArray) {
        LayoutSupportDelegate layoutSupportDelegate = layoutSupportManager.getLayoutDelegate();
        int n = layoutSupportDelegate.getComponentCount();
        Container container = this.getPrimaryContainer();
        Container container2 = this.getPrimaryContainerDelegate();
        if (this.layoutDelegate != null) {
            this.removeLayoutDelegate(false);
        }
        CodeExpression[] codeExpressionArray = new CodeExpression[n];
        Component[] componentArray = new Component[n];
        for (int i = 0; i < n; ++i) {
            RADVisualComponent rADVisualComponent = rADVisualComponentArray[i];
            codeExpressionArray[i] = rADVisualComponent.getCodeExpression();
            componentArray[i] = (Component)rADVisualComponent.getBeanInstance();
            LayoutSupportManager.ensureFakePeerAttached(componentArray[i]);
        }
        LayoutSupportDelegate layoutSupportDelegate2 = layoutSupportDelegate.cloneLayoutSupport(this, codeExpressionArray);
        layoutSupportDelegate2.setLayoutToContainer(container, container2);
        layoutSupportDelegate2.addComponentsToContainer(container, container2, componentArray, 0);
        this.layoutDelegate = layoutSupportDelegate2;
        try {
            this.layoutDelegate.acceptContainerLayoutChange(null);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void clearPrimaryContainer() {
        this.layoutDelegate.clearContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate());
    }

    public RADVisualContainer getMetaContainer() {
        return this.metaContainer;
    }

    private LayoutConstraints[] removeLayoutDelegate(boolean bl) {
        RADVisualComponent[] rADVisualComponentArray;
        CodeGroup codeGroup = this.layoutDelegate.getLayoutCode();
        if (codeGroup != null) {
            CodeStructure.removeStatements(codeGroup.getStatementsIterator());
        }
        int n = this.layoutDelegate.getComponentCount();
        LayoutConstraints[] layoutConstraintsArray = null;
        if (n > 0 && (rADVisualComponentArray = this.metaContainer.getSubComponents()).length == n) {
            if (bl) {
                layoutConstraintsArray = new LayoutConstraints[n];
            }
            for (int i = 0; i < n; ++i) {
                LayoutConstraints layoutConstraints = this.layoutDelegate.getConstraints(i);
                if (bl) {
                    layoutConstraintsArray[i] = layoutConstraints;
                }
                if (layoutConstraints != null) {
                    rADVisualComponentArray[i].setLayoutConstraints(this.layoutDelegate.getClass(), layoutConstraints);
                }
                if ((codeGroup = this.layoutDelegate.getComponentCode(i)) == null) continue;
                CodeStructure.removeStatements(codeGroup.getStatementsIterator());
            }
        }
        this.layoutDelegate.removeAll();
        this.layoutDelegate.clearContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate());
        this.layoutDelegate = null;
        return layoutConstraintsArray;
    }

    private void fillLayout(LayoutConstraints[] layoutConstraintsArray) {
        Object object;
        int n;
        RADVisualComponent[] rADVisualComponentArray = this.metaContainer.getSubComponents();
        int n2 = rADVisualComponentArray.length;
        CodeExpression[] codeExpressionArray = new CodeExpression[n2];
        Component[] componentArray = new Component[n2];
        Component[] componentArray2 = new Component[n2];
        LayoutConstraints[] layoutConstraintsArray2 = new LayoutConstraints[n2];
        FormDesigner formDesigner = FormEditor.getFormDesigner(this.metaContainer.getFormModel());
        for (n = 0; n < n2; ++n) {
            object = rADVisualComponentArray[n];
            codeExpressionArray[n] = ((RADComponent)object).getCodeExpression();
            componentArray2[n] = (Component)((RADComponent)object).getBeanInstance();
            LayoutSupportManager.ensureFakePeerAttached(componentArray2[n]);
            layoutConstraintsArray2[n] = ((RADVisualComponent)object).getLayoutConstraints(this.layoutDelegate.getClass());
            Component component = formDesigner != null ? (Component)formDesigner.getComponent((RADComponent)object) : null;
            componentArray[n] = component != null ? component : (Component)((RADComponent)object).getBeanInstance();
        }
        if (layoutConstraintsArray != null) {
            this.layoutDelegate.convertConstraints(layoutConstraintsArray, layoutConstraintsArray2, componentArray);
        }
        if (n2 > 0) {
            this.layoutDelegate.acceptNewComponents(codeExpressionArray, layoutConstraintsArray2, 0);
            this.layoutDelegate.addComponents(codeExpressionArray, layoutConstraintsArray2, 0);
            for (n = 0; n < n2; ++n) {
                rADVisualComponentArray[n].resetConstraintsProperties();
            }
        }
        Container container = this.getPrimaryContainer();
        object = this.getPrimaryContainerDelegate();
        this.layoutDelegate.setLayoutToContainer(container, (Container)object);
        if (n2 > 0) {
            this.layoutDelegate.addComponentsToContainer(container, (Container)object, componentArray2, 0);
        }
    }

    public boolean isDedicated() {
        return this.layoutDelegate.isDedicated();
    }

    public Class getSupportedClass() {
        return this.layoutDelegate.getSupportedClass();
    }

    public boolean shouldHaveNode() {
        return this.layoutDelegate.shouldHaveNode();
    }

    public String getDisplayName() {
        return this.layoutDelegate.getDisplayName();
    }

    public Image getIcon(int n) {
        return this.layoutDelegate.getIcon(n);
    }

    public Node.PropertySet[] getPropertySets() {
        if (this.propertySets == null) {
            if (this.layoutDelegate == null) {
                return new Node.PropertySet[0];
            }
            this.propertySets = this.layoutDelegate.getPropertySets();
            for (int i = 0; i < this.propertySets.length; ++i) {
                Node.Property[] propertyArray = this.propertySets[i].getProperties();
                for (int j = 0; j < propertyArray.length; ++j) {
                    if (!(propertyArray[j] instanceof FormProperty)) continue;
                    FormProperty formProperty = (FormProperty)propertyArray[j];
                    formProperty.addVetoableChangeListener(this.getLayoutListener());
                    formProperty.addPropertyChangeListener(this.getLayoutListener());
                }
            }
        }
        return this.propertySets;
    }

    public Node.Property[] getAllProperties() {
        if (this.layoutDelegate instanceof AbstractLayoutSupport) {
            return ((AbstractLayoutSupport)this.layoutDelegate).getAllProperties();
        }
        ArrayList<Node.Property> arrayList = new ArrayList<Node.Property>();
        for (int i = 0; i < this.propertySets.length; ++i) {
            Node.Property[] propertyArray = this.propertySets[i].getProperties();
            for (int j = 0; j < propertyArray.length; ++j) {
                arrayList.add(propertyArray[j]);
            }
        }
        Node.Property[] propertyArray = new Node.Property[arrayList.size()];
        arrayList.toArray(propertyArray);
        return propertyArray;
    }

    public Node.Property getLayoutProperty(String string) {
        if (this.layoutDelegate instanceof AbstractLayoutSupport) {
            return ((AbstractLayoutSupport)this.layoutDelegate).getProperty(string);
        }
        Node.Property[] propertyArray = this.getAllProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (!string.equals(propertyArray[i].getName())) continue;
            return propertyArray[i];
        }
        return null;
    }

    public Class getCustomizerClass() {
        return this.layoutDelegate.getCustomizerClass();
    }

    public Component getSupportCustomizer() {
        return this.layoutDelegate.getSupportCustomizer();
    }

    public CodeGroup getLayoutCode() {
        return this.layoutDelegate.getLayoutCode();
    }

    public CodeGroup getComponentCode(int n) {
        return this.layoutDelegate.getComponentCode(n);
    }

    public CodeGroup getComponentCode(RADVisualComponent rADVisualComponent) {
        int n = this.metaContainer.getIndexOf(rADVisualComponent);
        return n >= 0 && n < this.layoutDelegate.getComponentCount() ? this.layoutDelegate.getComponentCode(n) : null;
    }

    public int getComponentCount() {
        return this.layoutDelegate.getComponentCount();
    }

    public void acceptNewComponents(RADVisualComponent[] rADVisualComponentArray, LayoutConstraints[] layoutConstraintsArray, int n) {
        CodeExpression[] codeExpressionArray = new CodeExpression[rADVisualComponentArray.length];
        for (int i = 0; i < rADVisualComponentArray.length; ++i) {
            codeExpressionArray[i] = rADVisualComponentArray[i].getCodeExpression();
        }
        this.layoutDelegate.acceptNewComponents(codeExpressionArray, layoutConstraintsArray, n);
    }

    public void addComponents(RADVisualComponent[] rADVisualComponentArray, LayoutConstraints[] layoutConstraintsArray, int n) {
        int n2;
        CodeExpression[] codeExpressionArray = new CodeExpression[rADVisualComponentArray.length];
        Component[] componentArray = new Component[rADVisualComponentArray.length];
        for (n2 = 0; n2 < rADVisualComponentArray.length; ++n2) {
            codeExpressionArray[n2] = rADVisualComponentArray[n2].getCodeExpression();
            componentArray[n2] = (Component)rADVisualComponentArray[n2].getBeanInstance();
            LayoutSupportManager.ensureFakePeerAttached(componentArray[n2]);
        }
        if (n < 0) {
            n = this.layoutDelegate.getComponentCount();
        }
        this.layoutDelegate.addComponents(codeExpressionArray, layoutConstraintsArray, n);
        for (n2 = 0; n2 < rADVisualComponentArray.length; ++n2) {
            rADVisualComponentArray[n2].resetConstraintsProperties();
        }
        this.layoutDelegate.addComponentsToContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate(), componentArray, n);
    }

    public void removeComponent(RADVisualComponent rADVisualComponent, int n) {
        LayoutConstraints layoutConstraints = this.layoutDelegate.getConstraints(n);
        if (layoutConstraints != null) {
            rADVisualComponent.setLayoutConstraints(this.layoutDelegate.getClass(), layoutConstraints);
        }
        CodeStructure.removeStatements(this.layoutDelegate.getComponentCode(n).getStatementsIterator());
        this.layoutDelegate.removeComponent(n);
        if (!this.layoutDelegate.removeComponentFromContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate(), (Component)rADVisualComponent.getBeanInstance())) {
            this.layoutDelegate.clearContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate());
            RADVisualComponent[] rADVisualComponentArray = this.metaContainer.getSubComponents();
            if (rADVisualComponentArray.length > 1) {
                Component[] componentArray = new Component[rADVisualComponentArray.length - 1];
                for (int i = 0; i < rADVisualComponentArray.length; ++i) {
                    if (i == n) continue;
                    Component component = (Component)rADVisualComponentArray[i].getBeanInstance();
                    LayoutSupportManager.ensureFakePeerAttached(component);
                    componentArray[i < n ? i : i - 1] = component;
                }
                this.layoutDelegate.addComponentsToContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate(), componentArray, 0);
            }
        }
    }

    public void removeAll() {
        int n;
        RADVisualComponent[] rADVisualComponentArray = this.metaContainer.getSubComponents();
        for (n = 0; n < rADVisualComponentArray.length; ++n) {
            LayoutConstraints layoutConstraints = this.layoutDelegate.getConstraints(n);
            if (layoutConstraints == null) continue;
            rADVisualComponentArray[n].setLayoutConstraints(this.layoutDelegate.getClass(), layoutConstraints);
        }
        int n2 = this.layoutDelegate.getComponentCount();
        for (n = 0; n < n2; ++n) {
            CodeStructure.removeStatements(this.layoutDelegate.getComponentCode(n).getStatementsIterator());
        }
        this.layoutDelegate.removeAll();
        this.layoutDelegate.clearContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate());
    }

    public boolean isLayoutChanged() {
        Container container = (Container)BeanSupport.getDefaultInstance(this.metaContainer.getBeanClass());
        Container container2 = this.metaContainer.getContainerDelegate(container);
        return this.layoutDelegate.isLayoutChanged(container, container2);
    }

    public LayoutConstraints getConstraints(int n) {
        return this.layoutDelegate.getConstraints(n);
    }

    public LayoutConstraints getConstraints(RADVisualComponent rADVisualComponent) {
        if (this.layoutDelegate == null) {
            return null;
        }
        int n = this.metaContainer.getIndexOf(rADVisualComponent);
        return n >= 0 && n < this.layoutDelegate.getComponentCount() ? this.layoutDelegate.getConstraints(n) : null;
    }

    public static LayoutConstraints storeConstraints(RADVisualComponent rADVisualComponent) {
        RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
        if (rADVisualContainer == null) {
            return null;
        }
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        if (layoutSupportManager == null) {
            return null;
        }
        LayoutConstraints layoutConstraints = layoutSupportManager.getConstraints(rADVisualComponent);
        if (layoutConstraints != null) {
            rADVisualComponent.setLayoutConstraints(layoutSupportManager.getLayoutDelegate().getClass(), layoutConstraints);
        }
        return layoutConstraints;
    }

    public LayoutConstraints getStoredConstraints(RADVisualComponent rADVisualComponent) {
        return rADVisualComponent.getLayoutConstraints(this.layoutDelegate.getClass());
    }

    public void setLayoutToContainer(Container container, Container container2) {
        this.layoutDelegate.setLayoutToContainer(container, container2);
    }

    public void addComponentsToContainer(Container container, Container container2, Component[] componentArray, int n) {
        this.layoutDelegate.addComponentsToContainer(container, container2, componentArray, n);
    }

    public boolean removeComponentFromContainer(Container container, Container container2, Component component) {
        return this.layoutDelegate.removeComponentFromContainer(container, container2, component);
    }

    public boolean clearContainer(Container container, Container container2) {
        return this.layoutDelegate.clearContainer(container, container2);
    }

    public LayoutConstraints getNewConstraints(Container container, Container container2, Component component, int n, Point point, Point point2) {
        LayoutConstraints layoutConstraints = this.layoutDelegate.getNewConstraints(container, container2, component, n, point, point2);
        String string = null;
        Object[] objectArray = null;
        if (this.layoutDelegate instanceof AbstractLayoutSupport) {
            AbstractLayoutSupport abstractLayoutSupport = (AbstractLayoutSupport)this.layoutDelegate;
            string = abstractLayoutSupport.getAssistantContext();
            objectArray = abstractLayoutSupport.getAssistantParams();
        }
        string = string == null ? "generalPosition" : string;
        FormEditor.getAssistantModel(this.metaContainer.getFormModel()).setContext(string, objectArray);
        return layoutConstraints;
    }

    public int getNewIndex(Container container, Container container2, Component component, int n, Point point, Point point2) {
        return this.layoutDelegate.getNewIndex(container, container2, component, n, point, point2);
    }

    public boolean paintDragFeedback(Container container, Container container2, Component component, LayoutConstraints layoutConstraints, int n, Graphics graphics) {
        return this.layoutDelegate.paintDragFeedback(container, container2, component, layoutConstraints, n, graphics);
    }

    public int getResizableDirections(Container container, Container container2, Component component, int n) {
        return this.layoutDelegate.getResizableDirections(container, container2, component, n);
    }

    public LayoutConstraints getResizedConstraints(Container container, Container container2, Component component, int n, Rectangle rectangle, Insets insets, Point point) {
        return this.layoutDelegate.getResizedConstraints(container, container2, component, n, rectangle, insets, point);
    }

    public void processMouseClick(Point point, Container container, Container container2) {
        this.layoutDelegate.processMouseClick(point, container, container2);
    }

    public void selectComponent(int n) {
        this.layoutDelegate.selectComponent(n);
    }

    public void arrangeContainer(Container container, Container container2) {
        this.layoutDelegate.arrangeContainer(container, container2);
    }

    public CodeStructure getCodeStructure() {
        return this.codeStructure;
    }

    public CodeExpression getContainerCodeExpression() {
        if (this.containerCodeExpression == null) {
            this.containerCodeExpression = this.metaContainer.getCodeExpression();
            this.containerDelegateCodeExpression = null;
        }
        return this.containerCodeExpression;
    }

    public CodeExpression getContainerDelegateCodeExpression() {
        if (this.containerDelegateCodeExpression == null) {
            this.containerDelegateCodeExpression = LayoutSupportManager.containerDelegateCodeExpression(this.metaContainer, this.codeStructure);
        }
        return this.containerDelegateCodeExpression;
    }

    public static CodeExpression containerDelegateCodeExpression(RADVisualContainer rADVisualContainer, CodeStructure codeStructure) {
        CodeExpression codeExpression;
        CodeExpression codeExpression2 = rADVisualContainer.getCodeExpression();
        Method method = rADVisualContainer.getContainerDelegateMethod();
        if (method != null) {
            Iterator iterator = CodeStructure.getDefinedExpressionsIterator(codeExpression2);
            CodeExpression[] codeExpressionArray = CodeStructure.filterExpressions(iterator, method);
            if (codeExpressionArray.length > 0) {
                codeExpression = codeExpressionArray[0];
            } else {
                CodeExpressionOrigin codeExpressionOrigin = CodeStructure.createOrigin(codeExpression2, method, null);
                codeExpression = codeStructure.createExpression(codeExpressionOrigin);
            }
        } else {
            codeExpression = codeExpression2;
        }
        return codeExpression;
    }

    public Container getPrimaryContainer() {
        return (Container)this.metaContainer.getBeanInstance();
    }

    public Container getPrimaryContainerDelegate() {
        Container container = (Container)this.metaContainer.getBeanInstance();
        if (this.primaryContainerDelegate == null || this.primaryContainer != container) {
            this.primaryContainer = container;
            this.primaryContainerDelegate = this.metaContainer.getContainerDelegate(container);
        }
        return this.primaryContainerDelegate;
    }

    public Component getPrimaryComponent(int n) {
        return (Component)this.metaContainer.getSubComponent(n).getBeanInstance();
    }

    public void updatePrimaryContainer() {
        Container container = this.getPrimaryContainer();
        Container container2 = this.getPrimaryContainerDelegate();
        this.layoutDelegate.clearContainer(container, container2);
        this.layoutDelegate.setLayoutToContainer(container, container2);
        RADVisualComponent[] rADVisualComponentArray = this.metaContainer.getSubComponents();
        if (rADVisualComponentArray.length > 0) {
            Component[] componentArray = new Component[rADVisualComponentArray.length];
            for (int i = 0; i < rADVisualComponentArray.length; ++i) {
                componentArray[i] = (Component)rADVisualComponentArray[i].getBeanInstance();
                LayoutSupportManager.ensureFakePeerAttached(componentArray[i]);
            }
            this.layoutDelegate.addComponentsToContainer(container, container2, componentArray, 0);
        }
    }

    public void containerLayoutChanged(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Object object;
        if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName() != null) {
            this.layoutDelegate.acceptContainerLayoutChange(LayoutSupportManager.getEventWithValues(propertyChangeEvent));
            object = this.metaContainer.getFormModel();
            ((FormModel)object).fireContainerLayoutChanged(this.metaContainer, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        } else {
            this.propertySets = null;
        }
        object = this.metaContainer.getLayoutNodeReference();
        if (object != null) {
            if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName() != null) {
                ((LayoutNode)object).fireLayoutPropertiesChange();
            } else {
                ((LayoutNode)object).fireLayoutPropertySetsChange();
            }
        }
    }

    public void componentLayoutChanged(int n, PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        RADVisualComponent rADVisualComponent = this.metaContainer.getSubComponent(n);
        if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName() != null) {
            this.layoutDelegate.acceptComponentLayoutChange(n, LayoutSupportManager.getEventWithValues(propertyChangeEvent));
            FormModel formModel = this.metaContainer.getFormModel();
            formModel.fireComponentLayoutChanged(rADVisualComponent, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            if (rADVisualComponent.getNodeReference() != null) {
                rADVisualComponent.getNodeReference().firePropertyChangeHelper(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        } else {
            if (rADVisualComponent.getNodeReference() != null) {
                rADVisualComponent.getNodeReference().fireComponentPropertySetsChange();
            }
            rADVisualComponent.resetConstraintsProperties();
        }
    }

    private static PropertyChangeEvent getEventWithValues(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (object instanceof FormProperty.ValueWithEditor) {
            propertyChangeEvent = new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getPropertyName(), ((FormProperty.ValueWithEditor)object).getValue(), ((FormProperty.ValueWithEditor)object2).getValue());
        }
        return propertyChangeEvent;
    }

    private LayoutListener getLayoutListener() {
        if (this.layoutListener == null) {
            this.layoutListener = new LayoutListener();
        }
        return this.layoutListener;
    }

    private static void ensureFakePeerAttached(Component component) {
        if (component != null && component.getParent() != null) {
            component.getParent().remove(component);
        }
        FakePeerSupport.attachFakePeer(component);
        if (component instanceof Container) {
            FakePeerSupport.attachFakePeerRecursively((Container)component);
        }
    }

    private class LayoutListener
    implements VetoableChangeListener,
    PropertyChangeListener {
        private LayoutListener() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (object instanceof FormProperty && ("propertyValue".equals(string) || "propertyValueAndEditor".equals(string))) {
                propertyChangeEvent = new PropertyChangeEvent(LayoutSupportManager.this.layoutDelegate, ((FormProperty)((Object)object)).getName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                LayoutSupportManager.this.containerLayoutChanged(propertyChangeEvent);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof FormProperty && "currentEditor".equals(propertyChangeEvent.getPropertyName())) {
                propertyChangeEvent = new PropertyChangeEvent(LayoutSupportManager.this.layoutDelegate, null, null, null);
                try {
                    LayoutSupportManager.this.containerLayoutChanged(propertyChangeEvent);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }
}

