/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.openide.util.Utilities;

class DropTargetLayer
extends JComponent {
    private MenuEditLayer canvas;
    private Point currentTargetPoint;
    private DropTargetType currentTargetType;
    private JComponent currentTargetComponent;
    private JComponent selectedComponent;
    public static final BasicStroke DROP_TARGET_LINE_STROKE = new BasicStroke(3.0f, 1, 1, 1.0f, new float[]{6.0f, 6.0f}, 0.0f);
    public static final Color DROP_TARGET_COLOR;
    private static Color SELECTION_COLOR;
    private static BasicStroke SELECTION_STROKE;

    public DropTargetLayer(MenuEditLayer menuEditLayer) {
        this.canvas = menuEditLayer;
    }

    public void setSelectedComponent(JComponent jComponent) {
        this.selectedComponent = jComponent;
        this.repaint();
    }

    public void setDropTarget(JComponent jComponent, Point point, DropTargetType dropTargetType) {
        this.currentTargetComponent = jComponent;
        this.currentTargetPoint = point;
        this.currentTargetType = dropTargetType;
        this.repaint();
    }

    public void setDropTarget(RADComponent rADComponent, Point point) {
        this.currentTargetComponent = (JComponent)this.canvas.formDesigner.getComponent(rADComponent);
        this.currentTargetPoint = point;
        this.currentTargetType = DropTargetType.NONE;
        this.repaint();
    }

    public void setDropTarget(RADComponent rADComponent, Point point, DropTargetType dropTargetType) {
        this.currentTargetComponent = (JComponent)this.canvas.formDesigner.getComponent(rADComponent);
        this.currentTargetPoint = point;
        this.currentTargetType = dropTargetType;
        this.repaint();
    }

    public JComponent getDropTargetComponent() {
        return this.currentTargetComponent;
    }

    public void clearDropTarget() {
        this.currentTargetComponent = null;
        this.currentTargetType = DropTargetType.NONE;
        this.currentTargetPoint = null;
        this.repaint();
    }

    public static boolean isMenuRightEdge(Point point, JComponent jComponent) {
        return point.x > jComponent.getWidth() - 8;
    }

    public static boolean isMenuLeftEdge(Point point, JComponent jComponent) {
        return point.x < 8;
    }

    public static boolean isSubMenuRightEdge(Point point, JComponent jComponent) {
        return point.x > jComponent.getWidth() - 30;
    }

    public static boolean isBelowItem(Point point, JComponent jComponent) {
        return point.y > jComponent.getHeight() / 2;
    }

    protected void paintComponent(Graphics graphics) {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.currentTargetComponent != null && (object3 = this.canvas.getFormMenuBar()) != null && this.canvas.formDesigner != null) {
            graphics2D.setColor(DROP_TARGET_COLOR);
            graphics2D.setStroke(DROP_TARGET_LINE_STROKE);
            if (this.canvas.formDesigner.getMetaComponent(this.currentTargetComponent) == object3) {
                this.drawOpenSpotAtEndOfMenuBar(graphics2D, this.currentTargetComponent);
            } else if (this.currentTargetComponent.getParent() instanceof JMenuBar) {
                object2 = this.currentTargetComponent;
                JComponent object4 = (JComponent)this.currentTargetComponent.getParent();
                object = SwingUtilities.convertPoint((Component)object2, new Point(0, 0), this);
                serializable = SwingUtilities.convertPoint(this, this.currentTargetPoint, (Component)object2);
                graphics2D.setColor(DROP_TARGET_COLOR);
                if (this.currentTargetType != DropTargetType.INTO_SUBMENU) {
                    if (DropTargetLayer.isMenuLeftEdge((Point)serializable, (JComponent)object2)) {
                        DropTargetLayer.drawVerticalTargetLine(graphics2D, ((Point)object).x - 1, ((Point)object).y, 50);
                    } else if (DropTargetLayer.isMenuRightEdge((Point)serializable, (JComponent)object2)) {
                        if (this.isLastChild((JComponent)object2, object4)) {
                            this.drawOpenSpotAtEndOfMenuBar(graphics2D, object4);
                        } else {
                            DropTargetLayer.drawVerticalTargetLine(graphics2D, ((Point)object).x + ((JComponent)object2).getWidth(), ((Point)object).y, 50);
                        }
                    } else {
                        graphics2D.drawRect(((Point)object).x, ((Point)object).y, ((JComponent)object2).getWidth(), ((JComponent)object2).getHeight());
                    }
                }
            }
        }
        if ((object3 = this.canvas.getDragOperation().getDragComponent()) instanceof JSeparator) {
            object2 = this.canvas.formDesigner.getHandleLayer();
            if (this.canvas.getDragOperation().getDeepestComponent(this.currentTargetPoint) != null) {
                graphics2D.translate(((JComponent)object3).getX(), ((JComponent)object3).getY());
                graphics2D.setStroke(SELECTION_STROKE);
                graphics2D.setColor(SELECTION_COLOR);
                graphics2D.drawRect(0, -1, ((JComponent)object3).getWidth(), ((JComponent)object3).getHeight());
                graphics2D.translate(-((JComponent)object3).getX(), -((JComponent)object3).getY());
                ((HandleLayer)object2).suspend();
                ((JComponent)object3).setVisible(true);
            } else {
                ((HandleLayer)object2).resume();
                ((JComponent)object3).setVisible(false);
            }
        }
        for (RADComponent rADComponent : this.canvas.getSelectedRADComponents()) {
            if (rADComponent == null) continue;
            object = this.canvas.formDesigner.getComponent(rADComponent);
            serializable = object instanceof JComponent ? (JComponent)object : null;
            this.drawSelectedComponent(graphics2D, (JComponent)serializable, rADComponent);
        }
        this.drawDropTarget(graphics2D);
        graphics2D.dispose();
    }

    private boolean isLastChild(JComponent jComponent, JComponent jComponent2) {
        if (jComponent2 == null) {
            return false;
        }
        if (jComponent2.getComponentCount() < 1) {
            return false;
        }
        return jComponent == jComponent2.getComponent(jComponent2.getComponentCount() - 1);
    }

    private void drawOpenSpotAtEndOfMenuBar(Graphics2D graphics2D, JComponent jComponent) {
        Point point = SwingUtilities.convertPoint(jComponent, new Point(0, 0), this);
        if (jComponent.getComponentCount() > 0) {
            Component component = jComponent.getComponent(jComponent.getComponentCount() - 1);
            point.x += component.getX() + component.getWidth();
        }
        graphics2D.drawRect(point.x + 2, point.y + 2, jComponent.getHeight() - 4, jComponent.getHeight() - 4);
    }

    private void drawSelectedComponent(Graphics2D graphics2D, JComponent jComponent, RADComponent rADComponent) {
        JMenuItem jMenuItem;
        if (jComponent == null) {
            return;
        }
        if (jComponent.getParent() == null || !jComponent.getParent().isVisible()) {
            return;
        }
        if (jComponent instanceof JMenu && jComponent.getParent() instanceof JMenuBar) {
            jMenuItem = (JMenuItem)jComponent;
            Point point = SwingUtilities.convertPoint(jMenuItem, new Point(0, 0), this);
            graphics2D.translate(point.x, point.y);
            graphics2D.setStroke(SELECTION_STROKE);
            graphics2D.setColor(SELECTION_COLOR);
            graphics2D.drawRect(0, 0, jMenuItem.getWidth() - 1, jMenuItem.getHeight() - 1);
            graphics2D.translate(-point.x, -point.y);
        }
        if (jComponent instanceof JMenuItem && !(jComponent.getParent() instanceof JMenuBar) && this.currentTargetComponent == null) {
            jMenuItem = (JMenuItem)jComponent;
            this.drawSubselectedItem(graphics2D, jMenuItem);
        }
    }

    private void drawDropTarget(Graphics2D graphics2D) {
        if (this.currentTargetComponent != null) {
            int n;
            int n2;
            Point point;
            Point point2 = SwingUtilities.convertPoint(this, this.currentTargetPoint, this.currentTargetComponent);
            if (this.currentTargetType == DropTargetType.INTER_MENU) {
                point = SwingUtilities.convertPoint(this.currentTargetComponent, new Point(0, 0), this);
                n2 = point.x;
                n = point.y;
                if (DropTargetLayer.isBelowItem(point2, this.currentTargetComponent)) {
                    n += this.currentTargetComponent.getHeight();
                }
                graphics2D.translate(n2, n);
                DropTargetLayer.drawHorizontalTargetLine(graphics2D, -10, 0, this.currentTargetComponent.getWidth() + 20);
                graphics2D.translate(-n2, -n);
            }
            if (this.currentTargetType == DropTargetType.INTO_SUBMENU) {
                point = SwingUtilities.convertPoint(this.currentTargetComponent, new Point(0, 0), this);
                n2 = point.x;
                n = point.y;
                int n3 = this.currentTargetComponent.getWidth();
                int n4 = this.currentTargetComponent.getHeight();
                graphics2D.translate(n2, n);
                graphics2D.drawRect(0, 0, n3, n4);
                graphics2D.translate(-n2, -n);
            }
        }
    }

    private void drawSubselectedItem(Graphics2D graphics2D, JMenuItem jMenuItem) {
        Point point = SwingUtilities.convertPoint(jMenuItem, new Point(0, 0), this);
        graphics2D.translate(point.x, point.y);
        int n = jMenuItem.getIconTextGap();
        int n2 = DropTargetLayer.getIconLeft(jMenuItem);
        int n3 = DropTargetLayer.getIconWidth(jMenuItem);
        int n4 = DropTargetLayer.getIconHeight(jMenuItem);
        int n5 = (jMenuItem.getHeight() - n4) / 2;
        int n6 = DropTargetLayer.getAcceleratorWidth(jMenuItem);
        int n7 = jMenuItem.getWidth() - n2 - n3 - n - n6;
        int n8 = jMenuItem.getWidth() - n6;
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.setStroke(SELECTION_STROKE);
        graphics2D.setColor(SELECTION_COLOR);
        switch (this.canvas.getCurrentSelectedPortion()) {
            case Icon: {
                if (jMenuItem.getIcon() == null) break;
                graphics2D.drawRect(n2 - 1, n5 - 1, n3 + 1, n4 + 1);
                break;
            }
            case Text: {
                graphics2D.drawRect(n2 + n3 + n - 1, -1, n7 + 1, jMenuItem.getHeight() + 1);
                break;
            }
            case Accelerator: {
                if (jMenuItem instanceof JMenu) break;
                graphics2D.drawRect(n8 - 1, -1, n6 + 1, jMenuItem.getHeight() + 1);
                break;
            }
            case All: {
                graphics2D.drawRect(0, 0, jMenuItem.getWidth() - 1, jMenuItem.getHeight() - 1);
            }
        }
        graphics2D.translate(-point.x, -point.y);
    }

    private static void drawHorizontalTargetLine(Graphics2D graphics2D, int n, int n2, int n3) {
        graphics2D.setColor(DROP_TARGET_COLOR);
        graphics2D.setStroke(DROP_TARGET_LINE_STROKE);
        graphics2D.drawLine(n, n2 - 1, n - 1 + n3, n2 - 1);
    }

    private static void drawVerticalTargetLine(Graphics2D graphics2D, int n, int n2, int n3) {
        graphics2D.setColor(DROP_TARGET_COLOR);
        graphics2D.setStroke(DROP_TARGET_LINE_STROKE);
        graphics2D.drawLine(n - 1, n2, n - 1, n2 + n3);
    }

    private static int getAcceleratorWidth(JMenuItem jMenuItem) {
        if (jMenuItem instanceof JMenu) {
            return 0;
        }
        if (jMenuItem.getAccelerator() != null) {
            return 50;
        }
        return 80;
    }

    private static int getAcceleratorLeft(JMenuItem jMenuItem) {
        return jMenuItem.getWidth() - DropTargetLayer.getAcceleratorWidth(jMenuItem);
    }

    public static MenuEditLayer.SelectedPortion calculateSelectedPortion(JMenuItem jMenuItem, Point point) {
        if (point.x <= DropTargetLayer.getIconRight(jMenuItem)) {
            return MenuEditLayer.SelectedPortion.Icon;
        }
        if (point.x > DropTargetLayer.getAcceleratorLeft(jMenuItem)) {
            return MenuEditLayer.SelectedPortion.Accelerator;
        }
        return MenuEditLayer.SelectedPortion.Text;
    }

    private static int getIconWidth(JMenuItem jMenuItem) {
        int n = jMenuItem.getIcon() != null ? jMenuItem.getIcon().getIconWidth() : 0;
        return n;
    }

    private static int getIconHeight(JMenuItem jMenuItem) {
        int n = jMenuItem.getIcon() != null ? jMenuItem.getIcon().getIconHeight() : 0;
        return n;
    }

    private static int getIconLeft(JMenuItem jMenuItem) {
        if (Utilities.isWindows()) {
            if (DropTargetLayer.isVista()) {
                return 1;
            }
            if (DropTargetLayer.hasRadioOrCheckSibling(jMenuItem)) {
                return 20;
            }
            return 20;
        }
        if (DropTargetLayer.isAqua()) {
            if (jMenuItem instanceof JRadioButtonMenuItem) {
                return 11;
            }
            return 14;
        }
        if (DropTargetLayer.isRadioOrCheck(jMenuItem)) {
            return 20;
        }
        return 10;
    }

    private static boolean isRadioOrCheck(JMenuItem jMenuItem) {
        if (jMenuItem instanceof JRadioButtonMenuItem) {
            return true;
        }
        return jMenuItem instanceof JCheckBoxMenuItem;
    }

    private static boolean hasRadioOrCheckSibling(JMenuItem jMenuItem) {
        if (jMenuItem.getParent() == null) {
            return false;
        }
        for (Component component : jMenuItem.getParent().getComponents()) {
            if (component instanceof JRadioButtonMenuItem) {
                return true;
            }
            if (!(component instanceof JCheckBoxMenuItem)) continue;
            return true;
        }
        return false;
    }

    private static int getIconRight(JMenuItem jMenuItem) {
        return DropTargetLayer.getIconLeft(jMenuItem) + DropTargetLayer.getIconWidth(jMenuItem);
    }

    static boolean isMetal() {
        String string = UIManager.getLookAndFeel().getName();
        if (string == null) {
            return false;
        }
        return string.startsWith("Metal");
    }

    static boolean isVista() {
        return System.getProperty("os.name").startsWith("Windows Vista");
    }

    static boolean isAqua() {
        String string = UIManager.getLookAndFeel().getName();
        if (string == null) {
            return false;
        }
        return string.startsWith("Mac OS X");
    }

    public static boolean isMultiselectPressed(MouseEvent mouseEvent) {
        if (mouseEvent.isShiftDown()) {
            return true;
        }
        return !DropTargetLayer.isAqua() && mouseEvent.isControlDown();
    }

    static {
        SELECTION_COLOR = DROP_TARGET_COLOR = new Color(16753664);
        SELECTION_STROKE = new BasicStroke(1.0f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DropTargetType {
        INTER_MENU,
        NONE,
        INTO_SUBMENU;

    }
}

