/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.xpath;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.CorrelationProperty;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PropertyAlias;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.ValidationUtil;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.xpath.PathValidationContext;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.XPathSchemaContext;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathModelTracerVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathValidatorVisitor
extends XPathModelTracerVisitor {
    private PathValidationContext myContext;

    public PathValidatorVisitor(PathValidationContext pathValidationContext) {
        this.myContext = pathValidationContext;
    }

    public void visit(XPathLocationPath xPathLocationPath) {
        Set<GlobalType> set;
        SchemaComponent schemaComponent;
        if (xPathLocationPath.getAbsolute()) {
            schemaComponent = this.myContext.getSchemaContextComponent();
            if (schemaComponent instanceof GlobalType) {
                this.myContext.addResultItem(Validator.ResultType.ERROR, "ABSOLUTE_XPATH_WITH_TYPE", new Object[0]);
            } else {
                assert (schemaComponent instanceof GlobalElement) : "Root component type is " + schemaComponent.getComponentType().getName() + " but it has to be a GlobalElement";
                this.checkFirstStepType(xPathLocationPath, (GlobalElement)schemaComponent);
            }
        }
        schemaComponent = null;
        WSDLComponent wSDLComponent = this.myContext.getWsdlContext();
        if (wSDLComponent instanceof PropertyAlias) {
            set = (PropertyAlias)wSDLComponent;
            schemaComponent = this.getPropertyType((PropertyAlias)((Object)set));
        }
        if (schemaComponent != null) {
            set = this.getLastStepSchemaTypeSet(xPathLocationPath);
            if (set == null || set.isEmpty()) {
                return;
            }
            if (set.size() == 1) {
                GlobalType globalType = (GlobalType)set.iterator().next();
                if (ValidationUtil.getBasedSimpleType((Component)schemaComponent) != ValidationUtil.getBasedSimpleType((Component)globalType)) {
                    this.myContext.addResultItem(Validator.ResultType.WARNING, "QUERY_INCONSISTENT_TYPE", ValidationUtil.getTypeName((SchemaComponent)globalType), ValidationUtil.getTypeName(schemaComponent));
                } else if (!(ValidationUtil.getBasedSimpleType((Component)globalType) instanceof SimpleType)) {
                    this.myContext.addResultItem(Validator.ResultType.ERROR, "TYPE_MUST_BE_SIMPLE", new Object[0]);
                }
            } else {
                boolean bl = false;
                for (GlobalType globalType : set) {
                    if (!schemaComponent.equals(globalType)) continue;
                    bl = true;
                }
                if (bl) {
                    this.myContext.addResultItem(Validator.ResultType.WARNING, "QUERY_AMBIGUOUS_TYPE", schemaComponent.getName());
                } else {
                    this.myContext.addResultItem(Validator.ResultType.ERROR, "QUERY_CANNOTBE_CONSISTENT_TYPE", schemaComponent.getName());
                }
            }
        }
    }

    public void visit(XPathExpressionPath xPathExpressionPath) {
        this.myContext.addResultItem(Validator.ResultType.ERROR, "UNSUPPORTED_VARIABLE_EXPRESSION", new Object[0]);
    }

    private boolean checkFirstStepType(XPathLocationPath xPathLocationPath, GlobalElement globalElement) {
        String string;
        Object object;
        Object object2;
        Set set = null;
        LocationStep[] locationStepArray = xPathLocationPath.getSteps();
        if (locationStepArray != null && locationStepArray.length != 0 && (object2 = locationStepArray[0]) != null && (object = object2.getSchemaContext()) != null) {
            set = object.getSchemaCompPairs();
        }
        if (set == null || set.isEmpty()) {
            return true;
        }
        if (set.size() == 1 && (object2 = (XPathSchemaContext.SchemaCompPair)set.iterator().next()) != null && (object = object2.getCompHolder().getSchemaComponent()).equals(globalElement)) {
            return true;
        }
        object2 = globalElement.getName();
        object = globalElement.getModel().getEffectiveNamespace((SchemaComponent)globalElement);
        Object object3 = object2;
        if (object != null && (string = this.myContext.getNsContext().getPrefix((String)object)) != null && string.length() != 0) {
            object3 = string + ":" + (String)object2;
        }
        this.myContext.addResultItem(Validator.ResultType.ERROR, "WRONG_START_ELEMENT_ABSOLUTE", object3);
        return false;
    }

    private Set<GlobalType> getLastStepSchemaTypeSet(XPathLocationPath xPathLocationPath) {
        Object object;
        XPathSchemaContext xPathSchemaContext;
        LocationStep locationStep;
        Set set = null;
        LocationStep[] locationStepArray = xPathLocationPath.getSteps();
        if (locationStepArray != null && locationStepArray.length > 0 && (locationStep = locationStepArray[locationStepArray.length - 1]) != null && (xPathSchemaContext = locationStep.getSchemaContext()) != null) {
            set = xPathSchemaContext.getSchemaCompPairs();
        }
        if (set == null || set.isEmpty()) {
            return null;
        }
        if (set.size() == 1) {
            locationStep = (XPathSchemaContext.SchemaCompPair)set.iterator().next();
            xPathSchemaContext = locationStep.getCompHolder();
            GlobalType globalType = this.getComponentType(xPathSchemaContext.getSchemaComponent());
            if (globalType == null) {
                String string = xPathSchemaContext.getName();
                return null;
            }
            return Collections.singleton(globalType);
        }
        boolean bl = true;
        boolean bl2 = false;
        SchemaComponent schemaComponent = null;
        HashSet<GlobalType> hashSet = new HashSet<GlobalType>();
        for (XPathSchemaContext.SchemaCompPair schemaCompPair : set) {
            schemaComponent = schemaCompPair.getCompHolder().getSchemaComponent();
            GlobalType globalType = this.getComponentType(schemaComponent);
            if (globalType != null) {
                hashSet.add(globalType);
                bl2 = true;
                continue;
            }
            bl = false;
        }
        if (!bl2) {
            object = ((Named)schemaComponent).getName();
            return null;
        }
        if (!bl) {
            object = ((Named)schemaComponent).getName();
            this.myContext.addResultItem(Validator.ResultType.WARNING, "QUERY_TAIL_CANBE_NOT_GLOBAL_TYPE", object);
        }
        return hashSet;
    }

    private GlobalType getComponentType(SchemaComponent schemaComponent) {
        GlobalElement globalElement;
        GlobalType globalType;
        NamedComponentReference namedComponentReference = null;
        if (schemaComponent instanceof TypeContainer) {
            namedComponentReference = ((TypeContainer)schemaComponent).getType();
        } else if (schemaComponent instanceof LocalAttribute) {
            namedComponentReference = ((LocalAttribute)schemaComponent).getType();
        } else if (schemaComponent instanceof GlobalAttribute) {
            namedComponentReference = ((GlobalAttribute)schemaComponent).getType();
        } else if (schemaComponent instanceof ElementReference && (globalType = ((ElementReference)schemaComponent).getRef()) != null && (globalElement = (GlobalElement)globalType.get()) != null) {
            namedComponentReference = globalElement.getType();
        }
        if (namedComponentReference != null) {
            globalType = (GlobalType)namedComponentReference.get();
            if (globalType == null) {
                this.myContext.addResultItem(Validator.ResultType.ERROR, "UNRESOLVED_GLOBAL_TYPE", namedComponentReference.getRefString());
            }
            return globalType;
        }
        return null;
    }

    private GlobalType getPropertyType(PropertyAlias propertyAlias) {
        if (propertyAlias == null) {
            return null;
        }
        NamedComponentReference<CorrelationProperty> namedComponentReference = propertyAlias.getPropertyName();
        if (namedComponentReference == null) {
            this.myContext.addResultItem(Validator.ResultType.WARNING, "CPROP_NOT_SPECIFIED", new Object[0]);
            return null;
        }
        CorrelationProperty correlationProperty = (CorrelationProperty)namedComponentReference.get();
        if (correlationProperty == null) {
            if (this.myContext != null) {
                this.myContext.addResultItem(Validator.ResultType.ERROR, "UNRESOLVED_CPROP", correlationProperty.getName());
            }
            return null;
        }
        GlobalType globalType = null;
        NamedComponentReference<GlobalType> namedComponentReference2 = correlationProperty.getType();
        if (namedComponentReference2 != null) {
            globalType = (GlobalType)namedComponentReference2.get();
        } else {
            NamedComponentReference namedComponentReference3;
            GlobalElement globalElement;
            NamedComponentReference<GlobalElement> namedComponentReference4 = correlationProperty.getElement();
            if (namedComponentReference4 != null && (globalElement = (GlobalElement)namedComponentReference4.get()) != null && (namedComponentReference3 = globalElement.getType()) != null) {
                globalType = (GlobalType)namedComponentReference3.get();
            }
        }
        if (globalType == null) {
            this.myContext.addResultItem(Validator.ResultType.ERROR, "UNRESOLVED_CPROP_TYPE", correlationProperty.getName(), namedComponentReference2.getRefString());
        }
        return globalType;
    }
}

