/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components.svg.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGButtonCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGButtonEventSourceCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGCheckBoxCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComboBoxCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGLabelCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGListCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGRadioButtonCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGSliderCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGSpinnerCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGTextFieldCD;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.AbstractElementsContentHandler;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGComponentImageParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SVGFormImageParser
extends SVGComponentImageParser {
    private static final String DIGITS = "_\\d+$";
    private static final String PREFIX = "^";
    private static final Pattern FORM_COMPONENT_ID_BUTTON = Pattern.compile("^button_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_LABEL = Pattern.compile("^label_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_RADIO = Pattern.compile("^radiobutton_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_CHECKBOX = Pattern.compile("^checkbox_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_COMBOBOX = Pattern.compile("^combobox_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_LIST = Pattern.compile("^list_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_SLIDER = Pattern.compile("^slider_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_SPINNER = Pattern.compile("^spinner_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_TEXTFIELD = Pattern.compile("^textfield_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_RADIOBUTTONFRAME = Pattern.compile("^radiobuttonframe_\\d+$");

    public static synchronized void parseSVGForm(InputStream inputStream, final DesignComponent designComponent) {
        final SVGFormComponent[] sVGFormComponentArray = SVGFormImageParser.getFormComponents(inputStream);
        if (sVGFormComponentArray != null) {
            designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    for (SVGFormComponent sVGFormComponent : sVGFormComponentArray) {
                        DesignComponent designComponent2 = sVGFormComponent.createComponent(designComponent);
                        designComponent.addComponent(designComponent2);
                        MidpArraySupport.append((DesignComponent)designComponent, (String)"components", (DesignComponent)designComponent2);
                    }
                }
            });
        }
    }

    public void parse(InputStream inputStream, DesignComponent designComponent) {
        SVGFormImageParser.parseSVGForm(inputStream, designComponent);
    }

    private static SVGFormComponent[] getFormComponents(InputStream inputStream) {
        NamedElementsContentHandler namedElementsContentHandler = new NamedElementsContentHandler();
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(namedElementsContentHandler);
            xMLReader.setEntityResolver(namedElementsContentHandler);
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (IOException iOException) {
            Debug.warning((Object[])new Object[]{iOException});
        }
        catch (SAXException sAXException) {
            Debug.warning((Object[])new Object[]{sAXException});
        }
        return namedElementsContentHandler.getFoundElements();
    }

    private static Float getPosition(Attributes attributes) {
        String string = attributes.getValue("transform");
        Float f = null;
        if (string != null) {
            if (string.startsWith("translate")) {
                f = SVGFormImageParser.getPositionFromTranslate(string);
            } else if (string.startsWith("matrix")) {
                f = SVGFormImageParser.getPositionFromMatrix(string);
            }
        }
        return f;
    }

    private static Float getPositionFromTranslate(String string) {
        Float f = null;
        int n = string.indexOf(",");
        int n2 = string.indexOf(")");
        try {
            f = new Float(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(SVGFormImageParser.class.getName()).info(numberFormatException.getMessage());
        }
        return f;
    }

    private static Float getPositionFromMatrix(String string) {
        Float f = null;
        int n = string.lastIndexOf(",");
        int n2 = string.indexOf(")");
        try {
            f = new Float(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(SVGFormImageParser.class.getName()).info(numberFormatException.getMessage());
        }
        return f;
    }

    private static Float getPositionForRadioButton(Attributes attributes, Float f) {
        String string = attributes.getValue("transform");
        Float f2 = null;
        if (string != null) {
            int n = string.indexOf(",");
            int n2 = string.indexOf(")");
            f2 = new Float(string.substring(n + 1, n2));
            f2 = Float.valueOf(f2.floatValue() + f.floatValue());
        }
        return f2;
    }

    public static final String[][] getComponentsInformation(InputStream inputStream) {
        SVGFormComponent[] sVGFormComponentArray = SVGFormImageParser.getFormComponents(inputStream);
        String[][] stringArray = new String[sVGFormComponentArray.length][2];
        for (int i = 0; i < sVGFormComponentArray.length; ++i) {
            stringArray[i][1] = sVGFormComponentArray[i].getId();
            stringArray[i][0] = MidpTypes.getSimpleClassName((TypeID)sVGFormComponentArray[i].getTypeID());
        }
        return stringArray;
    }

    private static class NamedElementsContentHandler
    extends AbstractElementsContentHandler {
        private ArrayList<SVGFormComponent> foundElements = new ArrayList();
        private Float radioButtonFramePosition;

        public SVGFormComponent[] getFoundElements() {
            LinkedList<SVGFormComponent> linkedList = new LinkedList<SVGFormComponent>();
            for (SVGFormComponent sVGFormComponent : this.foundElements) {
                linkedList.addFirst(sVGFormComponent);
            }
            return linkedList.toArray(new SVGFormComponent[linkedList.size()]);
        }

        public final void resetFoundElements() {
            this.foundElements.clear();
        }

        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4 = attributes.getValue("id");
            String string5 = attributes.getValue("transform");
            if (string4 == null || string5 == null) {
                return;
            }
            if (FORM_COMPONENT_ID_RADIOBUTTONFRAME.matcher(string4).find()) {
                this.radioButtonFramePosition = SVGFormImageParser.getPosition(attributes);
            }
            if (FORM_COMPONENT_ID_BUTTON.matcher(string4).find()) {
                Float f = SVGFormImageParser.getPosition(attributes);
                int n = this.getIndex(f);
                if (n == -1) {
                    this.foundElements.add(SVGFormComponent.createSVGButton(string4, SVGButtonCD.TYPEID, f));
                } else {
                    this.foundElements.add(n, SVGFormComponent.createSVGButton(string4, SVGButtonCD.TYPEID, f));
                }
            } else if (FORM_COMPONENT_ID_CHECKBOX.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGCheckBoxCD.TYPEID, SVGFormImageParser.getPosition(attributes));
            } else if (FORM_COMPONENT_ID_COMBOBOX.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGComboBoxCD.TYPEID, SVGFormImageParser.getPosition(attributes));
            } else if (FORM_COMPONENT_ID_LABEL.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGLabelCD.TYPEID, SVGFormImageParser.getPosition(attributes));
            } else if (FORM_COMPONENT_ID_LIST.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGListCD.TYPEID, SVGFormImageParser.getPosition(attributes));
            } else if (FORM_COMPONENT_ID_RADIO.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGRadioButtonCD.TYPEID, SVGFormImageParser.getPositionForRadioButton(attributes, this.radioButtonFramePosition));
            } else if (FORM_COMPONENT_ID_SLIDER.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGSliderCD.TYPEID, SVGFormImageParser.getPosition(attributes));
            } else if (FORM_COMPONENT_ID_SPINNER.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGSpinnerCD.TYPEID, SVGFormImageParser.getPosition(attributes));
            } else if (FORM_COMPONENT_ID_TEXTFIELD.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGTextFieldCD.TYPEID, SVGFormImageParser.getPosition(attributes));
            }
        }

        private void addSVGFormComponent(String string, TypeID typeID, Float f) {
            int n = this.getIndex(f);
            if (n == -1) {
                this.foundElements.add(SVGFormComponent.create(string, typeID, f));
            } else {
                this.foundElements.add(n, SVGFormComponent.create(string, typeID, f));
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }

        private int getIndex(Float f) {
            int n = -1;
            if (f != null) {
                Float f2 = new Float(-1.0f);
                for (SVGFormComponent sVGFormComponent : this.foundElements) {
                    if (!(f.floatValue() > sVGFormComponent.getPositon().floatValue()) || !(f2.floatValue() < sVGFormComponent.getPositon().floatValue())) continue;
                    f2 = sVGFormComponent.getPositon();
                    n = this.foundElements.indexOf(sVGFormComponent);
                }
            }
            return n;
        }
    }

    public static abstract class SVGFormComponent {
        private String id;
        private TypeID type;
        private Float position;

        public static SVGFormComponent create(String string, final TypeID typeID, Float f) {
            return new SVGFormComponent(string, typeID, f){

                public DesignComponent createComponent(DesignComponent designComponent) {
                    DesignComponent designComponent2 = designComponent.getDocument().createComponent(typeID);
                    designComponent2.writeProperty("id", MidpTypes.createStringValue((String)this.getId()));
                    return designComponent2;
                }
            };
        }

        public static SVGFormComponent createSVGButton(String string, final TypeID typeID, Float f) {
            return new SVGFormComponent(string, typeID, f){

                public DesignComponent createComponent(DesignComponent designComponent) {
                    DesignComponent designComponent2 = designComponent.getDocument().createComponent(typeID);
                    DesignComponent designComponent3 = designComponent.getDocument().createComponent(SVGButtonEventSourceCD.TYPEID);
                    designComponent3.writeProperty("svgButton", PropertyValue.createComponentReference((DesignComponent)designComponent2));
                    designComponent.addComponent(designComponent3);
                    designComponent2.writeProperty("id", MidpTypes.createStringValue((String)this.getId()));
                    return designComponent2;
                }
            };
        }

        SVGFormComponent(String string, TypeID typeID, Float f) {
            if (typeID == null || string == null || f == null) {
                throw new IllegalArgumentException(" id or type argument is null");
            }
            this.type = typeID;
            this.id = string;
            this.position = f;
        }

        public abstract DesignComponent createComponent(DesignComponent var1);

        String getId() {
            return this.id;
        }

        TypeID getTypeID() {
            return this.type;
        }

        Float getPositon() {
            return this.position;
        }
    }
}

