/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.screen.display.ItemDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableItemDisplayPresenter
extends ItemDisplayPresenter {
    private static final int BORDER_LINE_WIDTH = 1;
    private static final int CELL_INSETS = 2;
    private static final int DOUBLE_CELL_INSETS = 4;
    private static final Stroke BORDER_STROKE = new BasicStroke(1.0f, 2, 1, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private static JLabel fontLabel = new JLabel();
    private JPanel tablePanel = new JPanel(){

        public void paint(Graphics graphics) {
            super.paint(graphics);
            TableItemDisplayPresenter.this.paintTable(graphics);
        }
    };
    private boolean hasModel;
    private boolean modelIsUserCode;
    private boolean drawBorders = true;
    private String title;
    private String[] columnNames;
    private String[][] values;

    public TableItemDisplayPresenter() {
        this.tablePanel.setOpaque(false);
        this.tablePanel.setPreferredSize(new Dimension(200, 40));
        this.setContentComponent(this.tablePanel);
    }

    private int printModelIsUserCode(Graphics graphics, int n) {
        int n2 = this.printTitle(graphics, n);
        String string = NbBundle.getMessage(TableItemDisplayPresenter.class, (String)"DISP_table_is_user_code");
        graphics.drawString(string, 2, n2 += ScreenSupport.getFontHeight((Graphics)graphics, (Font)this.getValuesFont()));
        return n2;
    }

    private int printTitle(Graphics graphics, int n) {
        int n2 = n;
        if (this.title != null) {
            graphics.setFont(this.getTitleFont());
            graphics.drawString(this.title, 2, n2 += ScreenSupport.getFontHeight((Graphics)graphics, (Font)this.getTitleFont()));
        }
        return n2;
    }

    private int printNoModel(Graphics graphics, int n) {
        int n2 = this.printTitle(graphics, n);
        String string = NbBundle.getMessage(TableItemDisplayPresenter.class, (String)"DISP_no_table_model_specified");
        graphics.drawString(string, 2, n2 += ScreenSupport.getFontHeight((Graphics)graphics, (Font)this.getValuesFont()));
        return n2;
    }

    private int printEmptyModel(Graphics graphics, int n) {
        int n2 = n + ScreenSupport.getFontHeight((Graphics)graphics, (Font)this.getValuesFont());
        String string = NbBundle.getMessage(TableItemDisplayPresenter.class, (String)"DISP_no_table_model_specified");
        graphics.drawString(string, 2, n2);
        return n2;
    }

    private Font getTitleFont() {
        return fontLabel.getFont();
    }

    private Font getHeadersFont() {
        return fontLabel.getFont().deriveFont(1);
    }

    private Font getValuesFont() {
        return fontLabel.getFont();
    }

    private void paintTable(Graphics graphics) {
        int n = 0;
        if (this.modelIsUserCode) {
            n = this.printModelIsUserCode(graphics, n);
        } else if (!this.hasModel) {
            n = this.printNoModel(graphics, n);
        } else if (this.values == null || this.values.length < 1) {
            n = this.printEmptyModel(graphics, n);
        } else {
            int n2;
            int n3;
            int n4;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.tablePanel.getSize();
            int n5 = dimension.width;
            int n6 = dimension.height;
            int n7 = 0;
            int[] nArray = this.getColWidths(graphics, this.title, this.columnNames, this.values, this.getTitleFont(), this.getHeadersFont(), this.getValuesFont());
            if (this.title != null) {
                graphics.setFont(this.getTitleFont());
                n4 = 3;
                graphics.drawString(this.title, n4, n += ScreenSupport.getFontHeight((Graphics)graphics, (Font)this.getTitleFont()));
                n7 = n += 5;
            }
            if (this.columnNames != null) {
                graphics.setFont(this.getHeadersFont());
                n7 = n;
                n += ScreenSupport.getFontHeight((Graphics)graphics, (Font)this.getHeadersFont());
                n4 = 3;
                for (n3 = 0; n3 < this.columnNames.length && n4 < n5; ++n3) {
                    String string = this.columnNames[n3];
                    if (string != null) {
                        graphics.drawString(string, n4, n);
                    }
                    if (nArray == null) continue;
                    n4 += nArray[n3];
                }
                n += 5;
            }
            if (this.values != null && this.values.length > 0) {
                graphics.setFont(this.getValuesFont());
                for (n4 = 0; n4 < this.values.length && n < n6; n += 5, ++n4) {
                    String[] stringArray = this.values[n4];
                    n += ScreenSupport.getFontHeight((Graphics)graphics, (Font)this.getValuesFont());
                    int n8 = 3;
                    for (n2 = 0; n2 < stringArray.length && n8 < n5; ++n2) {
                        String string = stringArray[n2];
                        if (string != null) {
                            graphics.drawString(string, n8, n);
                        }
                        if (nArray == null) continue;
                        n8 += nArray[n2];
                    }
                }
            }
            if (this.drawBorders) {
                graphics2D.setStroke(BORDER_STROKE);
                graphics.drawRect(0, 0, n5 - 1, n6 - 1);
                graphics.drawLine(0, n, n5, n);
                n4 = 0;
                if (this.columnNames != null) {
                    graphics.drawLine(0, n4 += ScreenSupport.getFontHeight((Graphics)graphics, (Font)this.getHeadersFont()) + 4, n5, n4);
                    ++n4;
                }
                if (this.values != null && this.values.length > 0) {
                    for (n3 = 0; n3 < this.values.length && n4 < n6; ++n4, ++n3) {
                        graphics.drawLine(0, n4 += ScreenSupport.getFontHeight((Graphics)graphics, (Font)this.getValuesFont()) + 4, n5, n4);
                    }
                    n3 = 0;
                    int n9 = this.values[0].length;
                    for (n2 = 0; n2 < n9 && n3 < n5; n3 += nArray[n2], ++n2) {
                        graphics.drawLine(n3, n7, n3, n6 - 1);
                    }
                }
            }
        }
    }

    public void reload(ScreenDeviceInfo screenDeviceInfo) {
        super.reload(screenDeviceInfo);
        PropertyValue propertyValue = this.getComponent().readProperty("title");
        this.title = PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind()) ? NbBundle.getMessage(TableItemDisplayPresenter.class, (String)"DISP_title_is_user_code") : MidpTypes.getString((PropertyValue)propertyValue);
        propertyValue = this.getComponent().readProperty("model");
        this.modelIsUserCode = PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind());
        if (!this.modelIsUserCode) {
            DesignComponent designComponent = propertyValue.getComponent();
            boolean bl = this.hasModel = designComponent != null;
            if (this.hasModel) {
                PropertyValue propertyValue2;
                PropertyValue propertyValue3;
                List list;
                propertyValue = this.getComponent().readProperty("borders");
                if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
                    this.drawBorders = MidpTypes.getBoolean((PropertyValue)propertyValue);
                }
                if ((list = (propertyValue3 = designComponent.readProperty("columnNames")).getArray()) != null) {
                    this.columnNames = new String[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        this.columnNames[i] = MidpTypes.getString((PropertyValue)((PropertyValue)list.get(i)));
                    }
                } else {
                    this.columnNames = null;
                }
                if ((list = (propertyValue2 = designComponent.readProperty("values")).getArray()) != null) {
                    this.values = new String[list.size()][];
                    for (int i = 0; i < list.size(); ++i) {
                        List<String> list2 = TableItemDisplayPresenter.gatherStringValues(((PropertyValue)list.get(i)).getArray());
                        this.values[i] = list2.toArray(new String[list2.size()]);
                    }
                } else {
                    this.values = null;
                }
            }
        } else {
            this.hasModel = false;
        }
        this.tablePanel.setPreferredSize(this.calculatePrefferedSize());
        this.tablePanel.repaint();
    }

    private Dimension calculatePrefferedSize() {
        Dimension dimension = this.tablePanel.getPreferredSize();
        int n = 0;
        if (this.title != null) {
            n += 4 + this.getTitleFont().getSize() + 1;
        }
        if (this.isMessageNoTable()) {
            n += 4 + this.getValuesFont().getSize();
        } else {
            if (this.columnNames != null) {
                n += 2 + this.getHeadersFont().getSize() + 1;
            }
            if (this.values != null) {
                n += (4 + this.getValuesFont().getSize() + 1) * this.values.length;
            }
        }
        return new Dimension(dimension.width, n);
    }

    private boolean isMessageNoTable() {
        return this.modelIsUserCode || !this.hasModel || this.values == null || this.values.length < 1;
    }

    private static List<String> gatherStringValues(List<PropertyValue> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (PropertyValue propertyValue : list) {
            arrayList.add(MidpTypes.getString((PropertyValue)propertyValue));
        }
        return arrayList;
    }

    private int[] getColWidths(Graphics graphics, String string, String[] stringArray, String[][] stringArray2, Font font, Font font2, Font font3) {
        if (stringArray2 == null || stringArray2.length == 0) {
            return null;
        }
        int n = stringArray2[0].length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.tablePanel.getSize().width / n;
        }
        return nArray;
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ArrayList<ScreenPropertyDescriptor> arrayList = new ArrayList<ScreenPropertyDescriptor>(super.getPropertyDescriptors());
        PropertyValue propertyValue = this.getComponent().readProperty("model");
        DesignComponent designComponent = null;
        if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
            designComponent = propertyValue.getComponent();
        }
        ResourcePropertyEditor resourcePropertyEditor = null;
        resourcePropertyEditor = designComponent == null ? new ResourcePropertyEditor("model", this.getComponent()) : new ResourcePropertyEditor("values", designComponent);
        arrayList.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.tablePanel, (ScreenPropertyEditor)resourcePropertyEditor));
        return arrayList;
    }
}

