/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ui.XAMUtils;
import org.netbeans.modules.xml.xam.ui.actions.GotoType;
import org.netbeans.modules.xml.xam.ui.cookies.GotoCookie;
import org.netbeans.modules.xml.xam.ui.cookies.ViewComponentCookie;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class GoToAction
extends CookieAction {
    private static final long serialVersionUID = 1L;
    private ActSubMenuModel model = new ActSubMenuModel(null);

    public String getName() {
        return this.model.createName();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] nodeArray) {
        this.model.performActionAt(0);
    }

    public JMenuItem getMenuPresenter() {
        return new Actions.SubMenu((SystemAction)this, (Actions.SubMenuModel)this.model, false);
    }

    public JMenuItem getPopupPresenter() {
        return new Actions.SubMenu((SystemAction)this, (Actions.SubMenuModel)this.model, true);
    }

    protected int mode() {
        return 8;
    }

    protected Class[] cookieClasses() {
        return new Class[]{GotoCookie.class};
    }

    protected boolean asynchronous() {
        return false;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new DelegateAction(this, lookup);
    }

    private static GotoType[] getGotoTypes(Node[] nodeArray) {
        Node node;
        GotoCookie gotoCookie;
        ArrayList<GotoType> arrayList = new ArrayList<GotoType>();
        if (nodeArray != null && nodeArray.length == 1 && (gotoCookie = (GotoCookie)(node = nodeArray[0]).getCookie(GotoCookie.class)) != null) {
            for (GotoType gotoType : gotoCookie.getGotoTypes()) {
                ViewComponentCookie.View view;
                Component component = gotoType.getComponent(node);
                if (XAMUtils.getViewCookie(component, view = gotoType.getView()) == null) continue;
                arrayList.add(gotoType);
            }
        }
        return arrayList.toArray(new GotoType[arrayList.size()]);
    }

    private final class DelegateAction
    implements Action,
    Presenter.Menu,
    Presenter.Popup {
        private final CookieAction delegate;
        private final ActSubMenuModel model;

        public DelegateAction(CookieAction cookieAction, Lookup lookup) {
            this.delegate = cookieAction;
            this.model = new ActSubMenuModel(lookup);
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.model.performActionAt(0);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void putValue(String string, Object object) {
        }

        public Object getValue(String string) {
            if ("Name".equals(string)) {
                return this.model.createName();
            }
            return this.delegate.getValue(string);
        }

        public boolean isEnabled() {
            return this.model.getCount() > 0;
        }

        public void setEnabled(boolean bl) {
        }

        public JMenuItem getMenuPresenter() {
            return new Actions.SubMenu((Action)this, (Actions.SubMenuModel)this.model, false);
        }

        public JMenuItem getPopupPresenter() {
            return new Actions.SubMenu((Action)this, (Actions.SubMenuModel)this.model, true);
        }
    }

    private class ActSubMenuModel
    extends EventListenerList
    implements Actions.SubMenuModel {
        static final long serialVersionUID = -4273674308662494596L;
        private transient Lookup lookup;

        ActSubMenuModel(Lookup lookup) {
            this.lookup = lookup;
        }

        private Node[] nodes() {
            return WindowManager.getDefault().getRegistry().getCurrentNodes();
        }

        private String createName() {
            GotoType[] gotoTypeArray = GoToAction.getGotoTypes(this.nodes());
            if (gotoTypeArray != null && gotoTypeArray.length == 1) {
                return NbBundle.getMessage(GoToAction.class, (String)"LBL_GoTo_Name", (Object)gotoTypeArray[0].getName());
            }
            return NbBundle.getMessage(GoToAction.class, (String)"LBL_GoTo");
        }

        public int getCount() {
            return this.nodes() == null ? 0 : GoToAction.getGotoTypes(this.nodes()).length;
        }

        public String getLabel(int n) {
            GotoType[] gotoTypeArray = GoToAction.getGotoTypes(this.nodes());
            if (gotoTypeArray == null || gotoTypeArray.length <= n) {
                return null;
            }
            return gotoTypeArray[n].getName();
        }

        public HelpCtx getHelpCtx(int n) {
            GotoType[] gotoTypeArray = GoToAction.getGotoTypes(this.nodes());
            if (gotoTypeArray == null || gotoTypeArray.length <= n) {
                return null;
            }
            return gotoTypeArray[n].getHelpCtx();
        }

        public void performActionAt(int n) {
            Node[] nodeArray = this.nodes();
            GotoType[] gotoTypeArray = GoToAction.getGotoTypes(nodeArray);
            if (gotoTypeArray != null && gotoTypeArray.length > n) {
                gotoTypeArray[n].show(nodeArray[0]);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.add(ChangeListener.class, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.remove(ChangeListener.class, changeListener);
        }
    }
}

