/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.column;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import org.netbeans.modules.xml.xam.ui.column.Column;
import org.netbeans.modules.xml.xam.ui.column.ColumnView;
import org.netbeans.modules.xml.xam.ui.layout.JSplitterBar;
import org.netbeans.modules.xml.xam.ui.layout.SplitterLayout;

public class BasicColumnView
extends JPanel
implements ColumnView {
    private static final String COLUMN_WEIGHT_1 = "1";
    private static final int SCROLL_DELAY = 20;
    static final long serialVersionUID = 1L;
    private List<Column> columnList;
    private List<JSplitterBar> splitterList;
    private JPanel mainParentPanel;
    private JScrollPane scrollPane;

    public BasicColumnView() {
        this.initComponents();
        this.columnList = new ArrayList<Column>();
        this.splitterList = new ArrayList<JSplitterBar>();
        this.mainParentPanel = new MainPanel();
        this.mainParentPanel.setBackground(Color.WHITE);
        this.mainParentPanel.setLayout(new SplitterLayout(false));
        this.scrollPane.setViewportView(this.mainParentPanel);
        this.scrollPane.setViewportBorder(null);
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                super.componentResized(componentEvent);
                BasicColumnView.this.validate();
                BasicColumnView.this.revalidate();
            }
        });
    }

    protected void appendColumnToList(Column column) {
        if (column == null) {
            return;
        }
        JComponent jComponent = column.getComponent();
        if (jComponent == null) {
            return;
        }
        this.columnList.add(column);
        this.mainParentPanel.add(COLUMN_WEIGHT_1, jComponent);
        JSplitterBar jSplitterBar = new JSplitterBar();
        this.mainParentPanel.add(jSplitterBar);
        this.splitterList.add(jSplitterBar);
    }

    public void appendColumn(Column column) {
        this.appendColumnToList(column);
        this.validate();
        this.mainParentPanel.revalidate();
        this.scrollToColumn(column, false);
    }

    public void appendColumns(Column[] columnArray) {
        for (Column column : columnArray) {
            this.appendColumnToList(column);
        }
        this.validate();
        this.mainParentPanel.revalidate();
        this.scrollToColumn(columnArray[columnArray.length - 1], false);
    }

    public void clearColumns() {
        this.mainParentPanel.removeAll();
        this.columnList.clear();
        this.splitterList.clear();
        this.mainParentPanel.revalidate();
        this.mainParentPanel.repaint();
    }

    public void removeColumnsAfter(Column column) {
        Object object;
        int n;
        if (column == null) {
            return;
        }
        if (!this.isLastColumn(column)) {
            this.scrollToColumn(this.getNextColumn(column), true);
        }
        int n2 = this.columnList.indexOf(column);
        for (n = this.columnList.size() - 1; n > n2; --n) {
            object = this.columnList.remove(n);
            JComponent jComponent = object.getComponent();
            this.mainParentPanel.remove(jComponent);
        }
        for (n = this.splitterList.size() - 1; n > n2; --n) {
            object = this.splitterList.remove(n);
            this.mainParentPanel.remove((Component)object);
        }
        this.mainParentPanel.revalidate();
        this.mainParentPanel.repaint();
    }

    public void scrollToColumn(final Column column, boolean bl) {
        if (column == null) {
            return;
        }
        if (bl) {
            if (!EventQueue.isDispatchThread()) {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            BasicColumnView.this.scrollToColumn(column);
                        }
                    });
                }
                catch (Exception exception) {
                    return;
                }
            } else {
                this.scrollToColumn(column);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    BasicColumnView.this.scrollToColumn(column);
                }
            });
        }
    }

    protected void scrollToColumn(Column column) {
        int n;
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("This method can only be invoked on the AWT event processing thread");
        }
        int n2 = this.columnList.indexOf(column);
        if (n2 == -1 || this.columnList.size() <= 1 || this.columnList.size() - 2 == n2) {
            return;
        }
        Rectangle rectangle = column.getComponent().getBounds();
        rectangle.width += 5;
        JViewport jViewport = this.scrollPane.getViewport();
        Rectangle rectangle2 = jViewport.getViewRect();
        int n3 = (int)(rectangle2.getX() + rectangle2.getWidth() - (rectangle.getX() + rectangle.getWidth()));
        if (n3 == 0) {
            return;
        }
        int n4 = Math.abs(this.lastShowingColumnIndex() - n2);
        Point point = jViewport.getViewPosition();
        int n5 = 5 * (n4 == 0 ? 1 : n4);
        int n6 = n3 / n5;
        for (int i = 0; i < n5 && (n = (int)point.getX() - n6) > 0; ++i) {
            point = new Point(++n, (int)point.getY());
            jViewport.setViewPosition(point);
        }
    }

    protected boolean isLastColumn(Column column) {
        if (column == null) {
            return false;
        }
        return this.columnList.indexOf(column) == this.columnList.size() - 1;
    }

    public int getColumnCount() {
        return this.columnList.size();
    }

    public Column getFirstColumn() {
        if (this.columnList.size() > 0) {
            return this.columnList.get(0);
        }
        return null;
    }

    public Column getNextColumn(Column column) {
        if (column == null) {
            return null;
        }
        if (this.isLastColumn(column)) {
            return null;
        }
        return this.columnList.get(this.columnList.indexOf(column) + 1);
    }

    public void requestFocus() {
        super.requestFocus();
        int n = this.lastShowingColumnIndex();
        if (n > -1) {
            Column column = this.columnList.get(n);
            column.getComponent().requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        int n = this.lastShowingColumnIndex();
        if (n > -1) {
            Column column = this.columnList.get(n);
            return column.getComponent().requestFocusInWindow();
        }
        return bl;
    }

    private int lastShowingColumnIndex() {
        int n = -1;
        for (int i = this.columnList.size() - 1; i > -1; --i) {
            if (!this.columnList.get(i).getComponent().isShowing()) continue;
            n = i;
            break;
        }
        return n;
    }

    private int locationToIndex(Point point, int n) {
        int n2;
        block2: {
            Component component;
            block1: {
                n2 = -1;
                component = this.mainParentPanel.getComponentAt(point);
                if (!(component instanceof JSplitterBar)) break block1;
                n2 = this.splitterList.indexOf(component);
                if (n <= 0) break block2;
                ++n2;
                break block2;
            }
            Component[] componentArray = this.mainParentPanel.getComponents();
            for (int i = 0; i < componentArray.length; i += 2) {
                if (componentArray[i] != component) continue;
                n2 = i / 2;
                break;
            }
        }
        return n2;
    }

    public int getColumnIndex(Column column) {
        return this.columnList.indexOf(column);
    }

    public void addNotify() {
        super.addNotify();
        Container container = this.getParent();
        assert (!(container instanceof JViewport)) : "BasicColumnView has its own scrollpane. Do not place BasicColumnView in a scrollpane.";
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.scrollPane.setBackground(Color.white);
        this.scrollPane.setBorder(null);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.add((Component)this.scrollPane, "Center");
    }

    private class MainPanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 1L;

        private MainPanel() {
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            int n3 = rectangle.width;
            if (n2 > 0) {
                Column column;
                Rectangle rectangle2;
                int n4 = BasicColumnView.this.locationToIndex(new Point(rectangle.x + rectangle.width - 1, rectangle.y), n2);
                if (n4 >= 0 && n4 < BasicColumnView.this.columnList.size() && (rectangle2 = (column = (Column)BasicColumnView.this.columnList.get(n4)).getComponent().getBounds()) != null) {
                    n3 = rectangle2.x - rectangle.x;
                    if (n3 < 0) {
                        n3 += rectangle2.width;
                    } else if (n3 == 0 && n4 < BasicColumnView.this.columnList.size() - 1) {
                        n3 = rectangle2.width;
                    }
                }
            } else {
                Column column;
                Rectangle rectangle3;
                int n5 = BasicColumnView.this.locationToIndex(new Point(rectangle.x - rectangle.width, rectangle.y), n2);
                if (n5 >= 0 && n5 < BasicColumnView.this.columnList.size() && (rectangle3 = (column = (Column)BasicColumnView.this.columnList.get(n5)).getComponent().getBounds()) != null) {
                    n3 = rectangle3.x < rectangle.x - rectangle.width ? (rectangle3.x + rectangle3.width >= rectangle.x ? rectangle.x - rectangle3.x : rectangle.x - rectangle3.x - rectangle3.width) : rectangle.x - rectangle3.x;
                }
            }
            return n3;
        }

        public boolean getScrollableTracksViewportHeight() {
            return true;
        }

        public boolean getScrollableTracksViewportWidth() {
            if (this.getParent() instanceof JViewport) {
                return this.getParent().getWidth() > this.getPreferredSize().width;
            }
            return false;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            Column column;
            Rectangle rectangle2;
            int n3 = BasicColumnView.this.locationToIndex(rectangle.getLocation(), n2);
            if (n3 >= 0 && n3 < BasicColumnView.this.columnList.size() && (rectangle2 = (column = (Column)BasicColumnView.this.columnList.get(n3)).getComponent().getBounds()) != null) {
                if (rectangle2.x != rectangle.x) {
                    if (n2 < 0) {
                        return Math.abs(rectangle2.x - rectangle.x);
                    }
                    return rectangle2.width + rectangle2.x - rectangle.x;
                }
                JSplitterBar jSplitterBar = (JSplitterBar)BasicColumnView.this.splitterList.get(0);
                return rectangle2.width + jSplitterBar.getWidth();
            }
            return 1;
        }
    }
}

