/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.List;
import org.jruby.nb.ast.ArgsCatNode;
import org.jruby.nb.ast.ArgsNode;
import org.jruby.nb.ast.ArgumentNode;
import org.jruby.nb.ast.ArrayNode;
import org.jruby.nb.ast.CallNode;
import org.jruby.nb.ast.DefnNode;
import org.jruby.nb.ast.DefsNode;
import org.jruby.nb.ast.FCallNode;
import org.jruby.nb.ast.ListNode;
import org.jruby.nb.ast.LocalAsgnNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.SplatNode;
import org.jruby.nb.ast.VCallNode;
import org.netbeans.modules.ruby.AstUtilities;

public final class Arity {
    public static final Arity UNKNOWN = new Arity(-1, -1);
    private int min;
    private int max;

    private Arity(int n, int n2) {
        this.min = n;
        this.max = n2;
    }

    public int getMinArgs() {
        return this.min;
    }

    public int getMaxArgs() {
        return this.max;
    }

    public static Arity getCallArity(Node node) {
        assert (node instanceof CallNode || node instanceof VCallNode || node instanceof FCallNode);
        Arity arity = new Arity(0, 0);
        arity.initializeFromCall(node);
        if (arity.min == -1) {
            return UNKNOWN;
        }
        return arity;
    }

    public static boolean callHasArguments(Node node) {
        assert (node instanceof CallNode || node instanceof VCallNode || node instanceof FCallNode);
        return Arity.getCallArity((Node)node).min > 0;
    }

    private void initializeFromCall(Node node) {
        if (node instanceof FCallNode) {
            Node node2 = ((FCallNode)node).getArgsNode();
            if (node2 == null) {
                return;
            }
            this.initializeFromCall(node2);
        } else if (node instanceof LocalAsgnNode) {
            if (this.max < Integer.MAX_VALUE) {
                ++this.max;
            }
        } else if (node instanceof ArgsCatNode) {
            ArgsCatNode argsCatNode = (ArgsCatNode)node;
            this.initializeFromCall(argsCatNode.getFirstNode());
            this.max = Integer.MAX_VALUE;
        } else if (node instanceof ArgsNode) {
            ArgsNode argsNode = (ArgsNode)node;
            if (argsNode != null) {
                int n = argsNode.getArity().getValue();
                if (n < 0) {
                    n = -(1 + n);
                }
                this.min = this.max = n;
            }
        } else if (node instanceof SplatNode) {
            this.max = Integer.MAX_VALUE;
        } else if (node instanceof CallNode) {
            Node node3 = ((CallNode)node).getArgsNode();
            if (node3 == null) {
                return;
            }
            this.initializeFromCall(node3);
        } else if (node instanceof VCallNode) {
            List list = node.childNodes();
            for (Node node4 : list) {
                if (node4.isInvisible()) continue;
                this.initializeFromCall(node4);
            }
        } else if (node instanceof ListNode) {
            List list = node.childNodes();
            for (Node node5 : list) {
                if (node5.isInvisible()) continue;
                if (AstUtilities.isCall(node5)) {
                    ++this.min;
                    this.max = Integer.MAX_VALUE;
                    continue;
                }
                if (node5 instanceof ArrayNode) {
                    ++this.min;
                    if (this.max >= Integer.MAX_VALUE) continue;
                    ++this.max;
                    continue;
                }
                this.initializeFromCall(node5);
            }
        } else {
            ++this.min;
            if (this.max < Integer.MAX_VALUE) {
                ++this.max;
            }
        }
    }

    public static Arity getDefArity(Node node) {
        assert (node instanceof DefsNode || node instanceof DefnNode);
        Arity arity = new Arity(0, 0);
        List list = node.childNodes();
        for (Node node2 : list) {
            if (!(node2 instanceof ArgsNode)) continue;
            arity.initializeFromDef(node2);
            break;
        }
        if (arity.min == -1) {
            return UNKNOWN;
        }
        return arity;
    }

    private void initializeFromDef(Node node) {
        if (node instanceof ArgsNode) {
            ArgsNode argsNode = (ArgsNode)node;
            if (argsNode.getArgs() != null) {
                this.initializeFromDef((Node)argsNode.getArgs());
            }
            if (argsNode.getOptArgs() != null) {
                this.initializeFromDef((Node)argsNode.getOptArgs());
            }
            if (argsNode.getBlockArgNode() != null && this.max < Integer.MAX_VALUE) {
                ++this.max;
            }
            if (argsNode.getRestArg() > 0) {
                this.max = Integer.MAX_VALUE;
            }
        } else if (node instanceof ArgumentNode) {
            ++this.min;
            ++this.max;
        } else if (node instanceof LocalAsgnNode) {
            ++this.max;
        } else if (node instanceof ListNode) {
            List list = node.childNodes();
            for (Node node2 : list) {
                if (node2.isInvisible()) continue;
                this.initializeFromDef(node2);
            }
        }
    }

    public static boolean matches(Arity arity, Arity arity2) {
        if (arity == UNKNOWN || arity2 == UNKNOWN) {
            return true;
        }
        if (arity.max < arity2.min) {
            return false;
        }
        if (arity.max == Integer.MAX_VALUE) {
            return true;
        }
        return arity.max <= arity2.max;
    }

    public String toString() {
        return "Arity(" + this.min + ":" + (this.max == Integer.MAX_VALUE ? "unlimited" : Integer.valueOf(this.max)) + ")";
    }

    public static Arity createTestArity(int n, int n2) {
        return new Arity(n, n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Arity arity = (Arity)object;
        if (this.min != arity.min) {
            return false;
        }
        return this.max == arity.max;
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + this.min;
        n = 31 * n + this.max;
        return n;
    }
}

