/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.elements;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.SymbolNode;
import org.jruby.nb.ast.types.INameNode;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.ruby.elements.AstAttributeElement;
import org.netbeans.modules.ruby.elements.AstClassElement;
import org.netbeans.modules.ruby.elements.AstFieldElement;
import org.netbeans.modules.ruby.elements.AstMethodElement;
import org.netbeans.modules.ruby.elements.AstModuleElement;
import org.netbeans.modules.ruby.elements.AstNameElement;
import org.netbeans.modules.ruby.elements.RubyElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstElement
extends RubyElement {
    protected Node node;
    protected CompilationInfo info;
    protected ArrayList<AstElement> children;
    protected String name;
    private String in;
    protected Set<Modifier> modifiers;

    public AstElement(CompilationInfo compilationInfo, Node node) {
        this.info = compilationInfo;
        this.node = node;
    }

    public String getFqn() {
        return this.name;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public abstract String getName();

    public String getDisplayName() {
        return this.getName();
    }

    public String getDescription() {
        return this.getName();
    }

    public List<AstElement> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public void addChild(AstElement astElement) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(astElement);
    }

    public static AstElement create(CompilationInfo compilationInfo, Node node) {
        switch (node.nodeId) {
            case DEFNNODE: 
            case DEFSNODE: {
                return new AstMethodElement(compilationInfo, node);
            }
            case CLASSNODE: 
            case SCLASSNODE: {
                return new AstClassElement(compilationInfo, node);
            }
            case MODULENODE: {
                return new AstModuleElement(compilationInfo, node);
            }
            case CONSTNODE: {
                return new AstNameElement(compilationInfo, node, ((INameNode)node).getName(), ElementKind.VARIABLE);
            }
            case CLASSVARNODE: 
            case CLASSVARDECLNODE: 
            case INSTASGNNODE: 
            case INSTVARNODE: {
                return new AstFieldElement(compilationInfo, node);
            }
            case CONSTDECLNODE: {
                return new AstNameElement(compilationInfo, node, ((INameNode)node).getName(), ElementKind.CONSTANT);
            }
            case SYMBOLNODE: {
                return new AstAttributeElement(compilationInfo, (SymbolNode)node, null);
            }
        }
        return null;
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(0, string.lastIndexOf(46)) + ":" + this.node.toString();
    }

    public Image getIcon() {
        return null;
    }

    @Override
    public String getIn() {
        return this.in;
    }

    public void setIn(String string) {
        this.in = string;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.OTHER;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public CompilationInfo getInfo() {
        return this.info;
    }
}

