/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.elements;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.spi.DefaultParserFile;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.elements.RubyElement;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexedElement
extends RubyElement {
    public static final int DOCUMENTED = 1;
    public static final int PROTECTED = 2;
    public static final int PRIVATE = 4;
    public static final int TOPLEVEL = 8;
    public static final int STATIC = 16;
    public static final int NODOC = 32;
    protected String fileUrl;
    protected final String clz;
    protected final String fqn;
    protected final RubyIndex index;
    protected final String require;
    protected final String attributes;
    protected Set<Modifier> modifiers;
    protected int flags;
    protected int docLength = -1;
    private Document document;
    private FileObject fileObject;
    private FileObject context;

    protected IndexedElement(RubyIndex rubyIndex, String string, String string2, String string3, String string4, String string5, int n, FileObject fileObject) {
        this.index = rubyIndex;
        this.fileUrl = string;
        this.fqn = string2;
        this.require = string4;
        this.attributes = string5;
        this.clz = string3;
        this.flags = n;
        this.context = fileObject;
    }

    public abstract String getSignature();

    public final String getFileUrl() {
        return this.fileUrl;
    }

    public final String getRequire() {
        return this.require;
    }

    public final String getFqn() {
        return this.fqn;
    }

    public String toString() {
        return this.getSignature() + ":" + this.getFileUrl();
    }

    public final String getClz() {
        return this.clz;
    }

    public RubyIndex getIndex() {
        return this.index;
    }

    @Override
    public String getIn() {
        return this.getClz();
    }

    public String getFilenameUrl() {
        return this.fileUrl;
    }

    public Document getDocument() {
        if (this.document == null) {
            FileObject fileObject = this.getFileObject();
            if (fileObject == null) {
                return null;
            }
            this.document = GsfUtilities.getDocument((FileObject)this.fileObject, (boolean)true);
        }
        return this.document;
    }

    public ParserFile getFile() {
        boolean bl = false;
        return new DefaultParserFile(this.getFileObject(), null, bl);
    }

    @Override
    public FileObject getFileObject() {
        if (this.fileObject == null && this.fileUrl != null) {
            this.fileObject = RubyIndex.getFileObject(this.fileUrl, this.context);
            if (this.fileObject == null) {
                this.fileUrl = null;
            }
        }
        return this.fileObject;
    }

    @Override
    public final Set<Modifier> getModifiers() {
        if (this.modifiers == null) {
            Modifier modifier = Modifier.PUBLIC;
            if (this.isPrivate()) {
                modifier = Modifier.PRIVATE;
            } else if (this.isProtected()) {
                modifier = Modifier.PROTECTED;
            }
            boolean bl = this.isStatic();
            this.modifiers = modifier != Modifier.PUBLIC ? (bl ? EnumSet.of(modifier, Modifier.STATIC) : EnumSet.of(modifier)) : (bl ? EnumSet.of(Modifier.STATIC) : Collections.emptySet());
        }
        return this.modifiers;
    }

    public int getDocumentationLength() {
        return this.isDocumented() ? 1 : 0;
    }

    public static char flagToFirstChar(int n) {
        char c = (char)(n >>= 4);
        if (c >= '\n') {
            return (char)(c - 10 + 97);
        }
        return (char)(c + 48);
    }

    public static char flagToSecondChar(int n) {
        char c = (char)(n & 0xF);
        if (c >= '\n') {
            return (char)(c - 10 + 97);
        }
        return (char)(c + 48);
    }

    public static String flagToString(int n) {
        return "" + IndexedElement.flagToFirstChar(n) + IndexedElement.flagToSecondChar(n);
    }

    public static int stringToFlag(String string, int n) {
        return IndexedElement.stringToFlag(string.charAt(n), string.charAt(n + 1));
    }

    public static int stringToFlag(char c, char c2) {
        int n = 0;
        int n2 = 0;
        n = c > '9' ? c - 97 + 10 : c - 48;
        n2 = c2 > '9' ? c2 - 97 + 10 : c2 - 48;
        return (n << 4) + n2;
    }

    public boolean isDocumented() {
        return (this.flags & 1) != 0;
    }

    public boolean isPublic() {
        return (this.flags & 4 & 2) == 0;
    }

    public boolean isPrivate() {
        return (this.flags & 4) != 0 || (this.flags & 2) != 0;
    }

    public boolean isProtected() {
        return (this.flags & 2) != 0;
    }

    public boolean isTopLevel() {
        return (this.flags & 8) != 0;
    }

    public boolean isStatic() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isNoDoc() {
        return (this.flags & 0x20) != 0;
    }

    public static String decodeFlags(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 1) != 0) {
            stringBuilder.append("|DOCUMENTED");
        }
        if ((n & 4) != 0) {
            stringBuilder.append("|PRIVATE");
        }
        if ((n & 2) != 0) {
            stringBuilder.append("|PROTECTED");
        }
        if ((n & 8) != 0) {
            stringBuilder.append("|TOPLEVEL");
        }
        if ((n & 0x10) != 0) {
            stringBuilder.append("|STATIC");
        }
        if ((n & 0x20) != 0) {
            stringBuilder.append("|NODOC");
        }
        return stringBuilder.toString();
    }

    public static int stringToFlags(String string) {
        int n = 0;
        if (string.indexOf("|DOCUMENTED") != -1) {
            ++n;
        }
        if (string.indexOf("|PRIVATE") != -1) {
            n += 4;
        }
        if (string.indexOf("|PROTECTED") != -1) {
            n += 2;
        }
        if (string.indexOf("|TOPLEVEL") != -1) {
            n += 8;
        }
        if (string.indexOf("|STATIC") != -1) {
            n += 16;
        }
        if (string.indexOf("|NODOC") != -1) {
            n += 32;
        }
        return n;
    }

    public boolean doesBelongToModule() {
        return "Module".equals(this.getFqn());
    }
}

