/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.MethodElement;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexedMethod
extends IndexedElement
implements MethodElement {
    public static final int BLOCK = 64;
    public static final int BLOCK_OPTIONAL = 128;
    protected final String signature;
    private String[] args;
    private String name;
    private List<String> parameters;
    private boolean smart;
    private boolean inherited;
    private MethodType methodType = MethodType.METHOD;

    private IndexedMethod(String string, RubyIndex rubyIndex, String string2, String string3, String string4, String string5, String string6, int n, FileObject fileObject) {
        super(rubyIndex, string2, string3, string4, string5, string6, n, fileObject);
        this.signature = string;
    }

    public static IndexedMethod create(RubyIndex rubyIndex, String string, String string2, String string3, String string4, String string5, String string6, int n, FileObject fileObject) {
        IndexedMethod indexedMethod = new IndexedMethod(string, rubyIndex, string4, string2, string3, string5, string6, n, fileObject);
        return indexedMethod;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public void setMethodType(MethodType methodType) {
        this.methodType = methodType;
    }

    @Override
    public String toString() {
        return this.getSignature();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            int n = this.signature.indexOf(40);
            this.name = n == -1 ? this.signature : this.signature.substring(0, n);
        }
        return this.name;
    }

    @Override
    public String getSignature() {
        return this.fqn + "#" + this.signature;
    }

    public String[] getArgs() {
        if (this.args == null) {
            int n = this.signature.indexOf(40);
            if (n == -1) {
                return new String[0];
            }
            String string = this.signature.substring(n + 1, this.signature.length() - 1);
            this.args = string.split(",");
        }
        return this.args;
    }

    @Override
    public List<String> getParameters() {
        if (this.parameters == null) {
            String[] stringArray = this.getArgs();
            if (stringArray != null && stringArray.length > 0) {
                this.parameters = new ArrayList<String>(stringArray.length);
                for (String string : stringArray) {
                    this.parameters.add(string);
                }
            } else {
                this.parameters = Collections.emptyList();
            }
        }
        return this.parameters;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public ElementKind getKind() {
        if (this.name == null && this.signature.startsWith("initialize(") || this.name != null && this.name.equals("initialize")) {
            return ElementKind.CONSTRUCTOR;
        }
        return ElementKind.METHOD;
    }

    public boolean isSmart() {
        return this.smart;
    }

    public void setSmart(boolean bl) {
        this.smart = bl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IndexedMethod indexedMethod = (IndexedMethod)object;
        if (!(this.signature == indexedMethod.signature || this.signature != null && this.signature.equals(indexedMethod.signature))) {
            return false;
        }
        if (!(this.fqn == indexedMethod.fqn || this.fqn != null && this.fqn.equals(indexedMethod.fqn))) {
            return false;
        }
        return this.flags == indexedMethod.flags;
    }

    public int hashCode() {
        int n = 7;
        n = 53 * n + (this.signature != null ? this.signature.hashCode() : 0);
        n = 53 * n + (this.fqn != null ? this.fqn.hashCode() : 0);
        n = 53 * n + this.flags;
        return n;
    }

    @Override
    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean bl) {
        this.inherited = bl;
    }

    public boolean hasBlock() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isBlockOptional() {
        return (this.flags & 0x80) != 0;
    }

    public static String decodeFlags(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(IndexedElement.decodeFlags(n));
        if ((n & 0x40) != 0) {
            stringBuilder.append("|BLOCK");
        }
        if ((n & 0x80) != 0) {
            stringBuilder.append("|BLOCK_OPTIONAL");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("|");
        }
        return stringBuilder.toString();
    }

    public static int stringToFlags(String string) {
        int n = IndexedElement.stringToFlags(string);
        int n2 = string.indexOf("|BLOCK_OPTIONAL");
        if (n2 != -1) {
            n += 128;
            if (string.indexOf("|BLOCK") != n2 || string.lastIndexOf("|BLOCK") != n2) {
                n += 64;
            }
        } else if (string.indexOf("|BLOCK") != -1) {
            n += 64;
        }
        return n;
    }

    public String getEncodedAttributes() {
        return this.attributes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodType {
        METHOD,
        ATTRIBUTE,
        DBCOLUMN;

    }
}

