/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.folding;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.xml.text.folding.TokenElement;
import org.netbeans.modules.xml.text.folding.XmlFoldTypes;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlFoldManager
implements FoldManager {
    private FoldOperation operation;
    private long dirtyTimeMillis = 0L;
    private Timer timer;
    private TimerTask timerTask;
    public static final int DELAY_SYNCER = 2000;
    public static final int DELAY_DIRTY = 1000;

    public void init(FoldOperation foldOperation) {
        this.operation = foldOperation;
    }

    public void release() {
        this.releaseTimerTask();
        this.timer = null;
    }

    protected FoldOperation getOperation() {
        return this.operation;
    }

    public void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    private BaseDocument getDocument() {
        return (BaseDocument)this.getOperation().getHierarchy().getComponent().getDocument();
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.scheduleFoldUpdate();
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.scheduleFoldUpdate();
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.scheduleFoldUpdate();
    }

    public void removeEmptyNotify(Fold fold) {
    }

    public void removeDamagedNotify(Fold fold) {
    }

    public void expandNotify(Fold fold) {
    }

    private void scheduleFoldUpdate() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        this.dirtyTimeMillis = System.currentTimeMillis();
        this.releaseTimerTask();
        this.timerTask = new TimerTask(){

            public void run() {
                if (XmlFoldManager.this.dirtyIntervalMillis() > 1000L) {
                    XmlFoldManager.this.updateFolds();
                    XmlFoldManager.this.unsetDirty();
                }
            }
        };
        this.timer.schedule(this.timerTask, 2000L);
    }

    private void releaseTimerTask() {
        if (this.timerTask == null) {
            return;
        }
        this.timerTask.cancel();
        this.timerTask = null;
    }

    public void unsetDirty() {
        this.dirtyTimeMillis = 0L;
        this.timer.cancel();
        this.timer = null;
    }

    private long dirtyIntervalMillis() {
        if (this.dirtyTimeMillis == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.dirtyTimeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void updateFolds() {
        FoldHierarchy foldHierarchy = this.getOperation().getHierarchy();
        this.getDocument().readLock();
        try {
            foldHierarchy.lock();
            try {
                FoldHierarchyTransaction foldHierarchyTransaction = this.getOperation().openTransaction();
                try {
                    ArrayList<Fold> arrayList = new ArrayList<Fold>();
                    this.collectExistingFolds(foldHierarchy.getRootFold(), arrayList);
                    for (Fold fold : arrayList) {
                        this.getOperation().removeFromHierarchy(fold, foldHierarchyTransaction);
                    }
                    this.createFolds(foldHierarchyTransaction);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
                finally {
                    foldHierarchyTransaction.commit();
                }
            }
            finally {
                foldHierarchy.unlock();
            }
        }
        finally {
            this.getDocument().readUnlock();
        }
    }

    private void printFoldHierarchy(Fold fold, String string) {
        for (int i = 0; i < fold.getFoldCount(); ++i) {
            this.printFoldHierarchy(fold.getFold(i), string + "==");
        }
    }

    private void collectExistingFolds(Fold fold, List<Fold> list) {
        for (int i = 0; i < fold.getFoldCount(); ++i) {
            this.collectExistingFolds(fold.getFold(i), list);
        }
        if (!FoldUtilities.isRootFold((Fold)fold) && this.getOperation().owns(fold)) {
            list.add(fold);
        }
    }

    private Fold createFold(FoldType foldType, String string, boolean bl, int n, int n2, FoldHierarchyTransaction foldHierarchyTransaction) throws BadLocationException {
        Fold fold = null;
        if (n >= 0 && n2 >= 0 && n < n2 && n2 <= this.getDocument().getLength()) {
            fold = this.getOperation().addToHierarchy(foldType, string.intern(), bl, n, n2, string.length(), 0, null, foldHierarchyTransaction);
        }
        return fold;
    }

    private void createFolds(FoldHierarchyTransaction foldHierarchyTransaction) throws BadLocationException, IOException {
        BaseDocument baseDocument = this.getDocument();
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        Token token = tokenSequence.token();
        if (token != null && token.id() == XMLTokenId.TEXT && tokenSequence.moveNext()) {
            token = tokenSequence.token();
        }
        int n = 0;
        Stack<TokenElement> stack = new Stack<TokenElement>();
        String string = null;
        while (tokenSequence.moveNext()) {
            token = tokenSequence.token();
            XMLTokenId xMLTokenId = (XMLTokenId)token.id();
            String string2 = ((Object)token.text()).toString();
            TokenElement.TokenType tokenType = TokenElement.TokenType.TOKEN_WHITESPACE;
            switch (xMLTokenId) {
                case TAG: {
                    int n2;
                    int n3 = string2.length();
                    if (string2.charAt(n3 - 1) == '>') {
                        int n4;
                        TokenElement tokenElement = null;
                        if (n3 == 2) {
                            if (!stack.empty()) {
                                stack.pop();
                            }
                        } else if (!stack.empty() && ((TokenElement)stack.peek()).getName().equals(string)) {
                            tokenElement = (TokenElement)stack.pop();
                        }
                        if (tokenElement == null || this.isOneLiner(n2 = tokenElement.getStartOffset(), n4 = n + string2.length())) break;
                        String string3 = "<" + string + ">";
                        Fold fold = this.createFold(XmlFoldTypes.TAG, string3, false, n2, n4, foldHierarchyTransaction);
                        string = null;
                        break;
                    }
                    tokenType = TokenElement.TokenType.TOKEN_ELEMENT_START_TAG;
                    if (string2.startsWith("</")) {
                        String string4;
                        string = string4 = string2.substring(2);
                        break;
                    }
                    String string5 = string2.substring(1);
                    stack.push(new TokenElement(tokenType, string5, n, n + string2.length(), -1));
                    break;
                }
                case BLOCK_COMMENT: {
                    tokenType = TokenElement.TokenType.TOKEN_COMMENT;
                    if (string2.startsWith(TokenElement.Token.COMMENT_START.getValue()) && string2.endsWith(TokenElement.Token.COMMENT_END.getValue())) break;
                    if (string2.startsWith(TokenElement.Token.COMMENT_START.getValue())) {
                        String string6 = NbBundle.getMessage(XmlFoldManager.class, (String)"LBL_COMMENT");
                        stack.push(new TokenElement(tokenType, string6, n, n + string2.length(), -1));
                        break;
                    }
                    if (!string2.endsWith(TokenElement.Token.COMMENT_END.getValue())) break;
                    TokenElement tokenElement = (TokenElement)stack.pop();
                    int n5 = tokenElement.getStartOffset();
                    int n2 = n + string2.length();
                    Fold fold = this.createFold(XmlFoldTypes.COMMENT, tokenElement.getName(), false, n5, n2, foldHierarchyTransaction);
                    break;
                }
                case CDATA_SECTION: {
                    tokenType = TokenElement.TokenType.TOKEN_CDATA_VAL;
                    if (string2.startsWith(TokenElement.Token.CDATA_START.getValue()) && string2.endsWith(TokenElement.Token.CDATA_END.getValue())) break;
                    if (string2.startsWith(TokenElement.Token.CDATA_START.getValue())) {
                        String string7 = NbBundle.getMessage(XmlFoldManager.class, (String)"LBL_CDATA");
                        stack.push(new TokenElement(tokenType, string7, n, n + string2.length(), -1));
                        break;
                    }
                    if (!string2.endsWith(TokenElement.Token.CDATA_END.getValue())) break;
                    TokenElement tokenElement = (TokenElement)stack.pop();
                    int n6 = tokenElement.getStartOffset();
                    int n2 = n + string2.length();
                    Fold fold = this.createFold(XmlFoldTypes.CDATA, tokenElement.getName(), false, n6, n2, foldHierarchyTransaction);
                    break;
                }
                case PI_START: 
                case PI_TARGET: 
                case PI_CONTENT: 
                case PI_END: 
                case ARGUMENT: 
                case VALUE: 
                case TEXT: 
                case CHARACTER: 
                case WS: 
                case OPERATOR: 
                case DECLARATION: {
                    break;
                }
            }
            n += string2.length();
        }
    }

    public boolean isOneLiner(int n, int n2) {
        try {
            BaseDocument baseDocument = this.getDocument();
            return Utilities.getLineOffset((BaseDocument)baseDocument, (int)n) == Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

