/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.repository.ChangesetPanel;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ExportDiffPanel
extends JPanel
implements ActionListener {
    private File repository;
    private RequestProcessor.Task refreshViewTask;
    private Thread refreshViewThread;
    private static final RequestProcessor rp = new RequestProcessor("MercurialExportDiff", 1);
    private RepositoryRevision repoRev;
    private File fileToDiff;
    private HgLogMessage[] messages;
    private int fetchRevisionLimit = 7;
    private boolean bGettingRevisions = false;
    private File[] roots;
    private JButton browseButton;
    private ChangesetPanel changesetPanel1;
    private JLabel exportHintLabel;
    private JLabel fileLabel;
    private JLabel jLabel1;
    final JTextField outputFileTextField = new JTextField();
    private JComboBox revisionsComboBox;
    private JLabel revisionsLabel;

    public ExportDiffPanel(File file, RepositoryRevision repositoryRevision, File[] fileArray, File file2) {
        this.fileToDiff = file2;
        this.repoRev = repositoryRevision;
        this.roots = fileArray;
        this.repository = file;
        this.refreshViewTask = rp.create((Runnable)new RefreshViewTask());
        this.initComponents();
        this.revisionsComboBox.setMaximumRowCount(10);
        if (file2 != null) {
            Mnemonics.setLocalizedText((JLabel)this.revisionsLabel, (String)NbBundle.getMessage(ExportDiffPanel.class, (String)"ExportDiffPanel.revisionsLabel.text.forFileDiff"));
            this.exportHintLabel.setText(NbBundle.getMessage(ExportDiffPanel.class, (String)"ExportDiffPanel.exportHintLabel.text.forFileDiff"));
        }
        this.browseButton.addActionListener(this);
        this.refreshViewTask.schedule(0);
    }

    public String getSelectedRevision() {
        String string = (String)this.revisionsComboBox.getSelectedItem();
        if (string != null) {
            string = string.equals(NbBundle.getMessage(ExportDiffPanel.class, (String)"MSG_Fetching_Revisions")) ? "tip" : string.substring(0, string.indexOf(" "));
        }
        return string;
    }

    public String getOutputFileName() {
        return this.outputFileTextField.getText();
    }

    private void initComponents() {
        this.revisionsLabel = new JLabel();
        this.revisionsComboBox = new JComboBox();
        this.fileLabel = new JLabel();
        this.browseButton = new JButton();
        this.exportHintLabel = new JLabel();
        this.changesetPanel1 = new ChangesetPanel();
        this.jLabel1 = new JLabel();
        this.revisionsLabel.setLabelFor(this.revisionsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.revisionsLabel, (String)NbBundle.getMessage(ExportDiffPanel.class, (String)"ExportDiffPanel.revisionsLabel.text"));
        this.revisionsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportDiffPanel.this.revisionsComboBoxActionPerformed(actionEvent);
            }
        });
        this.fileLabel.setLabelFor(this.outputFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(ExportDiffPanel.class, (String)"ExportDiffPanel.fileLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ExportDiffPanel.class, (String)"ExportDiffPanel.browseButtonl.text"));
        this.exportHintLabel.setForeground(Color.gray);
        Mnemonics.setLocalizedText((JLabel)this.exportHintLabel, (String)NbBundle.getMessage(ExportDiffPanel.class, (String)"LBL_EXPORT_INFO"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ExportDiffPanel.class, (String)"ExportDiffPanel.jLabel1.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(20, 20, 20).add((Component)this.fileLabel).addPreferredGap(0).add((Component)this.outputFileTextField, -1, 228, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseButton)).add(1, (Component)this.jLabel1, -1, 437, Short.MAX_VALUE).add(1, (Component)this.exportHintLabel))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(34, 34, 34).add((Component)this.revisionsLabel).addPreferredGap(0).add((Component)this.revisionsComboBox, 0, 269, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.changesetPanel1, -1, 437, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(1).add((Component)this.exportHintLabel).add(20, 20, 20).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.revisionsComboBox, -2, 25, -2).add((Component)this.revisionsLabel)).add(18, 18, 18).add((Component)this.changesetPanel1, -2, 152, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.browseButton).add((Component)this.fileLabel).add((Component)this.outputFileTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.revisionsComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportDiffPanel.class, (String)"ACSD_revisionsComboBox"));
        this.outputFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportDiffPanel.class, (String)"ACSD_outputFileTextField"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportDiffPanel.class, (String)"ACSD_browseButton"));
    }

    private void revisionsComboBoxActionPerformed(ActionEvent actionEvent) {
        int n = this.revisionsComboBox.getSelectedIndex();
        if (this.getMore((String)this.revisionsComboBox.getSelectedItem())) {
            return;
        }
        if (this.messages != null && n >= 0 && n < this.messages.length) {
            this.changesetPanel1.setInfo(this.messages[n]);
        }
    }

    private boolean getMore(String string) {
        if (this.bGettingRevisions) {
            return false;
        }
        boolean bl = false;
        int n = -1;
        if (string != null && string.equals(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_20_Revisions"))) {
            bl = true;
            n = 20;
        } else if (string != null && string.equals(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_50_Revisions"))) {
            bl = true;
            n = 50;
        } else if (string != null && string.equals(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_All_Revisions"))) {
            bl = true;
            n = -1;
        }
        if (bl && !this.bGettingRevisions) {
            this.fetchRevisionLimit = n;
            RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(this.repository);
            HgProgressSupport hgProgressSupport = new HgProgressSupport(){

                public void perform() {
                    ExportDiffPanel.this.changesetPanel1.clearInfo();
                    ExportDiffPanel.this.refreshRevisions();
                }
            };
            hgProgressSupport.start(requestProcessor, this.repository.getAbsolutePath(), NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetching_Revisions"));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupModels() {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ExportDiffPanel.class, (String)"MSG_Fetching_Revisions"));
        try {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            if (this.repoRev != null) {
                String string = this.repoRev.getLog().getRevision() + " (" + this.repoRev.getLog().getCSetShortID() + ")";
                if (this.fileToDiff != null) {
                    string = this.fileToDiff.getName() + " - " + string;
                }
                linkedHashSet.add(string);
                DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(linkedHashSet));
                this.revisionsComboBox.setModel(defaultComboBoxModel);
                this.revisionsComboBox.setEditable(false);
                this.setDefaultOutputFile();
                this.refreshViewThread = Thread.currentThread();
                this.changesetPanel1.setInfo(this.repoRev.getLog());
                Thread.interrupted();
                progressHandle.start();
            } else {
                linkedHashSet.add(NbBundle.getMessage(ExportDiffPanel.class, (String)"MSG_Fetching_Revisions"));
                DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(linkedHashSet));
                this.revisionsComboBox.setModel(defaultComboBoxModel);
                this.setDefaultOutputFile();
                this.refreshViewThread = Thread.currentThread();
                Thread.interrupted();
                progressHandle.start();
                this.refreshRevisions();
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SwingUtilities.invokeLater(new Runnable(progressHandle){
                final /* synthetic */ ProgressHandle val$ph;
                {
                    this.val$ph = progressHandle;
                }

                public void run() {
                    this.val$ph.finish();
                    ExportDiffPanel.this.refreshViewThread = null;
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void setDefaultOutputFile() {
        String string;
        String string2 = HgModuleConfig.getDefault().getExportFolder();
        if (this.fileToDiff != null && this.repoRev != null && this.repoRev.getLog() != null && this.repository != null) {
            string = this.fileToDiff.getName().replace('.', '-') + "_" + this.repoRev.getLog().getRevision() + "_" + this.repoRev.getLog().getCSetShortID();
        } else if (this.repoRev != null && this.repoRev.getLog() != null && this.repository != null) {
            string = HgModuleConfig.getDefault().getExportFilename().replace("%b", this.repository.getName());
            string = string.replace("%r", this.repoRev.getLog().getRevision());
            string = string.replace("%h", this.repoRev.getLog().getCSetShortID());
        } else {
            string = this.repository != null ? HgModuleConfig.getDefault().getExportFilename().replace("%b", this.repository.getName()) : HgModuleConfig.getDefault().getExportFilename();
        }
        File file = new File(string2, string + ".patch");
        this.outputFileTextField.setText(file.getAbsolutePath());
    }

    private void refreshRevisions() {
        this.bGettingRevisions = true;
        OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
        HashSet<File> hashSet = new HashSet<File>(Arrays.asList(this.roots));
        this.messages = HgCommand.getLogMessagesNoFileInfo(this.repository.getAbsolutePath(), hashSet, this.fetchRevisionLimit, outputLogger);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.messages == null) {
            boolean bl = false;
            linkedHashSet.add(NbBundle.getMessage(ExportDiffPanel.class, (String)"MSG_Revision_Default"));
        } else {
            int n = this.messages.length;
            for (int i = 0; i < n; ++i) {
                linkedHashSet.add(this.messages[i].getRevision() + " (" + this.messages[i].getCSetShortID() + ")");
            }
        }
        if (linkedHashSet.size() > 0) {
            linkedHashSet.add(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_20_Revisions"));
            linkedHashSet.add(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_50_Revisions"));
            linkedHashSet.add(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_All_Revisions"));
        }
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(linkedHashSet));
        this.revisionsComboBox.setModel(defaultComboBoxModel);
        if (linkedHashSet.size() > 0) {
            this.revisionsComboBox.setSelectedIndex(0);
        }
        this.bGettingRevisions = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.browseButton) {
            this.onBrowseClick();
        }
    }

    private void onBrowseClick() {
        Object object;
        File file = null;
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(ExportDiffPanel.class, (String)"ACSD_BrowseFolder"), file);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(ExportDiffPanel.class, (String)"Browse_title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilterArray = accessibleJFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            object = fileFilterArray[i];
            accessibleJFileChooser.removeChoosableFileFilter((FileFilter)object);
        }
        accessibleJFileChooser.setDialogType(1);
        accessibleJFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(ExportDiffPanel.class, (String)"OK_Button").charAt(0));
        accessibleJFileChooser.setApproveButtonText(NbBundle.getMessage(ExportDiffPanel.class, (String)"OK_Button"));
        accessibleJFileChooser.setCurrentDirectory(new File(HgModuleConfig.getDefault().getExportFolder()));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)accessibleJFileChooser, NbBundle.getMessage(ExportDiffPanel.class, (String)"Browse_title"));
        dialogDescriptor.setOptions(new Object[0]);
        object = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        accessibleJFileChooser.addActionListener(new ActionListener((JFileChooser)accessibleJFileChooser, (Dialog)object){
            final /* synthetic */ JFileChooser val$fileChooser;
            final /* synthetic */ Dialog val$dialog;
            {
                this.val$fileChooser = jFileChooser;
                this.val$dialog = dialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                String string = actionEvent.getActionCommand();
                if (string.equals("ApproveSelection") && (file = this.val$fileChooser.getSelectedFile()) != null) {
                    ExportDiffPanel.this.outputFileTextField.setText(file.getAbsolutePath());
                }
                this.val$dialog.dispose();
            }
        });
        ((Dialog)object).setVisible(true);
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        public void run() {
            ExportDiffPanel.this.setupModels();
        }
    }
}

