/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.BorderLayout;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.log.SearchCriteriaPanel;
import org.netbeans.modules.mercurial.ui.log.SearchExecutor;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class SearchHistoryTopComponent
extends TopComponent
implements DiffSetupSource {
    private SearchHistoryPanel shp;
    private SearchCriteriaPanel scp;

    public SearchHistoryTopComponent() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSN_SearchHistoryT_Top_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSD_SearchHistoryT_Top_Component"));
    }

    public SearchHistoryTopComponent(VCSContext vCSContext) {
        this(vCSContext, null, null, null, null);
    }

    public SearchHistoryTopComponent(VCSContext vCSContext, String string, String string2, Date date, Date date2) {
        this();
        File[] fileArray = vCSContext.getRootFiles().toArray(new File[0]);
        this.initComponents(fileArray, string, string2, date, date2);
    }

    public SearchHistoryTopComponent(String string, File file, long l) {
        this();
        this.initComponents(string, file, l);
    }

    public void search() {
        this.shp.executeSearch();
        this.shp.setSearchCriteria(false);
    }

    public void searchOut() {
        this.shp.setOutSearch();
        this.scp.setTo("");
    }

    public void searchIncoming() {
        this.shp.setIncomingSearch();
        this.scp.setTo("");
    }

    private void initComponents(String string, File file, long l) {
        this.setLayout(new BorderLayout());
        this.scp = new SearchCriteriaPanel(string);
        this.scp.setFrom(Long.toString(l));
        this.scp.setTo(Long.toString(l));
        this.shp = new SearchHistoryPanel(string, file, this.scp);
        this.add(this.shp);
    }

    private void initComponents(File[] fileArray, String string, String string2, Date date, Date date2) {
        this.setLayout(new BorderLayout());
        this.scp = new SearchCriteriaPanel(fileArray);
        this.scp.setCommitMessage(string);
        this.scp.setUsername(string2);
        if (date != null) {
            this.scp.setFrom(SearchExecutor.simpleDateFormat.format(date));
        }
        if (date2 != null) {
            this.scp.setTo(SearchExecutor.simpleDateFormat.format(date2));
        }
        this.shp = new SearchHistoryPanel(fileArray, this.scp);
        this.add(this.shp);
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    protected String preferredID() {
        if (this.shp.isIncomingSearch()) {
            return "Hg.IncomingSearchHistoryTopComponent";
        }
        if (this.shp.isOutSearch()) {
            return "Hg.OutSearchHistoryTopComponent";
        }
        return "Hg.SearchHistoryTopComponent";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public Collection getSetups() {
        return this.shp.getSetups();
    }

    public String getSetupDisplayName() {
        return this.getDisplayName();
    }
}

