/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.pull;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.ui.push.PushAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgRepositoryContextCache;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PullAction
extends ContextAction {
    private static final String CHANGESET_FILES_PREFIX = "files:";
    private final VCSContext context;

    public PullAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    @Override
    public void performAction(ActionEvent actionEvent) {
        File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TITLE_SEP"));
            outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_NOT_SUPPORTED_INVIEW_INFO"));
            outputLogger.output("");
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            outputLogger.closeLog();
            return;
        }
        PullAction.pull(this.context);
    }

    public static boolean confirmWithLocalChanges(File file, Class clazz, String string, String string2, List<String> list, OutputLogger outputLogger) {
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        File[] fileArray = new File[]{file};
        File[] fileArray2 = fileStatusCache.listFiles(fileArray, 84);
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        String string3 = file.getAbsolutePath();
        for (String string4 : list) {
            String string5;
            String[] stringArray;
            String[] stringArray2;
            int n;
            int n2;
            if (string4.indexOf(CHANGESET_FILES_PREFIX) != 0 || (n2 = 0) >= (n = (stringArray2 = (stringArray = (string5 = string4.substring(CHANGESET_FILES_PREFIX.length()).trim()).split(" "))).length)) continue;
            String string6 = stringArray2[n2];
            hashSet.add(string3 + File.separator + string6);
        }
        for (File file2 : fileArray2) {
            for (String string6 : hashSet) {
                if (!string6.equals(file2.getAbsolutePath())) continue;
                arrayList.add(string6);
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_OVERWRITE_LOCAL"));
            outputLogger.output(arrayList);
            int n = JOptionPane.showOptionDialog(null, NbBundle.getMessage((Class)clazz, (String)string2), NbBundle.getMessage((Class)clazz, (String)string), 0, 3, null, null, null);
            if (n == 1) {
                return false;
            }
        }
        return true;
    }

    static void annotateChangeSets(List<String> list, Class clazz, String string) {
        InputOutput inputOutput = IOProvider.getDefault().getIO(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE, false);
        inputOutput.select();
        OutputWriter outputWriter = inputOutput.getOut();
        OutputWriter outputWriter2 = inputOutput.getErr();
        outputWriter2.println(NbBundle.getMessage((Class)clazz, (String)string));
        for (String string2 : list) {
            if (string2.indexOf("changeset:") == 0) {
                outputWriter2.println(string2);
                continue;
            }
            if (string2.equals("")) continue;
            outputWriter.println(string2);
        }
        outputWriter.println("");
        outputWriter.close();
        outputWriter2.close();
    }

    public static void pull(final VCSContext vCSContext) {
        final File file = HgUtils.getRootFile(vCSContext);
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(string);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                PullAction.getDefaultAndPerformPull(vCSContext, file, this.getLogger());
            }
        };
        hgProgressSupport.start(requestProcessor, string, NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_PROGRESS"));
    }

    @Override
    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }

    static void getDefaultAndPerformPull(VCSContext vCSContext, File file, OutputLogger outputLogger) {
        String string = HgRepositoryContextCache.getPullDefault(vCSContext);
        if (string == null) {
            outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TITLE_SEP"));
            outputLogger.output(NbBundle.getMessage(PullAction.class, (String)"MSG_NO_DEFAULT_PULL_SET_MSG"));
            outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_DONE"));
            outputLogger.output("");
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(PullAction.class, (String)"MSG_NO_DEFAULT_PULL_SET"), NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TITLE"), 1);
            return;
        }
        String string2 = HgProjectUtils.getProjectName(new File(string));
        Project project = HgUtils.getProject(vCSContext);
        String string3 = HgProjectUtils.getProjectName(project);
        PullAction.performPull(string2 != null ? PullType.LOCAL : PullType.OTHER, vCSContext, file, string, string2, string3, outputLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void performPull(PullType pullType, VCSContext vCSContext, File file, String string, String string2, String string3, OutputLogger outputLogger) {
        File file2;
        block36: {
            block35: {
                block34: {
                    if (file == null) return;
                    if (string == null) {
                        return;
                    }
                    file2 = null;
                    try {
                        try {
                            int n;
                            List<String> list;
                            block38: {
                                block37: {
                                    outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TITLE"));
                                    outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TITLE_SEP"));
                                    if (string2 != null) {
                                        outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULLING_FROM", (Object)string2, (Object)HgUtils.stripDoubleSlash(HgUtils.replaceHttpPassword(string))));
                                    } else {
                                        outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULLING_FROM_NONAME", (Object)HgUtils.stripDoubleSlash(HgUtils.replaceHttpPassword(string))));
                                    }
                                    if (pullType == PullType.LOCAL) {
                                        list = HgCommand.doIncoming(file, outputLogger);
                                    } else {
                                        for (n = 0; n < 10000; ++n) {
                                            if (new File(file.getParentFile(), file.getName() + "_bundle" + n).exists()) continue;
                                            file2 = new File(file.getParentFile(), file.getName() + "_bundle" + n);
                                            break;
                                        }
                                        list = HgCommand.doIncoming(file, string, file2, outputLogger);
                                    }
                                    if (list == null) break block37;
                                    if (!list.isEmpty()) break block38;
                                }
                                Object var15_12 = null;
                                if (file2 != null) {
                                    file2.delete();
                                }
                                break block34;
                            }
                            n = HgCommand.isNoChanges(list.get(list.size() - 1)) ? 1 : 0;
                            if (n == 0 && !PullAction.confirmWithLocalChanges(file, PullAction.class, "MSG_PULL_LOCALMODS_CONFIRM_TITLE", "MSG_PULL_LOCALMODS_CONFIRM_QUERY", list, outputLogger)) {
                                outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_LOCALMODS_CANCEL"));
                                outputLogger.output("");
                                break block35;
                            }
                            List<String> list2 = n != 0 ? list : (pullType == PullType.LOCAL ? HgCommand.doPull(file, outputLogger) : HgCommand.doUnbundle(file, file2, outputLogger));
                            if (list2 != null && !list2.isEmpty()) {
                                if (n == 0) {
                                    PullAction.annotateChangeSets(HgUtils.replaceHttpPassword(list), PullAction.class, "MSG_CHANGESETS_TO_PULL");
                                }
                                outputLogger.output(HgUtils.replaceHttpPassword(list2));
                                if (string2 != null) {
                                    outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_FROM", (Object)string2, (Object)HgUtils.stripDoubleSlash(HgUtils.replaceHttpPassword(string))));
                                } else {
                                    outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_FROM_NONAME", (Object)HgUtils.stripDoubleSlash(HgUtils.replaceHttpPassword(string))));
                                }
                                if (string3 != null) {
                                    outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TO", (Object)string3, (Object)file));
                                } else {
                                    outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TO_NONAME", (Object)file));
                                }
                                boolean bl = HgCommand.isMergeNeededMsg(list2.get(list2.size() - 1));
                                boolean bl2 = false;
                                if (bl) {
                                    bl2 = HgUtils.confirmDialog(PullAction.class, "MSG_PULL_MERGE_CONFIRM_TITLE", "MSG_PULL_MERGE_CONFIRM_QUERY");
                                } else {
                                    boolean bl3 = HgCommand.isMergeAbortUncommittedMsg(list2.get(list2.size() - 1));
                                    if (bl3) {
                                        bl2 = HgUtils.confirmDialog(PullAction.class, "MSG_PULL_MERGE_CONFIRM_TITLE", "MSG_PULL_MERGE_UNCOMMITTED_CONFIRM_QUERY");
                                    }
                                }
                                if (bl2) {
                                    outputLogger.output("");
                                    outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_MERGE_DO"));
                                    MergeAction.doMergeAction(file, null, outputLogger);
                                } else {
                                    List<String> list3 = HgCommand.getHeadRevisions(file);
                                    if (list3 != null && list3.size() > 1) {
                                        MergeAction.printMergeWarning(list3, outputLogger);
                                    }
                                }
                            }
                            if (n == 0) {
                                PushAction.notifyUpdatedFiles(file, list2);
                                HgUtils.forceStatusRefreshProject(vCSContext);
                                FileObject fileObject = FileUtil.toFileObject((File)file);
                                try {
                                    fileObject.getFileSystem().refresh(true);
                                }
                                catch (Exception exception) {
                                }
                            }
                            break block36;
                        }
                        catch (HgException hgException) {
                            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                            Object var15_15 = null;
                            if (file2 != null) {
                                file2.delete();
                            }
                            outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_DONE"));
                            outputLogger.output("");
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_16 = null;
                        if (file2 != null) {
                            file2.delete();
                        }
                        outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_DONE"));
                        outputLogger.output("");
                        throw throwable;
                    }
                }
                outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_DONE"));
                outputLogger.output("");
                return;
            }
            Object var15_13 = null;
            if (file2 != null) {
                file2.delete();
            }
            outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_DONE"));
            outputLogger.output("");
            return;
        }
        Object var15_14 = null;
        if (file2 != null) {
            file2.delete();
        }
        outputLogger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_DONE"));
        outputLogger.output("");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PullType {
        LOCAL,
        OTHER;

    }
}

