/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.push;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.push.PushAction;
import org.netbeans.modules.mercurial.ui.repository.Repository;
import org.netbeans.modules.mercurial.ui.wizards.CloneRepositoryWizardPanel;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PushOtherAction
extends ContextAction
implements PropertyChangeListener {
    private final VCSContext context;
    private Repository repository = null;
    private JButton pushButton = null;
    private JButton cancelButton = null;

    public PushOtherAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        String string;
        File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            return;
        }
        if (this.repository == null) {
            int n = 102;
            string = NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Location");
            this.repository = new Repository(n, string, true);
            this.repository.addPropertyChangeListener(this);
        }
        this.pushButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.pushButton, (String)NbBundle.getMessage(PushOtherAction.class, (String)"CTL_Push_Action_Push"));
        this.pushButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PushOtherAction.class, (String)"ACSD_Push_Action_Push"));
        this.pushButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PushOtherAction.class, (String)"ACSN_Push_Action_Push"));
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(PushOtherAction.class, (String)"CTL_Push_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PushOtherAction.class, (String)"ACSD_Push_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PushOtherAction.class, (String)"ACSN_Push_Action_Cancel"));
        this.pushButton.setEnabled(false);
        Object object = this.repository.show(NbBundle.getMessage(PushOtherAction.class, (String)"CTL_PushDialog_Title"), new HelpCtx(PushOtherAction.class), new Object[]{this.pushButton, this.cancelButton}, true, "hg.push.dialog");
        if (object == this.pushButton) {
            string = this.repository.getSelectedRC().getUrl();
            PushOtherAction.push(this.context, file, string);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("valid")) {
            this.pushButton.setEnabled(this.repository.isValid());
        }
    }

    public static void push(VCSContext vCSContext, final File file, final String string) {
        if (file == null || string == null) {
            return;
        }
        String string2 = file.getAbsolutePath();
        final String string3 = HgProjectUtils.getProjectName(file);
        final String string4 = NbBundle.getMessage(PushAction.class, (String)"MSG_EXTERNAL_REPOSITORY");
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                PushAction.performPush(file, string, string3, string4, this.getLogger());
            }
        };
        hgProgressSupport.start(requestProcessor, string2, NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_PROGRESS"));
    }

    public boolean isEnabled() {
        Set set;
        Set set2 = set = this.context != null ? this.context.getRootFiles() : null;
        return HgUtils.getRootFile(this.context) != null && set != null && set.size() != 0;
    }
}

